/*
 * Decompiled with CFR 0.152.
 */
package com.product.storage.slice.filter;

import com.alibaba.druid.util.StringUtils;
import com.product.storage.slice.filter.CollectionSQLWrapper;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionSliceWrapper
extends CollectionSQLWrapper {
    public static final Logger logger = LoggerFactory.getLogger(CollectionSliceWrapper.class);

    protected boolean isWrapper(String sqlSelect, String organizationCode) {
        String message = "";
        if (this.getOrganizationMap().containsKey(organizationCode)) {
            message = String.format("\u7ec4\u7ec7\u673a\u6784\u3010%1$s\u3011\u5b58\u5728\u5206\u7247\u5b9a\u4e49", organizationCode);
            String[] sqlKeys = sqlSelect.split("[\\s]+");
            Set<String> collectionSet = this.getCollectionMap().keySet();
            for (String collectionName : collectionSet) {
                for (String key : sqlKeys) {
                    if (!key.toLowerCase().equals(collectionName)) continue;
                    logger.info("--->{},\u5339\u914d\u8868:{}", (Object)message, (Object)collectionName);
                    return true;
                }
            }
        }
        message = String.format("--->\u7ec4\u7ec7\u673a\u6784\u3010%1$s\u3011\u4e0d\u5b58\u5728\u5206\u7247\u5b9a\u4e49\u4e14\u8868\u4e0d\u9700\u8981\u5206\u7247", organizationCode);
        logger.info(message);
        return false;
    }

    protected String getPartionWhere(String collectionName, String collectionAlias, String organizationCode) {
        String response = "";
        String tableName = collectionName.toLowerCase();
        if (this.getCollectionMap().keySet().contains(tableName)) {
            String fieldName = this.getCollectionMap().get(tableName);
            if (this.getOrganizationMap().containsKey(organizationCode)) {
                String partionKey = this.getOrganizationMap().get(organizationCode);
                response = !StringUtils.isEmpty((CharSequence)collectionAlias) ? String.format("%1$s.%2$s = '%3$s'", collectionAlias, fieldName, partionKey) : String.format("%1$s = '%2$s'", fieldName, partionKey);
            }
        }
        return response;
    }
}

