/*
 * Decompiled with CFR 0.152.
 */
package com.product.storage.slice.filter;

import com.product.util.SpringContext;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;

public class SliceBase {
    protected static Logger log = LoggerFactory.getLogger(SliceBase.class);
    private DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static Map<String, String> organizationMap;
    private static Map<String, String> collectionMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initOrganizationMap(RedisConnection conn) {
        long beginTimeMillis = System.currentTimeMillis();
        try {
            Set zSet = conn.zRange("posshop:log:update".getBytes(), 0L, -1L);
            conn.openPipeline();
            Iterator iter = zSet.iterator();
            while (iter.hasNext()) {
                String organizationCode = new String((byte[])iter.next());
                String hashKey = String.format("posshop:log:%1$s", organizationCode);
                conn.hGetAll(hashKey.getBytes());
            }
            List resultList = conn.closePipeline();
            for (Object item : resultList) {
                Map dataMap = (Map)item;
                String organizationCode = new String((byte[])dataMap.get("organizationCode".getBytes()));
                String splitCode = new String((byte[])dataMap.get("splitCode".getBytes()));
                organizationMap.put(organizationCode, splitCode);
            }
        }
        catch (Exception e) {
            try {
                if (conn.isPipelined()) {
                    conn.closePipeline();
                }
                log.info(e.getMessage());
            }
            catch (Throwable throwable) {
                long endTimeMillis = System.currentTimeMillis();
                log.info(String.format("SliceBase.initOrganizationMap() ---> starttime->[%1$s] endtime->[%2$s] usetime->[%3$d] timestamp->[%4$s]", this.formatter.format(new Date(beginTimeMillis)), this.formatter.format(new Date(endTimeMillis)), endTimeMillis - beginTimeMillis, this.formatter.format(new Date())));
                throw throwable;
            }
            long endTimeMillis = System.currentTimeMillis();
            log.info(String.format("SliceBase.initOrganizationMap() ---> starttime->[%1$s] endtime->[%2$s] usetime->[%3$d] timestamp->[%4$s]", this.formatter.format(new Date(beginTimeMillis)), this.formatter.format(new Date(endTimeMillis)), endTimeMillis - beginTimeMillis, this.formatter.format(new Date())));
        }
        long endTimeMillis = System.currentTimeMillis();
        log.info(String.format("SliceBase.initOrganizationMap() ---> starttime->[%1$s] endtime->[%2$s] usetime->[%3$d] timestamp->[%4$s]", this.formatter.format(new Date(beginTimeMillis)), this.formatter.format(new Date(endTimeMillis)), endTimeMillis - beginTimeMillis, this.formatter.format(new Date())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCollectionMap(RedisConnection conn) {
        long beginTimeMillis = System.currentTimeMillis();
        try {
            Set zSet = conn.zRange("collection:log:update".getBytes(), 0L, -1L);
            conn.openPipeline();
            Iterator iter = zSet.iterator();
            while (iter.hasNext()) {
                String collectionName = new String((byte[])iter.next());
                String hashKey = String.format("collection:log:%1$s", collectionName);
                conn.hGetAll(hashKey.getBytes());
            }
            List resultList = conn.closePipeline();
            for (Object item : resultList) {
                Map dataMap = (Map)item;
                String collectionName = new String((byte[])dataMap.get("collection".getBytes()));
                String fieldname = new String((byte[])dataMap.get("fieldname".getBytes()));
                collectionMap.put(collectionName, fieldname);
            }
        }
        catch (Exception e) {
            try {
                if (conn.isPipelined()) {
                    conn.closePipeline();
                }
                log.info(e.getMessage());
            }
            catch (Throwable throwable) {
                long endTimeMillis = System.currentTimeMillis();
                log.info(String.format("SliceBase.initCollectionMap() ---> starttime->[%1$s] endtime->[%2$s] usetime->[%3$d] timestamp->[%4$s]", this.formatter.format(new Date(beginTimeMillis)), this.formatter.format(new Date(endTimeMillis)), endTimeMillis - beginTimeMillis, this.formatter.format(new Date())));
                throw throwable;
            }
            long endTimeMillis = System.currentTimeMillis();
            log.info(String.format("SliceBase.initCollectionMap() ---> starttime->[%1$s] endtime->[%2$s] usetime->[%3$d] timestamp->[%4$s]", this.formatter.format(new Date(beginTimeMillis)), this.formatter.format(new Date(endTimeMillis)), endTimeMillis - beginTimeMillis, this.formatter.format(new Date())));
        }
        long endTimeMillis = System.currentTimeMillis();
        log.info(String.format("SliceBase.initCollectionMap() ---> starttime->[%1$s] endtime->[%2$s] usetime->[%3$d] timestamp->[%4$s]", this.formatter.format(new Date(beginTimeMillis)), this.formatter.format(new Date(endTimeMillis)), endTimeMillis - beginTimeMillis, this.formatter.format(new Date())));
    }

    private synchronized void init() {
        if (organizationMap == null) {
            organizationMap = new HashMap<String, String>();
        }
        if (collectionMap == null) {
            collectionMap = new HashMap<String, String>();
        }
        try (RedisConnection conn = this.getConnection(false);){
            this.initOrganizationMap(conn);
            this.initCollectionMap(conn);
        }
    }

    public Map<String, String> getCollectionMap() {
        if (collectionMap == null || organizationMap == null) {
            this.init();
        }
        if (collectionMap.isEmpty() || organizationMap.isEmpty()) {
            this.init();
        }
        return collectionMap;
    }

    public Map<String, String> getOrganizationMap() {
        if (collectionMap == null || organizationMap == null) {
            this.init();
        }
        if (collectionMap.isEmpty() || organizationMap.isEmpty()) {
            this.init();
        }
        return organizationMap;
    }

    private RedisConnection getConnection(boolean enableTransactionSupport) {
        RedisConnection response = ((RedisConnectionFactory)SpringContext.getContext().getBean("jedisConnectionFactory", RedisConnectionFactory.class)).getConnection();
        if (enableTransactionSupport) {
            response.multi();
        }
        return response;
    }
}

