/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.isce.tms.assign;

import com.efuture.isce.tms.assign.CustInfo;
import com.efuture.isce.tms.assign.TmTransDispatchData;
import com.efuture.isce.tms.assign.TmTransPool;
import com.efuture.isce.tms.enums.LpnTypeEnum;
import com.efuture.isce.tms.enums.MixedDispatchMainCustTypeEnum;
import com.efuture.isce.tms.trans.TmCarPool;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class CarSendPlan
implements Serializable {
    private final Map<String, List<TmTransDispatchData>> custDispatchMap = Maps.newLinkedHashMap();
    private final List<CustInfo> custList = Lists.newArrayList();
    private TmCarPool car;
    private BigDecimal loadRate;
    private Integer surplusLoadNumber;
    private double score;
    private String planSheetId;
    private String mainCustId;
    private MixedDispatchMainCustTypeEnum mainCustType;
    private String mainCustFromDcShop;
    @Deprecated
    private List<TmTransPool> tmTrans;

    public CarSendPlan() {
    }

    public CarSendPlan(TmCarPool car) {
        this.car = car;
    }

    public void addMainCust(String custId, MixedDispatchMainCustTypeEnum mainCustType, List<TmTransDispatchData> dispatchDataList) {
        if (!StringUtils.isEmpty((Object)this.mainCustId) || CollectionUtils.isEmpty(dispatchDataList)) {
            return;
        }
        CustInfo custInfo = new CustInfo();
        custInfo.setCustId(custId);
        custInfo.setIsMainCust(true);
        this.custList.add(custInfo);
        if (mainCustType == null) {
            mainCustType = MixedDispatchMainCustTypeEnum.NONE;
        }
        this.mainCustType = mainCustType;
        this.mainCustId = custId;
        this.mainCustFromDcShop = dispatchDataList.get(0).getFmcustid();
        this.addCustDispatchData(custId, dispatchDataList);
    }

    public void addPickUpCust(String custId, List<TmTransDispatchData> dispatchDataList) {
        if (StringUtils.isEmpty((Object)this.mainCustId) || this.mainCustId.equals(custId) || CollectionUtils.isEmpty(dispatchDataList)) {
            return;
        }
        CustInfo custInfo = new CustInfo();
        custInfo.setCustId(custId);
        custInfo.setIsMainCust(false);
        this.custList.add(custInfo);
        this.addCustDispatchData(custId, dispatchDataList);
    }

    private void addCustDispatchData(String custId, List<TmTransDispatchData> dispatchDataList) {
        if (CollectionUtils.isEmpty(dispatchDataList)) {
            return;
        }
        this.custDispatchMap.put(custId, dispatchDataList);
        this.calculateData();
    }

    public List<TmTransDispatchData> getAllDispatchData() {
        return this.custDispatchMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public int getMainCustDispatchDataSize() {
        return this.getMainCustDispatchData().size();
    }

    public List<TmTransDispatchData> getMainCustDispatchData() {
        return this.custDispatchMap.getOrDefault(this.mainCustId, Lists.newArrayList());
    }

    public Integer getMainCustLpnType() {
        return this.getMainCustDispatchData().get(0).getLpntype();
    }

    public CustInfo getLastCust() {
        return CollectionUtils.isEmpty(this.custList) ? null : this.custList.get(this.custList.size() - 1);
    }

    public long getTemperatureCount() {
        return this.getAllDispatchData().stream().map(TmTransDispatchData::getTemptype).distinct().count();
    }

    private void calculateData() {
        List<TmTransDispatchData> dataList = this.getAllDispatchData();
        if (CollectionUtils.isEmpty(dataList)) {
            this.loadRate = BigDecimal.ZERO;
            return;
        }
        TmTransDispatchData data = dataList.get(0);
        Integer maxSize = data.getLpntype().equals(LpnTypeEnum.PALLET.value()) ? this.car.getCarTypeLoad().getMaxpalqty() : this.car.getCarTypeLoad().getMaxrollqty();
        this.surplusLoadNumber = maxSize - dataList.size();
        this.loadRate = BigDecimal.valueOf(dataList.size()).divide(BigDecimal.valueOf(maxSize.intValue()), 2, RoundingMode.HALF_UP);
    }

    public Map<String, List<TmTransDispatchData>> getCustDispatchMap() {
        return this.custDispatchMap;
    }

    public List<CustInfo> getCustList() {
        return this.custList;
    }

    public TmCarPool getCar() {
        return this.car;
    }

    public BigDecimal getLoadRate() {
        return this.loadRate;
    }

    public Integer getSurplusLoadNumber() {
        return this.surplusLoadNumber;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public double getScore() {
        return this.score;
    }

    public void setPlanSheetId(String planSheetId) {
        this.planSheetId = planSheetId;
    }

    public String getPlanSheetId() {
        return this.planSheetId;
    }

    public String getMainCustId() {
        return this.mainCustId;
    }

    public MixedDispatchMainCustTypeEnum getMainCustType() {
        return this.mainCustType;
    }

    public String getMainCustFromDcShop() {
        return this.mainCustFromDcShop;
    }

    @Deprecated
    public void setTmTrans(List<TmTransPool> tmTrans) {
        this.tmTrans = tmTrans;
    }

    @Deprecated
    public List<TmTransPool> getTmTrans() {
        return this.tmTrans;
    }
}

