/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.isce.tms.assign;

import com.efuture.isce.tms.assign.TmTransDispatchData;
import com.google.common.collect.Lists;
import com.product.exception.ServiceRuntimeException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class TransDispatchSummaryData {
    private String uniqueKey;
    private String entid;
    private String parkid;
    private String waveno;
    private String lpntypeid;
    private String lpntypename;
    private Integer lpntype;
    private String fmcustid;
    private String fmcustname;
    private String tocustid;
    private String tocustname;
    private String cellno;
    private Integer temptype;
    private String serviceareaid;
    private Integer totalBoxQty = 0;
    private BigDecimal totalWeight = BigDecimal.ZERO;
    private BigDecimal totalVolume = BigDecimal.ZERO;
    private Integer lpnNumber = 0;
    private Integer dispatchLpnNumber = 0;
    private Integer surplusLpnNumber = 0;
    private Set<TmTransDispatchData> dataSet = new HashSet<TmTransDispatchData>();
    private String planSheetId;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransDispatchSummaryData that = (TransDispatchSummaryData)o;
        return this.uniqueKey.equals(that.uniqueKey);
    }

    public int hashCode() {
        return Objects.hash(this.uniqueKey);
    }

    public void addData(TmTransDispatchData data) {
        TransDispatchSummaryData transDispatchSummaryData = this;
        Integer n = transDispatchSummaryData.lpnNumber;
        Integer n2 = transDispatchSummaryData.lpnNumber = Integer.valueOf(transDispatchSummaryData.lpnNumber + 1);
        transDispatchSummaryData = this;
        n = transDispatchSummaryData.surplusLpnNumber;
        n2 = transDispatchSummaryData.surplusLpnNumber = Integer.valueOf(transDispatchSummaryData.surplusLpnNumber + 1);
        transDispatchSummaryData = this;
        transDispatchSummaryData.totalBoxQty = transDispatchSummaryData.totalBoxQty + data.getBoxqty();
        this.totalWeight = this.totalWeight.add(data.getWeight());
        this.totalVolume = this.totalVolume.add(data.getVolume());
        this.dataSet.add(data);
    }

    public List<TmTransDispatchData> dispatch(Integer number) {
        if (this.dispatchLpnNumber + number > this.lpnNumber) {
            throw new ServiceRuntimeException("\u96c6\u8d27\u5355[" + this.uniqueKey + "]\u5269\u4f59\u5bb9\u5668\u6570\u4e0d\u8db3");
        }
        TransDispatchSummaryData transDispatchSummaryData = this;
        transDispatchSummaryData.dispatchLpnNumber = transDispatchSummaryData.dispatchLpnNumber + number;
        this.surplusLpnNumber = this.lpnNumber - this.dispatchLpnNumber;
        return this.getNotDispatchData(number, true);
    }

    public List<TmTransDispatchData> dispatchNotUpdate(Integer number) {
        if (this.dispatchLpnNumber + number > this.lpnNumber) {
            throw new ServiceRuntimeException("\u96c6\u8d27\u6c47\u603b\u5355[" + this.uniqueKey + "]\u5269\u4f59\u5bb9\u5668\u6570\u4e0d\u8db3");
        }
        return this.getNotDispatchData(number, false);
    }

    public List<TmTransDispatchData> dispatchAll() {
        return this.dispatch(this.surplusLpnNumber);
    }

    public List<TmTransDispatchData> dispatchAllNotUpdate() {
        return this.dispatchNotUpdate(this.surplusLpnNumber);
    }

    private List<TmTransDispatchData> getNotDispatchData(Integer number, boolean isUpdate) {
        ArrayList list = Lists.newArrayList();
        for (TmTransDispatchData data : this.dataSet) {
            if (data.isDispatch()) continue;
            if (list.size() == number.intValue()) break;
            if (isUpdate) {
                data.setDispatch(true);
            }
            list.add(data);
        }
        return list;
    }

    public TmTransDispatchData getEarliestNotDispatchData() {
        return this.dataSet.stream().filter(data -> !data.isDispatch()).min(Comparator.comparing(TmTransDispatchData::getTmdate)).orElse(null);
    }

    public String getUniqueKey() {
        return this.uniqueKey;
    }

    public String getEntid() {
        return this.entid;
    }

    public String getParkid() {
        return this.parkid;
    }

    public String getWaveno() {
        return this.waveno;
    }

    public String getLpntypeid() {
        return this.lpntypeid;
    }

    public String getLpntypename() {
        return this.lpntypename;
    }

    public Integer getLpntype() {
        return this.lpntype;
    }

    public String getFmcustid() {
        return this.fmcustid;
    }

    public String getFmcustname() {
        return this.fmcustname;
    }

    public String getTocustid() {
        return this.tocustid;
    }

    public String getTocustname() {
        return this.tocustname;
    }

    public String getCellno() {
        return this.cellno;
    }

    public Integer getTemptype() {
        return this.temptype;
    }

    public String getServiceareaid() {
        return this.serviceareaid;
    }

    public Integer getTotalBoxQty() {
        return this.totalBoxQty;
    }

    public BigDecimal getTotalWeight() {
        return this.totalWeight;
    }

    public BigDecimal getTotalVolume() {
        return this.totalVolume;
    }

    public Integer getLpnNumber() {
        return this.lpnNumber;
    }

    public Integer getDispatchLpnNumber() {
        return this.dispatchLpnNumber;
    }

    public Integer getSurplusLpnNumber() {
        return this.surplusLpnNumber;
    }

    public Set<TmTransDispatchData> getDataSet() {
        return this.dataSet;
    }

    public String getPlanSheetId() {
        return this.planSheetId;
    }

    public void setUniqueKey(String uniqueKey) {
        this.uniqueKey = uniqueKey;
    }

    public void setEntid(String entid) {
        this.entid = entid;
    }

    public void setParkid(String parkid) {
        this.parkid = parkid;
    }

    public void setWaveno(String waveno) {
        this.waveno = waveno;
    }

    public void setLpntypeid(String lpntypeid) {
        this.lpntypeid = lpntypeid;
    }

    public void setLpntypename(String lpntypename) {
        this.lpntypename = lpntypename;
    }

    public void setLpntype(Integer lpntype) {
        this.lpntype = lpntype;
    }

    public void setFmcustid(String fmcustid) {
        this.fmcustid = fmcustid;
    }

    public void setFmcustname(String fmcustname) {
        this.fmcustname = fmcustname;
    }

    public void setTocustid(String tocustid) {
        this.tocustid = tocustid;
    }

    public void setTocustname(String tocustname) {
        this.tocustname = tocustname;
    }

    public void setCellno(String cellno) {
        this.cellno = cellno;
    }

    public void setTemptype(Integer temptype) {
        this.temptype = temptype;
    }

    public void setServiceareaid(String serviceareaid) {
        this.serviceareaid = serviceareaid;
    }

    public void setTotalBoxQty(Integer totalBoxQty) {
        this.totalBoxQty = totalBoxQty;
    }

    public void setTotalWeight(BigDecimal totalWeight) {
        this.totalWeight = totalWeight;
    }

    public void setTotalVolume(BigDecimal totalVolume) {
        this.totalVolume = totalVolume;
    }

    public void setPlanSheetId(String planSheetId) {
        this.planSheetId = planSheetId;
    }

    public String toString() {
        return "TransDispatchSummaryData(uniqueKey=" + this.getUniqueKey() + ", entid=" + this.getEntid() + ", parkid=" + this.getParkid() + ", waveno=" + this.getWaveno() + ", lpntypeid=" + this.getLpntypeid() + ", lpntypename=" + this.getLpntypename() + ", lpntype=" + this.getLpntype() + ", fmcustid=" + this.getFmcustid() + ", fmcustname=" + this.getFmcustname() + ", tocustid=" + this.getTocustid() + ", tocustname=" + this.getTocustname() + ", cellno=" + this.getCellno() + ", temptype=" + this.getTemptype() + ", serviceareaid=" + this.getServiceareaid() + ", totalBoxQty=" + this.getTotalBoxQty() + ", totalWeight=" + this.getTotalWeight() + ", totalVolume=" + this.getTotalVolume() + ", lpnNumber=" + this.getLpnNumber() + ", dispatchLpnNumber=" + this.getDispatchLpnNumber() + ", surplusLpnNumber=" + this.getSurplusLpnNumber() + ", dataSet=" + this.getDataSet() + ", planSheetId=" + this.getPlanSheetId() + ")";
    }
}

