/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.isce.tms.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.StringUtils;

public enum TempTypeEnum {
    ROOM_TEMPERATURE("10", "\u5e38\u6e29"),
    CONSTANT_TEMPERATURE("20", "\u6052\u6e29"),
    COLD_STORAGE("30", "\u51b7\u85cf"),
    FREEZE("40", "\u51b7\u51bb"),
    FISHERIES("50", "\u6c34\u4ea7"),
    PORK("60", "\u732a\u8089\u767d\u6761");

    private String value;
    private String message;
    private static final Map<String, TempTypeEnum> lookup;

    private TempTypeEnum(String value, String message) {
        this.value = value;
        this.message = message;
    }

    public String value() {
        return this.value;
    }

    public String msg() {
        return this.message;
    }

    public static String convert(String value) {
        for (TempTypeEnum tempTypeEnum : TempTypeEnum.values()) {
            if (!StringUtils.equals((CharSequence)value, (CharSequence)tempTypeEnum.value())) continue;
            return tempTypeEnum.msg();
        }
        throw new NoSuchElementException(value);
    }

    public static String find(String value) {
        TempTypeEnum typeEnum = lookup.get(value);
        if (value == null) {
            return "default";
        }
        return typeEnum.msg();
    }

    static {
        lookup = new HashMap<String, TempTypeEnum>();
        for (TempTypeEnum e : EnumSet.allOf(TempTypeEnum.class)) {
            lookup.put(e.value, e);
        }
    }
}

