/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.config;

import com.product.component.globrule.GlobRuleSrvimpl;
import com.product.storage.template.FMybatisTemplate;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

@Configuration
@ConditionalOnProperty(name={"public.datasource.enabled"}, havingValue="true")
public class SheetidConfig {
    private static final Logger log = LoggerFactory.getLogger(SheetidConfig.class);
    @Value(value="${spring.datasource.public.jdbcUrl}")
    protected String publicJdbcUrl;
    @Value(value="${spring.datasource.public.driver-class-name}")
    protected String publicJdbcDriver;
    @Value(value="${spring.datasource.public.username}")
    protected String publicJdbcUser;
    @Value(value="${spring.datasource.public.password}")
    protected String publicJdbcPass;
    @Autowired
    protected ResourceLoader resourceLoader = new DefaultResourceLoader();

    @Bean(name={"publicDatasource"})
    @ConfigurationProperties(prefix="spring.datasource.public")
    public DataSource onPublicHikariDataSource() {
        log.info("---> BaseConfiger creating SheetidDataSource: jdbcDriver:{} jdbcUrl:{} jdbcUser:{} jdbcPass:{} ", new Object[]{this.publicJdbcDriver, this.publicJdbcUrl, this.publicJdbcUser, this.publicJdbcPass});
        DataSource response = DataSourceBuilder.create().type(HikariDataSource.class).build();
        return response;
    }

    @Bean(name={"publicSqlSessionFactory"})
    @DependsOn(value={"publicDatasource"})
    public SqlSessionFactoryBean onPublicSqlSessionFactoryBean(@Qualifier(value="publicDatasource") DataSource datasource) {
        log.info("---> BaseConfiger 2. creating PublicSqlSessionFactoryBean");
        SqlSessionFactoryBean service = new SqlSessionFactoryBean();
        service.setDataSource(datasource);
        Resource resource = this.resourceLoader.getResource("classpath:mybatis-config.xml");
        service.setConfigLocation(resource);
        return service;
    }

    @Bean
    @DependsOn(value={"publicSqlSessionFactory"})
    public GlobRuleSrvimpl onGlobRuleSrv(@Qualifier(value="publicSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        return new GlobRuleSrvimpl(new FMybatisTemplate(sqlSessionFactory, ExecutorType.BATCH));
    }
}

