/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.rocketmq.consumer;

import com.alibaba.fastjson.JSON;
import com.product.datasource.DynamicDataSourceContextHolder;
import com.product.model.ServiceSession;
import com.product.util.SpringContext;
import com.product.util.StaticVariable;
import java.nio.charset.StandardCharsets;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class MyRocketMQListener
implements RocketMQListener<MessageExt> {
    private static final Logger log = LoggerFactory.getLogger(MyRocketMQListener.class);

    public void onMessage(MessageExt message) {
        String sessionJsonStr = message.getProperty("session");
        ServiceSession serviceSession = (ServiceSession)JSON.parseObject((String)sessionJsonStr, ServiceSession.class);
        if (serviceSession != null) {
            String dbKeyCode = serviceSession.getShop_group();
            if (!StringUtils.isEmpty((Object)dbKeyCode)) {
                if (DynamicDataSourceContextHolder.containDataSourceKey((String)dbKeyCode)) {
                    DynamicDataSourceContextHolder.setRouterKey((String)dbKeyCode);
                    log.info("-----> \u5f53\u524d\u9009\u62e9\u6570\u636e\u5e93:" + dbKeyCode);
                } else {
                    DynamicDataSourceContextHolder.setRouterKey((String)"defaultDs");
                }
                StaticVariable.put((String)"dbKeyCode", (Object)dbKeyCode);
            } else {
                DynamicDataSourceContextHolder.setRouterKey((String)"defaultDs");
            }
            SpringContext.putSession((ServiceSession)serviceSession);
        }
        this.handleMessage(new String(message.getBody(), StandardCharsets.UTF_8), message.getKeys());
    }

    public abstract void handleMessage(String var1, String var2);
}

