/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.utils;

import com.efuture.common.utils.ExceptionUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.Validate;

public class DateUtils {
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    private static final int[] MONTH_LENGTH = new int[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final String DATE_FORMAT_FULLTIME = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_SHORTDAY = "yyyyMMdd";
    public static final String DATE_FORMAT_SIMPLEFULLTIME = "yyyyMMddHHmmss";
    public static final String DATE_FORMAT_SIMPLEALLTIME = "yyyyMMddHHmmssSSS";
    public static final String DATE_FORMAT_DAYTIME = "yyyy-MM-dd";
    public static final String DATE_FORMAT_MONTHTIME = "yyyy-MM";
    public static final String DATE_FORMAT_MINUTETIME = "yyyy-MM-dd HH:mm";
    public static final String CHINA_SHORT_DATETIME = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String CHINA_LONG_DATETTIME = "yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2";
    public static final int FIRST_DAY_OF_WEEK = 2;

    public static List<String> IntervalTime(String begin, String end, long interval) {
        LocalTime beginTime = LocalTime.parse(begin, DateTimeFormatter.ofPattern("HH:mm"));
        LocalTime endTime = LocalTime.parse(end, DateTimeFormatter.ofPattern("HH:mm"));
        LinkedList<String> list = new LinkedList<String>();
        do {
            list.add(beginTime.toString());
        } while ((beginTime = beginTime.plusMinutes(interval)).compareTo(endTime) <= 0);
        return list;
    }

    public static List<String> IntervalDate(String begin, String end, long interval) {
        LocalDate beginDate = LocalDate.parse(begin, DateTimeFormatter.ofPattern(DATE_FORMAT_DAYTIME));
        LocalDate endDate = LocalDate.parse(end, DateTimeFormatter.ofPattern(DATE_FORMAT_DAYTIME));
        LinkedList<String> list = new LinkedList<String>();
        do {
            list.add(beginDate.toString());
        } while ((beginDate = beginDate.plusDays(interval)).compareTo(endDate) <= 0);
        return list;
    }

    public static boolean isSameDay(@NotNull Date date1, @NotNull Date date2) {
        return org.apache.commons.lang3.time.DateUtils.isSameDay((Date)date1, (Date)date2);
    }

    public static boolean isSameTime(@NotNull Date date1, @NotNull Date date2) {
        return date1.compareTo(date2) == 0;
    }

    public static boolean isBetween(@NotNull Date date, @NotNull Date start, @NotNull Date end) {
        if (date == null || start == null || end == null || start.after(end)) {
            throw new IllegalArgumentException("some date parameters is null or dateBein after dateEnd");
        }
        return !date.before(start) && !date.after(end);
    }

    public static String getNowDateStr(String format) {
        SimpleDateFormat sf = new SimpleDateFormat(format);
        return sf.format(new Date());
    }

    public static Date addMonths(@NotNull Date date, int amount) {
        return org.apache.commons.lang3.time.DateUtils.addMonths((Date)date, (int)amount);
    }

    public static Date subMonths(@NotNull Date date, int amount) {
        return org.apache.commons.lang3.time.DateUtils.addMonths((Date)date, (int)(-amount));
    }

    public static Date addWeeks(@NotNull Date date, int amount) {
        return org.apache.commons.lang3.time.DateUtils.addWeeks((Date)date, (int)amount);
    }

    public static Date subWeeks(@NotNull Date date, int amount) {
        return org.apache.commons.lang3.time.DateUtils.addWeeks((Date)date, (int)(-amount));
    }

    public static Date addDays(@NotNull Date date, int amount) {
        return org.apache.commons.lang3.time.DateUtils.addDays((Date)date, (int)amount);
    }

    public static Date subDays(@NotNull Date date, int amount) {
        return org.apache.commons.lang3.time.DateUtils.addDays((Date)date, (int)(-amount));
    }

    public static Date addHours(@NotNull Date date, int amount) {
        return org.apache.commons.lang3.time.DateUtils.addHours((Date)date, (int)amount);
    }

    public static Date subHours(@NotNull Date date, int amount) {
        return org.apache.commons.lang3.time.DateUtils.addHours((Date)date, (int)(-amount));
    }

    public static Date addMinutes(@NotNull Date date, int amount) {
        return org.apache.commons.lang3.time.DateUtils.addMinutes((Date)date, (int)amount);
    }

    public static Date subMinutes(@NotNull Date date, int amount) {
        return org.apache.commons.lang3.time.DateUtils.addMinutes((Date)date, (int)(-amount));
    }

    public static Date addSeconds(@NotNull Date date, int amount) {
        return org.apache.commons.lang3.time.DateUtils.addSeconds((Date)date, (int)amount);
    }

    public static Date subSeconds(@NotNull Date date, int amount) {
        return org.apache.commons.lang3.time.DateUtils.addSeconds((Date)date, (int)(-amount));
    }

    public static Date setYears(@NotNull Date date, int amount) {
        return org.apache.commons.lang3.time.DateUtils.setYears((Date)date, (int)amount);
    }

    public static Date setMonths(@NotNull Date date, int amount) {
        return org.apache.commons.lang3.time.DateUtils.setMonths((Date)date, (int)amount);
    }

    public static Date setDays(@NotNull Date date, int amount) {
        return org.apache.commons.lang3.time.DateUtils.setDays((Date)date, (int)amount);
    }

    public static Date setHours(@NotNull Date date, int amount) {
        return org.apache.commons.lang3.time.DateUtils.setHours((Date)date, (int)amount);
    }

    public static Date setMinutes(@NotNull Date date, int amount) {
        return org.apache.commons.lang3.time.DateUtils.setMinutes((Date)date, (int)amount);
    }

    public static Date setSeconds(@NotNull Date date, int amount) {
        return org.apache.commons.lang3.time.DateUtils.setSeconds((Date)date, (int)amount);
    }

    public static Date setMilliseconds(@NotNull Date date, int amount) {
        return org.apache.commons.lang3.time.DateUtils.setMilliseconds((Date)date, (int)amount);
    }

    public static int getDayOfWeek(@NotNull Date date) {
        int result = DateUtils.get(date, 7);
        return result == 1 ? 7 : result - 1;
    }

    public static int getDayOfYear(@NotNull Date date) {
        return DateUtils.get(date, 6);
    }

    public static int getWeekOfMonth(@NotNull Date date) {
        return DateUtils.getWithMondayFirst(date, 4);
    }

    public static int getWeekOfYear(@NotNull Date date) {
        return DateUtils.getWithMondayFirst(date, 3);
    }

    private static int get(Date date, int field) {
        Validate.notNull((Object)date, (String)"The date must not be null", (Object[])new Object[0]);
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        cal.setTime(date);
        return cal.get(field);
    }

    private static int getWithMondayFirst(Date date, int field) {
        Validate.notNull((Object)date, (String)"The date must not be null", (Object[])new Object[0]);
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        cal.setTime(date);
        return cal.get(field);
    }

    public static Date beginOfYear(@NotNull Date date) {
        return org.apache.commons.lang3.time.DateUtils.truncate((Date)date, (int)1);
    }

    public static Date endOfYear(@NotNull Date date) {
        return new Date(DateUtils.nextYear(date).getTime() - 1L);
    }

    public static Date nextYear(@NotNull Date date) {
        return org.apache.commons.lang3.time.DateUtils.ceiling((Date)date, (int)1);
    }

    public static Date beginOfMonth(@NotNull Date date) {
        return org.apache.commons.lang3.time.DateUtils.truncate((Date)date, (int)2);
    }

    public static Date endOfMonth(@NotNull Date date) {
        return new Date(DateUtils.nextMonth(date).getTime() - 1L);
    }

    public static Date nextMonth(@NotNull Date date) {
        return org.apache.commons.lang3.time.DateUtils.ceiling((Date)date, (int)2);
    }

    public static Date beginOfWeek(@NotNull Date date) {
        return org.apache.commons.lang3.time.DateUtils.truncate((Date)DateUtils.subDays(date, DateUtils.getDayOfWeek(date) - 1), (int)5);
    }

    public static Date endOfWeek(@NotNull Date date) {
        return new Date(DateUtils.nextWeek(date).getTime() - 1L);
    }

    public static Date nextWeek(@NotNull Date date) {
        return org.apache.commons.lang3.time.DateUtils.truncate((Date)DateUtils.addDays(date, 8 - DateUtils.getDayOfWeek(date)), (int)5);
    }

    public static Date beginOfDate(@NotNull Date date) {
        return org.apache.commons.lang3.time.DateUtils.truncate((Date)date, (int)5);
    }

    public static Date endOfDate(@NotNull Date date) {
        return new Date(DateUtils.nextDate(date).getTime() - 1L);
    }

    public static Date nextDate(@NotNull Date date) {
        return org.apache.commons.lang3.time.DateUtils.ceiling((Date)date, (int)5);
    }

    public static Date beginOfHour(@NotNull Date date) {
        return org.apache.commons.lang3.time.DateUtils.truncate((Date)date, (int)11);
    }

    public static Date endOfHour(@NotNull Date date) {
        return new Date(DateUtils.nextHour(date).getTime() - 1L);
    }

    public static Date nextHour(@NotNull Date date) {
        return org.apache.commons.lang3.time.DateUtils.ceiling((Date)date, (int)11);
    }

    public static Date beginOfMinute(@NotNull Date date) {
        return org.apache.commons.lang3.time.DateUtils.truncate((Date)date, (int)12);
    }

    public static Date endOfMinute(@NotNull Date date) {
        return new Date(DateUtils.nextMinute(date).getTime() - 1L);
    }

    public static Date nextMinute(@NotNull Date date) {
        return org.apache.commons.lang3.time.DateUtils.ceiling((Date)date, (int)12);
    }

    public static boolean isLeapYear(@NotNull Date date) {
        return DateUtils.isLeapYear(DateUtils.get(date, 1));
    }

    public static boolean isLeapYear(int y) {
        boolean result = false;
        if (y % 4 == 0 && (y < 1582 || y % 100 != 0 || y % 400 == 0)) {
            result = true;
        }
        return result;
    }

    public static int getMonthLength(@NotNull Date date) {
        Date date1 = DateUtils.addMonths(date, 1);
        int year = DateUtils.get(date, 1);
        int month = DateUtils.get(date, 2);
        return DateUtils.getMonthLength(year, month);
    }

    public static int getMonthLength(int year, int month) {
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("Invalid month: " + month);
        }
        if (month == 2) {
            return DateUtils.isLeapYear(year) ? 28 : 29;
        }
        return MONTH_LENGTH[month];
    }

    public static String date2Str(Date date, String ... format) {
        String result = null;
        String formatStr = DATE_FORMAT_FULLTIME;
        if (format != null && format.length >= 1) {
            formatStr = format[0];
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
            result = sdf.format(date);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static Date str2Date(String dateStr, String ... format) {
        String formatStr = DATE_FORMAT_FULLTIME;
        if (format != null && format.length >= 1) {
            formatStr = format[0];
        }
        Date date = null;
        SimpleDateFormat df = new SimpleDateFormat(formatStr, Locale.CHINA);
        try {
            date = df.parse(dateStr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return date;
    }

    public static int getYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static int getMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2) + 1;
    }

    public static int getDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static int getHour(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(11);
    }

    public static int getMinute(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(12);
    }

    public static int getSecond(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(13);
    }

    public static long getMillis(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.getTimeInMillis();
    }

    public static int diffDate(Date date, Date date1) {
        return (int)((DateUtils.getMillis(date) - DateUtils.getMillis(date1)) / 86400000L);
    }

    public static long str2unixStamp(String dateStr, String ... format) {
        return DateUtils.str2Date(dateStr, format).getTime() / 1000L;
    }

    public static long date2unixStamp(Date date) {
        return date.getTime() / 1000L;
    }

    public static String unixStamp2Str(long stamp, String ... format) {
        return DateUtils.date2Str(new Date(stamp * 1000L), format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String string2Timezone(String srcFormater, String srcDateTime, String dstFormater, String dstTimeZoneId) {
        if (srcFormater == null || "".equals(srcFormater)) {
            return null;
        }
        if (srcDateTime == null || "".equals(srcDateTime)) {
            return null;
        }
        if (dstFormater == null || "".equals(dstFormater)) {
            return null;
        }
        if (dstTimeZoneId == null || "".equals(dstTimeZoneId)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(srcFormater);
        try {
            int diffTime = DateUtils.getDiffTimeZoneRawOffset(dstTimeZoneId);
            if (diffTime == 0) {
                String string = srcDateTime;
                return string;
            }
            Date d = sdf.parse(srcDateTime);
            long nowTime = d.getTime();
            long newNowTime = nowTime - (long)diffTime;
            d = new Date(newNowTime);
            String string = DateUtils.date2Str(d, dstFormater);
            return string;
        }
        catch (ParseException e) {
            String string = null;
            return string;
        }
        finally {
            sdf = null;
        }
    }

    private static int getDefaultTimeZoneRawOffset() {
        return TimeZone.getDefault().getRawOffset();
    }

    private static int getTimeZoneRawOffset(String timeZoneId) {
        return TimeZone.getTimeZone(timeZoneId).getRawOffset();
    }

    public static int getDiffTimeZoneRawOffset(String timeZoneId) {
        TimeZone tz1 = TimeZone.getDefault();
        TimeZone tz2 = TimeZone.getTimeZone(timeZoneId);
        return tz1.getRawOffset() - tz2.getRawOffset() + tz1.getDSTSavings() - tz2.getDSTSavings();
    }

    public static String dateStr2TimezoneDefault(String srcDateTime, String dstTimeZoneId) {
        return DateUtils.string2Timezone(DATE_FORMAT_FULLTIME, srcDateTime, DATE_FORMAT_FULLTIME, dstTimeZoneId);
    }

    public static Date date2TimezoneDefault(Date srcDateTime, String dstTimeZoneId) {
        return DateUtils.date2Timezone(srcDateTime, dstTimeZoneId);
    }

    private static Date date2Timezone(Date srcDateTime, String dstTimeZoneId) {
        if (srcDateTime == null || dstTimeZoneId == null) {
            return null;
        }
        int diffTime = DateUtils.getDiffTimeZoneRawOffset(dstTimeZoneId);
        if (diffTime == 0) {
            return srcDateTime;
        }
        long nowTime = srcDateTime.getTime();
        long newNowTime = nowTime - (long)diffTime;
        return new Date(newNowTime);
    }

    public static String[] fecthAllTimeZoneIds() {
        Vector<String> v = new Vector<String>();
        Object[] ids = TimeZone.getAvailableIDs();
        for (int i = 0; i < ids.length; ++i) {
            v.add(ids[i]);
        }
        Collections.sort(v, String.CASE_INSENSITIVE_ORDER);
        v.copyInto(ids);
        v = null;
        return ids;
    }

    public static String getExpireDate(String prodate, Integer expdays) {
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT_DAYTIME);
        Date currdate = null;
        String enddate = new String();
        try {
            currdate = format.parse(prodate);
            Calendar ca = Calendar.getInstance();
            ca.add(5, expdays);
            currdate = ca.getTime();
            enddate = format.format(currdate);
        }
        catch (ParseException e) {
            ExceptionUtils.raise("\u8f6c\u5316\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
        }
        return enddate;
    }

    public static int getIntervalDays(String beginTime, String format) {
        int dayNum = -1;
        try {
            Date start = DateUtils.getDate(beginTime, format);
            Date now = new Date();
            long res = now.getTime() - start.getTime();
            dayNum = (int)(res / 1000L / 3600L / 24L);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return dayNum;
    }

    public static int getIntervalDays(String beginTime) {
        return DateUtils.getIntervalDays(beginTime, DATE_FORMAT_DAYTIME);
    }

    public static Date getDate(String time, String format) {
        Date date = null;
        try {
            SimpleDateFormat df = new SimpleDateFormat(format);
            df.setLenient(false);
            date = df.parse(time);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
        return date;
    }

    public static int compareDate(Date date1, Date date2) {
        if (date1.getTime() > date2.getTime()) {
            return -1;
        }
        return date1.getTime() < date2.getTime() ? 1 : 0;
    }

    public static int getWeekDay(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int week_of_year = c.get(7);
        return week_of_year - 1;
    }

    public static String getWeekBeginAndEndDate(Date date, String pattern) {
        Date monday = DateUtils.getMondayOfWeek(date);
        Date sunday = DateUtils.getSundayOfWeek(date);
        return DateUtils.formatDate(monday, pattern) + " - " + DateUtils.formatDate(sunday, pattern);
    }

    public static String formatDate(Date date, String pattern) {
        String strDate = null;
        try {
            if (pattern == null) {
                pattern = DATE_FORMAT_DAYTIME;
            }
            SimpleDateFormat format = new SimpleDateFormat(pattern);
            strDate = format.format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strDate;
    }

    public static Date getMondayOfWeek(Date date) {
        Calendar monday = Calendar.getInstance();
        monday.setTime(date);
        monday.setFirstDayOfWeek(2);
        monday.set(7, 2);
        return monday.getTime();
    }

    public static Date getSundayOfWeek(Date date) {
        Calendar sunday = Calendar.getInstance();
        sunday.setTime(date);
        sunday.setFirstDayOfWeek(2);
        sunday.set(7, 1);
        return sunday.getTime();
    }

    public static int getRemainDayOfMonth(Date date) {
        int dayOfMonth = DateUtils.getDayOfMonth(date);
        int day = DateUtils.getPassDayOfMonth(date);
        return dayOfMonth - day;
    }

    public static int getPassDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(5);
    }

    public static int getDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.getActualMaximum(5);
    }

    public static Date getFirstDateOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, c.getActualMinimum(5));
        return c.getTime();
    }

    public static Date getLastDateOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, c.getActualMaximum(5));
        return c.getTime();
    }

    public static Date getFirstDateOfSeason(Date date) {
        return DateUtils.getFirstDateOfMonth(DateUtils.getSeasonDate(date)[0]);
    }

    public static Date getLastDateOfSeason(Date date) {
        return DateUtils.getLastDateOfMonth(DateUtils.getSeasonDate(date)[2]);
    }

    public static int getDayOfSeason(Date date) {
        Date[] seasonDates;
        int day = 0;
        for (Date date2 : seasonDates = DateUtils.getSeasonDate(date)) {
            day += DateUtils.getDayOfMonth(date2);
        }
        return day;
    }

    public static int getRemainDayOfSeason(Date date) {
        return DateUtils.getDayOfSeason(date) - DateUtils.getPassDayOfSeason(date);
    }

    public static int getPassDayOfSeason(Date date) {
        int day = 0;
        Date[] seasonDates = DateUtils.getSeasonDate(date);
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int month = c.get(2);
        if (month == 0 || month == 3 || month == 6 || month == 9) {
            day = DateUtils.getPassDayOfMonth(seasonDates[0]);
        } else if (month == 1 || month == 4 || month == 7 || month == 10) {
            day = DateUtils.getDayOfMonth(seasonDates[0]) + DateUtils.getPassDayOfMonth(seasonDates[1]);
        } else if (month == 2 || month == 5 || month == 8 || month == 11) {
            day = DateUtils.getDayOfMonth(seasonDates[0]) + DateUtils.getDayOfMonth(seasonDates[1]) + DateUtils.getPassDayOfMonth(seasonDates[2]);
        }
        return day;
    }

    public static Date[] getSeasonDate(Date date) {
        Date[] season = new Date[3];
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int nSeason = DateUtils.getSeason(date);
        if (nSeason == 1) {
            c.set(2, 0);
            season[0] = c.getTime();
            c.set(2, 1);
            season[1] = c.getTime();
            c.set(2, 2);
            season[2] = c.getTime();
        } else if (nSeason == 2) {
            c.set(2, 3);
            season[0] = c.getTime();
            c.set(2, 4);
            season[1] = c.getTime();
            c.set(2, 5);
            season[2] = c.getTime();
        } else if (nSeason == 3) {
            c.set(2, 6);
            season[0] = c.getTime();
            c.set(2, 7);
            season[1] = c.getTime();
            c.set(2, 8);
            season[2] = c.getTime();
        } else if (nSeason == 4) {
            c.set(2, 9);
            season[0] = c.getTime();
            c.set(2, 10);
            season[1] = c.getTime();
            c.set(2, 11);
            season[2] = c.getTime();
        }
        return season;
    }

    public static int getSeason(Date date) {
        int season = 0;
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int month = c.get(2);
        switch (month) {
            case 0: 
            case 1: 
            case 2: {
                season = 1;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                season = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                season = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                season = 4;
                break;
            }
        }
        return season;
    }
}

