/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.utils;

import com.alibaba.fastjson.parser.ParserConfig;
import com.efuture.common.utils.DynamicSqlUtils;
import com.efuture.common.utils.ExceptionUtils;
import com.efuture.common.utils.PageInfo;
import com.github.pagehelper.ISelect;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.product.model.ServiceResponse;
import com.product.util.TypeUtils;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.ibatis.session.RowBounds;

public class PageUtils {
    public static ServiceResponse pageSelect(String statement, Object params) {
        int page_no = 0;
        int page_size = 0;
        try {
            page_no = Integer.parseInt(BeanUtils.getProperty((Object)params, (String)"page_no"));
            page_size = Integer.parseInt(BeanUtils.getProperty((Object)params, (String)"page_size"));
        }
        catch (Exception e) {
            ExceptionUtils.raise("\u5206\u9875\u6761\u4ef6\u4e0d\u6b63\u786e,\u8bf7\u68c0\u67e5\uff01");
        }
        RowBounds rowBounds = new RowBounds((page_no - 1) * page_size, page_size);
        Map map = (Map)TypeUtils.cast((Object)params, Map.class, (ParserConfig)ParserConfig.getGlobalInstance());
        List list = DynamicSqlUtils.getTemplate().getSqlSessionTemplate().selectList(statement, (Object)map, rowBounds);
        Page page = (Page)list;
        return ServiceResponse.buildSuccess((Object)new PageInfo(page.getResult(), page.getTotal()));
    }

    public static ServiceResponse pageSelect(ISelect select, Object params) {
        int page_no = 0;
        int page_size = 0;
        try {
            page_no = Integer.parseInt(BeanUtils.getProperty((Object)params, (String)"page_no"));
            page_size = Integer.parseInt(BeanUtils.getProperty((Object)params, (String)"page_size"));
        }
        catch (Exception e) {
            ExceptionUtils.raise("\u5206\u9875\u6761\u4ef6\u4e0d\u6b63\u786e,\u8bf7\u68c0\u67e5\uff01");
        }
        Page page = PageHelper.startPage((int)page_no, (int)page_size);
        page.doSelectPage(select);
        return ServiceResponse.buildSuccess((Object)new PageInfo(page.getResult(), page.getTotal()));
    }

    public static ServiceResponse pageSqlSelect(String sql, Object params) {
        int page_no = 0;
        int page_size = 0;
        try {
            page_no = Integer.parseInt(BeanUtils.getProperty((Object)params, (String)"page_no"));
            page_size = Integer.parseInt(BeanUtils.getProperty((Object)params, (String)"page_size"));
        }
        catch (Exception e) {
            ExceptionUtils.raise("\u5206\u9875\u6761\u4ef6\u4e0d\u6b63\u786e,\u8bf7\u68c0\u67e5\uff01");
        }
        Map map = (Map)TypeUtils.cast((Object)params, Map.class, (ParserConfig)ParserConfig.getGlobalInstance());
        Page page = PageHelper.startPage((int)page_no, (int)page_size);
        page.doSelectPage(() -> DynamicSqlUtils.executeList(sql, map));
        return ServiceResponse.buildSuccess((Object)new PageInfo(page.getResult(), page.getTotal()));
    }

    public static ServiceResponse pageList(List list, Object params) {
        int page_no = 0;
        int page_size = 0;
        try {
            page_no = Integer.parseInt(BeanUtils.getProperty((Object)params, (String)"page_no"));
            page_size = Integer.parseInt(BeanUtils.getProperty((Object)params, (String)"page_size"));
        }
        catch (Exception e) {
            ExceptionUtils.raise("\u5206\u9875\u6761\u4ef6\u4e0d\u6b63\u786e,\u8bf7\u68c0\u67e5\uff01");
        }
        long total = list.size();
        List subList = list.stream().skip((page_no - 1) * page_size).limit(page_size).collect(Collectors.toList());
        return ServiceResponse.buildSuccess((Object)new PageInfo(subList, total));
    }
}

