/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.aop;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Aspect
public class PreventReSubmitInterceptor {
    private static final Logger log = LoggerFactory.getLogger(PreventReSubmitInterceptor.class);
    @Autowired
    protected HttpServletRequest request;
    @Autowired
    private RedissonClient redissonClient;

    @Pointcut(value="@annotation(com.efuture.common.annotation.RreventReSubmit)")
    private void reSubmitPointCut() {
    }

    @Around(value="reSubmitPointCut()")
    public Object getSessionInitAspect(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] objects;
        StringBuffer requestStr = new StringBuffer(this.request.getScheme() + ":" + this.request.getServerName());
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        if (Objects.nonNull(method)) {
            String methodName = method.getName();
            requestStr.append(":").append(methodName);
        }
        if ((objects = joinPoint.getArgs()) != null && objects.length > 0) {
            for (Object obj : objects) {
                requestStr.append(":").append(JSONObject.toJSONString((Object)obj).replace(":", "-"));
            }
        }
        try {
            RLock rLock = this.redissonClient.getLock(requestStr.toString());
            if (rLock.tryLock()) {
                Object object = joinPoint.proceed();
                return object;
            }
            throw new RuntimeException("\u8bf7\u4e0d\u8981\u91cd\u590d\u63d0\u4ea4:[" + requestStr.toString() + "]");
        }
        finally {
            RLock lock = this.redissonClient.getLock(requestStr.toString());
            if (lock.isLocked() && lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
    }
}

