/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.aop;

import com.efuture.common.annotation.Key;
import com.efuture.common.annotation.Keys;
import com.efuture.common.annotation.RedisLock;
import com.efuture.common.annotation.RedisMultiLock;
import com.efuture.common.transaction.event.RedisLockEvent;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Aspect
public class RedisLockInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RedisLockInterceptor.class);
    private static final String KEY_SEPARATOR = ":";
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(com.efuture.common.annotation.RedisLock)")
    public Object doAround(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method targetMethod = methodSignature.getMethod();
        String lockKey = this.buildLockKey(targetMethod.getAnnotation(RedisLock.class).prefix(), targetMethod, joinPoint.getArgs());
        log.debug("Start fetch distribut lock,key={}", (Object)lockKey);
        RLock rLock = this.redissonClient.getLock(lockKey);
        if (rLock.tryLock(1L, TimeUnit.MINUTES)) {
            log.debug("Fetch distribut lock success,key={}", (Object)lockKey);
            try {
                Object object = joinPoint.proceed();
                return object;
            }
            finally {
                log.debug("Release distribut lock success,key={}", (Object)lockKey);
                if (TransactionSynchronizationManager.isActualTransactionActive()) {
                    this.eventPublisher.publishEvent((ApplicationEvent)new RedisLockEvent(() -> {
                        RLock lock = this.redissonClient.getLock(lockKey);
                        if (lock.isLocked() && lock.isHeldByCurrentThread()) {
                            lock.unlock();
                        }
                    }));
                } else {
                    RLock lock = this.redissonClient.getLock(lockKey);
                    if (lock.isLocked() && lock.isHeldByCurrentThread()) {
                        lock.unlock();
                    }
                }
            }
        }
        throw new RuntimeException("Try lock failure. lockKey:[" + lockKey + "]");
    }

    private String buildLockKey(String prefix, Method method, Object[] args) {
        StringBuilder builder = new StringBuilder();
        if (Objects.nonNull(prefix) && !prefix.isEmpty()) {
            builder.append(prefix).append(KEY_SEPARATOR);
        }
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].isAnnotationPresent(Key.class)) continue;
            Key key = parameters[i].getAnnotation(Key.class);
            builder.append(this.parseKeyExpr(key.expr(), parameters[i], args[i])).append(KEY_SEPARATOR);
        }
        return builder.substring(0, builder.length() - 1);
    }

    private String parseKeyExpr(String expr, Parameter parameter, Object arg) {
        if (Objects.isNull(expr) || expr.isEmpty()) {
            return arg.toString();
        }
        SpelExpressionParser parser = new SpelExpressionParser();
        Expression expression = parser.parseExpression(expr);
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.setVariable(parameter.getName(), arg);
        return (String)expression.getValue((EvaluationContext)context, String.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(com.efuture.common.annotation.RedisMultiLock)")
    public Object tryLocks(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method targetMethod = methodSignature.getMethod();
        Object[] lockKeys = this.buildLockKeys(targetMethod.getAnnotation(RedisMultiLock.class).prefix(), targetMethod, joinPoint.getArgs());
        RLock[] locklist = new RLock[lockKeys.length];
        for (int i = 0; i < lockKeys.length; ++i) {
            locklist[i] = this.redissonClient.getLock(lockKeys[i]);
        }
        RLock multiLock = this.redissonClient.getMultiLock(locklist);
        if (multiLock.tryLock(1L, TimeUnit.MINUTES)) {
            try {
                Object object = joinPoint.proceed();
                return object;
            }
            finally {
                if (TransactionSynchronizationManager.isActualTransactionActive()) {
                    this.eventPublisher.publishEvent((ApplicationEvent)new RedisLockEvent(() -> {
                        RLock rmultiLock = this.redissonClient.getMultiLock(locklist);
                        if (rmultiLock != null) {
                            rmultiLock.unlock();
                        }
                    }));
                } else {
                    RLock rmultiLock = this.redissonClient.getMultiLock(locklist);
                    if (rmultiLock != null) {
                        rmultiLock.unlock();
                    }
                }
            }
        }
        throw new RuntimeException("Try locks failure. lockKeys:[" + Arrays.toString(lockKeys) + "]");
    }

    private String[] buildLockKeys(String prefix, Method method, Object[] args) {
        StringBuilder builder = new StringBuilder();
        String[] keyArr = null;
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].isAnnotationPresent(Keys.class)) continue;
            Keys key = parameters[i].getAnnotation(Keys.class);
            String[] exprs = key.exprs();
            if (exprs.length == 0) break;
            keyArr = new String[exprs.length];
            for (int i1 = 0; i1 < exprs.length; ++i1) {
                builder.setLength(0);
                if (Objects.nonNull(prefix) && !prefix.isEmpty()) {
                    builder.append(prefix).append(KEY_SEPARATOR);
                }
                builder.append(this.parseKeyExpr(exprs[i1], parameters[i], args[i]));
                keyArr[i1] = builder.toString();
            }
        }
        return keyArr;
    }
}

