/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.dubbo.filter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.product.datasource.DynamicDataSourceContextHolder;
import com.product.model.ServiceSession;
import com.product.util.RestUtils;
import com.product.util.SpringContext;
import com.product.util.StaticVariable;
import com.product.util.TypeUtils;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

@Activate(group={"provider", "consumer"})
public class DubboSessionFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(DubboSessionFilter.class);
    private static String shopUrl = "http://omni-omdmain/rest?method=omdmain.shop.onQuery";
    private static LoadingCache<String, String> shopDataSourceCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).initialCapacity(20).build((CacheLoader)new CacheLoader<String, String>(){

        public String load(String shopid) throws Exception {
            JSONObject param = new JSONObject();
            param.put("shopCode", (Object)shopid);
            try {
                log.info("\u8bf7\u6c42\u4ed3\u5e93\u8def\u5f84\uff1a{},\u53c2\u6570\uff1a{}", (Object)shopUrl, (Object)param.toString());
                String res = RestUtils.doPost((String)shopUrl, (String)param.toString());
                log.info("\u83b7\u53d6\u4ed3\u5e93\u7ed3\u679c\uff1a{}", (Object)res);
                if (!StringUtils.isEmpty((Object)res)) {
                    JSONObject obj = JSON.parseObject((String)res);
                    JSONArray jsonArray = obj.getJSONObject("data").getJSONArray("shop");
                    for (int i = 0; i < jsonArray.size(); ++i) {
                        JSONObject object = jsonArray.getJSONObject(i);
                        String shopCode = object.getString("shopCode");
                        if (!shopid.equals(shopCode)) continue;
                        String groupCode = object.getString("groupCode");
                        log.info("\u5b58\u5165\u7f13\u5b58\u4ed3\u5e93\u6570\u636e\uff1a{}", (Object)groupCode);
                        return groupCode;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            return null;
        }
    });
    private SerializerFeature[] serializerFeatures = new SerializerFeature[0];

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        if (RpcContext.getContext().isConsumerSide()) {
            ServiceSession session = SpringContext.getSession();
            if (session != null) {
                String dbKeyCode = session.getShop_group();
                if (StringUtils.isEmpty((Object)dbKeyCode)) {
                    session.setShop_group(DynamicDataSourceContextHolder.getRouterKey());
                }
                RpcContext.getContext().setAttachment("session", (Object)TypeUtils.toJSONObj((Object)session, (boolean)false, (SerializerFeature[])this.serializerFeatures));
            } else {
                log.info("session is null ~~~~~~~~~~~~!");
            }
            if (RpcContext.getContext().getObjectAttachment("shopid") != null) {
                String shopid = (String)RpcContext.getContext().getObjectAttachment("shopid");
                try {
                    String groupCode = (String)shopDataSourceCache.get((Object)shopid);
                    if (session == null) {
                        session = new ServiceSession();
                    }
                    log.info("---------dubbo\u8c03\u7528 \u8bbe\u7f6e\u8bbf\u95ee\u6570\u636e\u5e93:{}", (Object)groupCode);
                    session.setShop_group(groupCode);
                    SpringContext.putSession((ServiceSession)session);
                }
                catch (ExecutionException e) {
                    log.error("\u83b7\u53d6\u6570\u636e\u5e93\u7f16\u7801\u5f02\u5e38\uff01");
                    throw new RuntimeException(e);
                }
            }
        } else if (RpcContext.getContext().getObjectAttachment("session") != null) {
            JSONObject serviceSessionJson = (JSONObject)RpcContext.getContext().getObjectAttachment("session");
            ServiceSession serviceSession = (ServiceSession)TypeUtils.cast((Object)serviceSessionJson, ServiceSession.class, (ParserConfig)ParserConfig.getGlobalInstance());
            if (serviceSession != null) {
                String dbKeyCode = serviceSession.getShop_group();
                if (!StringUtils.isEmpty((Object)dbKeyCode)) {
                    if (DynamicDataSourceContextHolder.containDataSourceKey((String)dbKeyCode)) {
                        DynamicDataSourceContextHolder.setRouterKey((String)dbKeyCode);
                        StaticVariable.put((String)"dbKeyCode", (Object)dbKeyCode);
                        log.info("-----> \u5f53\u524d\u9009\u62e9\u6570\u636e\u5e93:" + dbKeyCode);
                    } else {
                        DynamicDataSourceContextHolder.setRouterKey((String)"defaultDs");
                    }
                }
                SpringContext.putSession((ServiceSession)serviceSession);
            }
        } else {
            log.info("RpcContext session is null ~~~~");
        }
        return invoker.invoke(invocation);
    }
}

