/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.utils;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheHttpClientPost {
    private static final Logger log = LoggerFactory.getLogger(ApacheHttpClientPost.class);

    public static String post(String ip, String port, String path, String paramJsonStr) {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        StringBuffer sb = new StringBuffer("http://");
        if (StringUtils.isNotBlank((CharSequence)ip)) {
            sb.append(ip);
        }
        if (StringUtils.isNotBlank((CharSequence)port)) {
            sb.append(":").append(port).append("/");
        }
        if (StringUtils.isNotBlank((CharSequence)path)) {
            sb.append(path);
        }
        log.info("-----------\u8bf7\u6c42\u8def\u5f84\uff1a{}", (Object)sb.toString());
        HttpPost postRequest = new HttpPost(sb.toString());
        try {
            String output;
            StringEntity input = new StringEntity(paramJsonStr);
            input.setContentType("application/json");
            postRequest.setEntity((HttpEntity)input);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)postRequest);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + response.getStatusLine().getStatusCode());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuffer resBuffer = new StringBuffer();
            System.out.println("Output from Server .... \n");
            while ((output = br.readLine()) != null) {
                System.out.println(output);
                resBuffer.append(output);
            }
            String string = resBuffer.toString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    public static String post(String url, String paramJsonStr) {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        log.info("-----------\u8bf7\u6c42\u8def\u5f84\uff1a{}", (Object)url);
        HttpPost postRequest = new HttpPost(url);
        try {
            String output;
            StringEntity input = new StringEntity(paramJsonStr);
            input.setContentType("application/json");
            postRequest.setEntity((HttpEntity)input);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)postRequest);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + response.getStatusLine().getStatusCode());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuffer resBuffer = new StringBuffer();
            System.out.println("Output from Server .... \n");
            while ((output = br.readLine()) != null) {
                System.out.println(output);
                resBuffer.append(output);
            }
            String string = resBuffer.toString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    public static <T> String get(String urlStr, T t) {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        URL url = null;
        String result = "";
        try {
            BasicNameValuePair[] valuePairs = ApacheHttpClientPost.getParamPair(t);
            url = new URL(urlStr);
            URI uri = new URIBuilder().setScheme(url.getProtocol()).setHost(url.getHost()).setPort(url.getPort()).setPath(url.getPath()).setParameters((NameValuePair[])valuePairs).build();
            HttpGet httpGet = new HttpGet(uri);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            int code = response.getStatusLine().getStatusCode();
            if (code == 200) {
                result = EntityUtils.toString((HttpEntity)response.getEntity());
                log.info("\u54cd\u5e94\u7ed3\u679c\u4e3a\uff1a{}", (Object)result);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private static <T> BasicNameValuePair[] getParamPair(T t) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Field[] fields = t.getClass().getDeclaredFields();
        BasicNameValuePair[] valuePairs = new BasicNameValuePair[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            BasicNameValuePair valuePair;
            fields[i].setAccessible(true);
            String value = BeanUtils.getProperty(t, (String)fields[i].getName());
            valuePairs[i] = valuePair = new BasicNameValuePair(fields[i].getName(), value);
        }
        return valuePairs;
    }
}

