/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.utils;

import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.tomcat.util.codec.binary.Base64;

public class AESUtil {
    public static final String SECRET_KEY = "abcdeffedcba2048";
    private static final String KEY_CHARSET = "UTF-8";
    private static final String KEY_ALGORITHM = "AES";
    private static final String CIPHER_ALGORITHM_CBC = "AES/CBC/PKCS5Padding";
    private static final Integer PRIVATE_KEY_SIZE_BIT = 128;
    private static final Integer PRIVATE_KEY_SIZE_BYTE = 16;

    public static String encrypt(String plainText) {
        return AESUtil.encrypt(SECRET_KEY, plainText);
    }

    public static String encrypt(String secretKey, String plainText) {
        if (secretKey.length() != PRIVATE_KEY_SIZE_BYTE.intValue()) {
            throw new RuntimeException("AESUtil:Invalid AES secretKey length (must be 16 bytes)");
        }
        String cipherText = "";
        try {
            Cipher cipher = AESUtil.initParam(secretKey, 1);
            byte[] bytePlainText = plainText.getBytes(KEY_CHARSET);
            byte[] byteCipherText = cipher.doFinal(bytePlainText);
            cipherText = Base64.encodeBase64String((byte[])byteCipherText);
        }
        catch (Exception e) {
            throw new RuntimeException("AESUtil:encrypt fail!", e);
        }
        return cipherText;
    }

    public static String decrypt(String cipherText) {
        return AESUtil.decrypt(SECRET_KEY, cipherText);
    }

    public static String decrypt(String secretKey, String cipherText) {
        if (secretKey.length() != PRIVATE_KEY_SIZE_BYTE.intValue()) {
            throw new RuntimeException("AESUtil:Invalid AES secretKey length (must be 16 bytes)");
        }
        String plainText = "";
        try {
            Cipher cipher = AESUtil.initParam(secretKey, 2);
            byte[] byteCipherText = Base64.decodeBase64((String)cipherText);
            byte[] bytePlainText = cipher.doFinal(byteCipherText);
            plainText = new String(bytePlainText, KEY_CHARSET);
        }
        catch (Exception e) {
            throw new RuntimeException("AESUtil:decrypt fail!", e);
        }
        return plainText;
    }

    public static Cipher initParam(String secretKey, int mode) {
        try {
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(secretKey.getBytes());
            KeyGenerator keygen = KeyGenerator.getInstance(KEY_ALGORITHM);
            keygen.init(PRIVATE_KEY_SIZE_BIT, secureRandom);
            byte[] raw = secretKey.getBytes();
            SecretKeySpec key = new SecretKeySpec(raw, KEY_ALGORITHM);
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM_CBC);
            IvParameterSpec iv = new IvParameterSpec(secretKey.getBytes());
            cipher.init(mode, (Key)key, iv);
            return cipher;
        }
        catch (Exception e) {
            throw new RuntimeException("AESUtil:initParam fail!", e);
        }
    }

    public static void main(String[] args) {
        String text = "hello world!";
        String encryptMsg = AESUtil.encrypt(text);
        System.out.println("\u5bc6\u6587\u4e3a\uff1a" + encryptMsg);
        String decryptMsg = AESUtil.decrypt(encryptMsg);
        System.out.println("\u660e\u6587\u4e3a\uff1a" + decryptMsg);
    }
}

