/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.utils;

import com.alibaba.fastjson.parser.ParserConfig;
import com.efuture.common.mapper.DynamicMapper;
import com.efuture.common.mapper.DynamicSql;
import com.product.storage.template.FMybatisTemplate;
import com.product.util.SpringContext;
import com.product.util.TypeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicSqlUtils {
    private static FMybatisTemplate sqlSession;
    private static DynamicMapper dynamicMapper;
    private static final Logger logger;

    public static FMybatisTemplate getTemplate() {
        return sqlSession;
    }

    public static <T> List<T> executeList(String sql, Map param, Class<T> tClass) {
        ArrayList<Object> result = new ArrayList<Object>();
        DynamicSql.setSql(sql);
        List<HashMap> list = dynamicMapper.DynamicSql(param);
        for (Map map : list) {
            if (tClass.equals(String.class)) {
                Set entrySet = map.entrySet();
                entrySet.forEach(entry -> result.add(TypeUtils.cast(entry.getValue(), (Class)tClass, (ParserConfig)ParserConfig.getGlobalInstance())));
                continue;
            }
            result.add(TypeUtils.cast((Object)map, tClass, (ParserConfig)ParserConfig.getGlobalInstance()));
        }
        return result;
    }

    public static <T> T execute(String sql, Map param, Class<T> tClass) {
        DynamicSql.setSql(sql);
        List<HashMap> list = dynamicMapper.DynamicSql(param);
        if (list == null || list.size() == 0) {
            return null;
        }
        return (T)TypeUtils.cast((Object)list.get(0), tClass, (ParserConfig)ParserConfig.getGlobalInstance());
    }

    public static List executeList(String sql, Map param) {
        DynamicSql.setSql(sql);
        return dynamicMapper.DynamicSql(param);
    }

    static {
        logger = LoggerFactory.getLogger(DynamicSqlUtils.class);
        try {
            sqlSession = (FMybatisTemplate)SpringContext.getContext().getBean("moreStorageOperation", FMybatisTemplate.class);
        }
        catch (Exception e) {
            logger.error("---DynamicSqlUtils--\u83b7\u53d6\u4e0d\u5230\u52a8\u6001\u6570\u636e\u6e90\uff0c\u7ee7\u7eed\u83b7\u914d\u7f6e\u7684FMybatisTemplate\u6570\u636e\u6e90\u3002");
        }
        if (ObjectUtils.isEmpty((Object)sqlSession)) {
            sqlSession = (FMybatisTemplate)SpringContext.getContext().getBean(FMybatisTemplate.class);
        }
        sqlSession.getSqlSessionTemplate().getConfiguration().addMapper(DynamicMapper.class);
        dynamicMapper = (DynamicMapper)sqlSession.getSqlSessionTemplate().getMapper(DynamicMapper.class);
    }
}

