/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.rocketmq.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.common.utils.SessionUtils;
import com.product.datasource.DynamicDataSourceContextHolder;
import com.product.model.ServiceSession;
import com.product.util.SpringContext;
import com.product.util.StaticVariable;
import java.nio.charset.StandardCharsets;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class MyRocketMQListener
implements RocketMQListener<MessageExt> {
    private static final Logger log = LoggerFactory.getLogger(MyRocketMQListener.class);
    private MessageExt message;

    public void onMessage(MessageExt message) {
        log.info("---------> \u76d1\u542c\u5230\u6d88\u606ftopic:{},msgid:{},keys:{},tags:{},queueid:{}", new Object[]{message.getTopic(), message.getMsgId(), message.getKeys(), message.getTags(), message.getQueueId()});
        String sessionJsonStr = message.getProperty("session");
        ServiceSession serviceSession = (ServiceSession)JSON.parseObject((String)sessionJsonStr, ServiceSession.class);
        if (StringUtils.isEmpty((Object)sessionJsonStr)) {
            serviceSession = (ServiceSession)JSONObject.parseObject((String)message.getUserProperty("session"), ServiceSession.class);
        }
        log.info("---------> mq\u6d88\u8d39\u76d1\u542csession:{}", (Object)sessionJsonStr);
        String clientEnv = SpringContext.getEnvironmentVar((String)"spring.cloud.nacos.discovery.namespace");
        log.info("---------> mq\u6d88\u8d39\u83b7\u53d6\u5ba2\u6237\u7aef\u73af\u5883\u53d8\u91cf:{}", (Object)clientEnv);
        String msgEnv = message.getUserProperty("MSGENV");
        log.info("---------> mq\u6d88\u8d39\u83b7\u53d6\u6d88\u606f\u73af\u5883\u53d8\u91cf:{}", (Object)msgEnv);
        this.setMessage(message);
        if (serviceSession != null) {
            String dbKeyCode = serviceSession.getShop_group();
            if (!StringUtils.isEmpty((Object)dbKeyCode)) {
                if (DynamicDataSourceContextHolder.containDataSourceKey((String)dbKeyCode)) {
                    DynamicDataSourceContextHolder.setRouterKey((String)dbKeyCode);
                    log.info("---------> mq\u5207\u6362\u6570\u636e\u6e90\u5230:{}", (Object)dbKeyCode);
                } else {
                    DynamicDataSourceContextHolder.setRouterKey((String)"defaultDs");
                    log.info("---------> mq\u5207\u6362\u6570\u636e\u6e90\u5230:{}", (Object)"defaultDs");
                }
                StaticVariable.put((String)"dbKeyCode", (Object)dbKeyCode);
            } else {
                DynamicDataSourceContextHolder.setRouterKey((String)"defaultDs");
                log.info("---------> mq\u5207\u6362\u6570\u636e\u6e90\u5230:{}", (Object)"defaultDs");
            }
            if (serviceSession.getDbKeyCode() == null) {
                serviceSession.setDbKeyCode(DynamicDataSourceContextHolder.getRouterKey());
                log.info("---------> \u66f4\u65b0serviceSession\u7684DbKeyCode:{}", (Object)DynamicDataSourceContextHolder.getRouterKey());
            }
            SpringContext.putSession((ServiceSession)serviceSession);
        } else {
            SpringContext.putSession((ServiceSession)SessionUtils.init());
        }
        log.info("---------> \u5f53\u524d\u9009\u62e9\u6570\u636e\u6e90:{}", (Object)DynamicDataSourceContextHolder.getRouterKey());
        this.handleMessage(new String(message.getBody(), StandardCharsets.UTF_8), message.getKeys());
    }

    public abstract void handleMessage(String var1, String var2);

    public MessageExt getMessage() {
        return this.message;
    }

    private void setMessage(MessageExt message) {
        this.message = message;
    }
}

