/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.utils;

import com.efuture.common.inter.ExecutService;
import com.efuture.common.utils.ExceptionUtils;
import com.product.datasource.DynamicDataSourceContextHolder;
import com.product.util.SpringContext;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.StringUtils;

public class AsynUtils {
    private static ThreadPoolTaskExecutor executor = (ThreadPoolTaskExecutor)SpringContext.getContext().getBean("taskExecutor", ThreadPoolTaskExecutor.class);

    public static <T> CompletableFuture<T> getFuture(ExecutService<T> executService, String routerKey) {
        if (StringUtils.isEmpty((Object)routerKey)) {
            routerKey = DynamicDataSourceContextHolder.getRouterKey();
        }
        if (StringUtils.isEmpty((Object)routerKey)) {
            ExceptionUtils.raise("\u65e0\u6cd5\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\uff01");
        }
        String finalRouterKey = routerKey;
        CompletableFuture<Object> future = CompletableFuture.supplyAsync(() -> {
            DynamicDataSourceContextHolder.setRouterKey((String)finalRouterKey);
            return executService.doExecut();
        }, (Executor)executor);
        return future;
    }

    public static <T> CompletableFuture<T> getFuture(ExecutService<T> executService) {
        String routerKey = DynamicDataSourceContextHolder.getRouterKey();
        if (StringUtils.isEmpty((Object)routerKey)) {
            ExceptionUtils.raise("\u65e0\u6cd5\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\uff01");
        }
        String finalRouterKey = routerKey;
        CompletableFuture<Object> future = CompletableFuture.supplyAsync(() -> {
            DynamicDataSourceContextHolder.setRouterKey((String)finalRouterKey);
            return executService.doExecut();
        }, (Executor)executor);
        return future;
    }
}

