/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.utils;

import com.efuture.common.utils.JacksonConversionUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignUtil {
    private static final Logger log = LoggerFactory.getLogger(SignUtil.class);

    public static String generateSign(Map<String, String> params, String charset) {
        if (MapUtils.isEmpty(params)) {
            return "";
        }
        Map sortedParams = params.entrySet().stream().filter(entry -> entry != null && entry.getValue() != null).filter(entry -> !((String)entry.getKey()).equals("sign") && !((String)entry.getKey()).equals("sign_type")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1, TreeMap::new));
        Map<String, String> stringParams = SignUtil.flattenToStringMap(sortedParams);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry2 : stringParams.entrySet()) {
            sb.append(entry2.getKey()).append("=").append(entry2.getValue()).append("&");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        log.info("\u8bf7\u6c42.params.signStr:{}", (Object)sb);
        String md5Result = SignUtil.md5(sb.toString(), charset);
        return Base64.getEncoder().encodeToString(md5Result.getBytes(Charset.forName(charset)));
    }

    public static Map<String, String> flattenToStringMap(Map<String, Object> input) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        if (input == null) {
            return result;
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
        input.forEach((key, value) -> {
            if (value == null) {
                return;
            }
            if (value instanceof String || value instanceof Number || value instanceof Boolean) {
                result.put((String)key, String.valueOf(value));
            } else {
                if (value instanceof Map) {
                    Map sortedMap = new TreeMap((Map)value);
                    sortedMap = sortedMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                        if (entry.getValue() instanceof Map) {
                            return new TreeMap((Map)entry.getValue());
                        }
                        return entry.getValue();
                    }, (v1, v2) -> v1, TreeMap::new));
                    try {
                        result.put((String)key, mapper.writeValueAsString(sortedMap));
                    }
                    catch (JsonProcessingException e) {
                        throw new RuntimeException("\u5b57\u6bb5 " + key + " \u5e8f\u5217\u5316\u4e3a JSON \u5b57\u7b26\u4e32\u5931\u8d25", e);
                    }
                }
                try {
                    result.put((String)key, mapper.writeValueAsString(value));
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException("\u5b57\u6bb5 " + key + " \u5e8f\u5217\u5316\u4e3a JSON \u5b57\u7b26\u4e32\u5931\u8d25", e);
                }
            }
        });
        return result;
    }

    public static boolean verifySignature(String json, String charset, boolean signCheck) {
        if (!signCheck) {
            return true;
        }
        Map<String, Object> map = JacksonConversionUtil.jsonToObjectMap(json);
        if (map == null) {
            return false;
        }
        Object signObj = map.get("sign");
        if (!(signObj instanceof String)) {
            return false;
        }
        String receivedSign = (String)signObj;
        Map<String, String> stringMap = JacksonConversionUtil.convertToStringMap(map);
        String generatedSign = SignUtil.generateSign(stringMap, charset);
        return receivedSign.equals(generatedSign);
    }

    private static String md5(String input, String charset) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] array = md.digest(input.getBytes(Charset.forName(charset)));
            StringBuilder sb = new StringBuilder();
            for (byte b : array) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("MD5 calculation failed", e);
        }
    }
}

