/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.aop;

import com.product.annotation.redis.CacheLock;
import com.product.annotation.redis.CacheParam;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;

@Aspect
public class SheetIdLockInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SheetIdLockInterceptor.class);
    private static final String KEY_SEPARATOR = ":";
    @Autowired
    private RedissonClient redissonClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution(public * com.product.component.globrule.GlobRuleSrvimpl.getlast(..))")
    public Object doAround(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method targetMethod = methodSignature.getMethod();
        String lockKey = this.buildLockKey(targetMethod.getAnnotation(CacheLock.class).prefix(), targetMethod, joinPoint.getArgs());
        log.debug("Start fetch distribut lock,key={}", (Object)lockKey);
        RLock rLock = this.redissonClient.getLock(lockKey);
        if (rLock.tryLock(30L, TimeUnit.SECONDS)) {
            log.debug("Fetch distribut lock success,key={}", (Object)lockKey);
            try {
                Object object = joinPoint.proceed();
                return object;
            }
            finally {
                log.debug("Release distribut lock success,key={}", (Object)lockKey);
                RLock lock = this.redissonClient.getLock(lockKey);
                if (lock.isLocked() && lock.isHeldByCurrentThread()) {
                    lock.unlock();
                }
            }
        }
        throw new RuntimeException("Try lock failure.");
    }

    private String buildLockKey(String prefix, Method method, Object[] args) {
        StringBuilder builder = new StringBuilder();
        if (Objects.nonNull(prefix) && !prefix.isEmpty()) {
            builder.append(prefix).append(KEY_SEPARATOR);
        }
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].isAnnotationPresent(CacheParam.class)) continue;
            CacheParam key = parameters[i].getAnnotation(CacheParam.class);
            builder.append(this.parseKeyExpr(key.name(), args[i])).append(KEY_SEPARATOR);
        }
        return builder.substring(0, builder.length() - 1);
    }

    private String parseKeyExpr(String expr, Object arg) {
        if (Objects.isNull(expr) || expr.isEmpty()) {
            return arg.toString();
        }
        SpelExpressionParser parser = new SpelExpressionParser();
        Expression expression = parser.parseExpression(expr, (ParserContext)new TemplateParserContext());
        return (String)expression.getValue(arg, String.class);
    }
}

