/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.config;

import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"rocketmq.enabled"}, havingValue="true", matchIfMissing=true)
public class RocketMqConfig {
    private static final Logger log = LoggerFactory.getLogger(RocketMqConfig.class);
    @Value(value="${rocketmq.producer.group:}")
    private String producerGroup;
    @Value(value="${rocketmq.name-server:}")
    private String nameServer;
    @Value(value="${rocketmq.producer.send-message-timeout:}")
    private Integer sendMessageTimeout;
    @Value(value="${rocketmq.producer.retry-times-when-send-failed:}")
    private Integer retryTimesWhenSendFailed;
    @Value(value="${rocketmq.producer.retry-times-when-send-async-failed:}")
    private Integer retryTimesWhenSendAsyncFailed;

    @Bean
    public RocketMQTemplate rocketMqTemplate() {
        RocketMQTemplate rocketMgTemplate = new RocketMQTemplate();
        DefaultMQProducer defaultMgProducer = new DefaultMQProducer();
        defaultMgProducer.setProducerGroup(this.producerGroup);
        defaultMgProducer.setNamesrvAddr(this.nameServer);
        defaultMgProducer.setSendMsgTimeout(this.sendMessageTimeout.intValue());
        defaultMgProducer.setRetryTimesWhenSendFailed(this.retryTimesWhenSendFailed.intValue());
        defaultMgProducer.setRetryTimesWhenSendAsyncFailed(this.retryTimesWhenSendAsyncFailed.intValue());
        rocketMgTemplate.setProducer(defaultMgProducer);
        log.info("-------> rocketmq template\u542f\u52a8\u6210\u529f");
        return rocketMgTemplate;
    }
}

