/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.utils;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateFormatUtil {
    private static final Logger log = LoggerFactory.getLogger(DateFormatUtil.class);
    private static final List<DateTimeFormatter> SUPPORTED_FORMATTERS = Arrays.asList(DateTimeFormatter.ofPattern("yyyy-MM-dd"), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"), DateTimeFormatter.ofPattern("yyyy/MM/dd"), DateTimeFormatter.ofPattern("yyyyMMdd"));
    private static final DateTimeFormatter TARGET_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");

    public static String toYyyyMMdd(String dateStr) {
        for (DateTimeFormatter formatter : SUPPORTED_FORMATTERS) {
            try {
                LocalDate date = LocalDate.parse(dateStr, formatter);
                return date.format(TARGET_FORMATTER);
            }
            catch (DateTimeParseException e) {
                log.error("\u65e0\u6cd5\u89e3\u6790\u65e5\u671f\u5b57\u7b26\u4e32-\u5c1d\u8bd5\u4e0b\u4e00\u4e2a\u683c\u5f0f:{}", (Object)dateStr, (Object)e);
            }
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println(DateFormatUtil.toYyyyMMdd("2025-06-30"));
        System.out.println(DateFormatUtil.toYyyyMMdd("2024-12-20 00:00:00"));
        System.out.println(DateFormatUtil.toYyyyMMdd("2024/01/01"));
        System.out.println(DateFormatUtil.toYyyyMMdd("20240701"));
    }
}

