/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.utils;

import com.alibaba.fastjson.parser.ParserConfig;
import com.efuture.common.model.Account;
import com.efuture.common.utils.AccountUtils;
import com.efuture.common.utils.DynamicSqlUtils;
import com.efuture.common.utils.ExceptionUtils;
import com.efuture.common.utils.PageInfo;
import com.github.pagehelper.ISelect;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.product.model.ServiceResponse;
import com.product.service.AnnotationService;
import com.product.service.OperationFlag;
import com.product.util.SpringContext;
import com.product.util.TypeUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.RowBounds;

public class PageUtils {
    public static ServiceResponse pageSelect(String statement, Object params) {
        int page_no = 0;
        int page_size = 0;
        try {
            page_no = Integer.parseInt(BeanUtils.getProperty((Object)params, (String)"page_no"));
            page_size = Integer.parseInt(BeanUtils.getProperty((Object)params, (String)"page_size"));
        }
        catch (Exception e) {
            ExceptionUtils.raise("\u5206\u9875\u6761\u4ef6\u4e0d\u6b63\u786e,\u8bf7\u68c0\u67e5\uff01");
        }
        RowBounds rowBounds = new RowBounds((page_no - 1) * page_size, page_size);
        Map map = (Map)TypeUtils.cast((Object)params, Map.class, (ParserConfig)ParserConfig.getGlobalInstance());
        List list = DynamicSqlUtils.getTemplate().getSqlSessionTemplate().selectList(statement, (Object)map, rowBounds);
        Page page = (Page)list;
        return ServiceResponse.buildSuccess((Object)new PageInfo(page.getResult(), page.getTotal()));
    }

    public static ServiceResponse pageSelect(ISelect select, Object params) {
        int page_no = 0;
        int page_size = 0;
        try {
            page_no = Integer.parseInt(BeanUtils.getProperty((Object)params, (String)"page_no"));
            page_size = Integer.parseInt(BeanUtils.getProperty((Object)params, (String)"page_size"));
        }
        catch (Exception e) {
            ExceptionUtils.raise("\u5206\u9875\u6761\u4ef6\u4e0d\u6b63\u786e,\u8bf7\u68c0\u67e5\uff01");
        }
        Page page = PageHelper.startPage((int)page_no, (int)page_size);
        page.doSelectPage(select);
        return ServiceResponse.buildSuccess((Object)new PageInfo(page.getResult(), page.getTotal()));
    }

    public static ServiceResponse pageSelectWithUserHandleRes(ISelect select, Object params, List<AnnotationService> getPlugins, Class resultClass) {
        Page page = PageUtils.pageSelectWithUserHandle(select, params, getPlugins, resultClass);
        PageInfo pageInfo = new PageInfo(page.getResult(), page.getTotal());
        return ServiceResponse.buildSuccess((Object)pageInfo);
    }

    public static Page pageSelectWithUserHandle(ISelect select, Object params, List<AnnotationService> getPlugins, Class resultClass) {
        int page_no = 0;
        int page_size = 0;
        try {
            page_no = Integer.parseInt(BeanUtils.getProperty((Object)params, (String)"page_no"));
            page_size = Integer.parseInt(BeanUtils.getProperty((Object)params, (String)"page_size"));
        }
        catch (Exception e) {
            ExceptionUtils.raise("\u5206\u9875\u6761\u4ef6\u4e0d\u6b63\u786e,\u8bf7\u68c0\u67e5\uff01");
        }
        Page page = PageHelper.startPage((int)page_no, (int)page_size);
        page.doSelectPage(select);
        if (resultClass == null) {
            List list = page.getResult();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                List<Account> accountList = AccountUtils.getAccountList();
                Map<String, String> accountMap = accountList.stream().collect(Collectors.toMap(Account::getUserCode, Account::getUserName));
                list.forEach(r -> {
                    String prtmemo;
                    String modifier;
                    String creator;
                    String operator;
                    String checker;
                    Map s = (Map)r;
                    String editor = MapUtils.getString((Map)s, (Object)"editor");
                    if (StringUtils.isNotBlank((CharSequence)editor)) {
                        s.put("editorStr", "[" + editor + "]" + Optional.ofNullable((String)accountMap.get(editor)).orElse(""));
                    }
                    if (StringUtils.isNotBlank((CharSequence)(checker = MapUtils.getString((Map)s, (Object)"checker")))) {
                        s.put("checkerStr", "[" + checker + "]" + Optional.ofNullable((String)accountMap.get(checker)).orElse(""));
                    }
                    if (StringUtils.isNotBlank((CharSequence)(operator = MapUtils.getString((Map)s, (Object)"operator")))) {
                        s.put("operatorStr", "[" + operator + "]" + Optional.ofNullable((String)accountMap.get(operator)).orElse(""));
                    }
                    if (StringUtils.isNotBlank((CharSequence)(creator = MapUtils.getString((Map)s, (Object)"creator")))) {
                        s.put("creatorStr", "[" + creator + "]" + Optional.ofNullable((String)accountMap.get(creator)).orElse(""));
                    }
                    if (StringUtils.isNotBlank((CharSequence)(modifier = MapUtils.getString((Map)s, (Object)"modifier")))) {
                        s.put("modifierStr", "[" + modifier + "]" + Optional.ofNullable((String)accountMap.get(modifier)).orElse(""));
                    }
                    if (StringUtils.isNotBlank((CharSequence)(prtmemo = MapUtils.getString((Map)s, (Object)"prtmemo")))) {
                        s.put("prtmemoStr", "[" + prtmemo + "]" + Optional.ofNullable((String)accountMap.get(prtmemo)).orElse(""));
                    }
                });
            }
        } else {
            getPlugins.forEach(p -> {
                try {
                    p.onAction(SpringContext.getSession(), (Object)page.getResult(), OperationFlag.afterQuery, resultClass);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return page;
    }

    public static ServiceResponse pageSqlSelect(String sql, Object params) {
        int page_no = 0;
        int page_size = 0;
        try {
            page_no = Integer.parseInt(BeanUtils.getProperty((Object)params, (String)"page_no"));
            page_size = Integer.parseInt(BeanUtils.getProperty((Object)params, (String)"page_size"));
        }
        catch (Exception e) {
            ExceptionUtils.raise("\u5206\u9875\u6761\u4ef6\u4e0d\u6b63\u786e,\u8bf7\u68c0\u67e5\uff01");
        }
        Map map = (Map)TypeUtils.cast((Object)params, Map.class, (ParserConfig)ParserConfig.getGlobalInstance());
        Page page = PageHelper.startPage((int)page_no, (int)page_size);
        page.doSelectPage(() -> DynamicSqlUtils.executeList(sql, map));
        return ServiceResponse.buildSuccess((Object)new PageInfo(page.getResult(), page.getTotal()));
    }

    public static ServiceResponse pageList(List list, Object params) {
        int page_no = 0;
        int page_size = 0;
        try {
            page_no = Integer.parseInt(BeanUtils.getProperty((Object)params, (String)"page_no"));
            page_size = Integer.parseInt(BeanUtils.getProperty((Object)params, (String)"page_size"));
        }
        catch (Exception e) {
            ExceptionUtils.raise("\u5206\u9875\u6761\u4ef6\u4e0d\u6b63\u786e,\u8bf7\u68c0\u67e5\uff01");
        }
        long total = list.size();
        List subList = list.stream().skip((page_no - 1) * page_size).limit(page_size).collect(Collectors.toList());
        return ServiceResponse.buildSuccess((Object)new PageInfo(subList, total));
    }

    public static <T> PageInfo convert(com.github.pagehelper.PageInfo<T> pageInfo) {
        return new PageInfo(pageInfo.getList(), pageInfo.getTotal());
    }
}

