/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.rocketmq.transaction;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.common.rocketmq.producer.function.DoSomething;
import com.efuture.common.rocketmq.transaction.model.BackCheckDTO;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.util.RestUtils;
import com.product.util.SpringContext;
import com.product.util.StaticVariable;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.RocketMQTransactionListener;
import org.apache.rocketmq.spring.core.RocketMQLocalTransactionListener;
import org.apache.rocketmq.spring.core.RocketMQLocalTransactionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;

@ConditionalOnExpression(value="${rocketmq.transactionListener.enabled:false}")
@RocketMQTransactionListener
public class MQLocalTransactionListener
implements RocketMQLocalTransactionListener {
    private static final Logger log = LoggerFactory.getLogger(MQLocalTransactionListener.class);

    public RocketMQLocalTransactionState executeLocalTransaction(Message message, Object arg) {
        try {
            if (arg instanceof DoSomething) {
                log.info("\u6267\u884c\u4e8b\u52a1,\u53c2\u6570KEY:{}", message.getHeaders().get((Object)"rocketMq_KEYS"));
                DoSomething doSomething = (DoSomething)arg;
                Object res = doSomething.justDoIt();
                if (ObjectUtils.isNotEmpty((Object)res) && res instanceof RocketMQLocalTransactionState) {
                    return (RocketMQLocalTransactionState)res;
                }
            }
        }
        catch (Exception e) {
            log.info("======\u6267\u884c\u4e8b\u52a1\u6d88\u606f\u4e1a\u52a1\u4f53\u5931\u8d25=======");
            e.printStackTrace();
            return RocketMQLocalTransactionState.ROLLBACK;
        }
        return RocketMQLocalTransactionState.COMMIT;
    }

    public RocketMQLocalTransactionState checkLocalTransaction(Message message) {
        String jsonStr = new String((byte[])message.getPayload(), StandardCharsets.UTF_8);
        try {
            MessageHeaders headers = message.getHeaders();
            log.info("\u6d88\u606f\u56de\u67e5,MessageHeaders:{}", (Object)headers);
            String service = (String)headers.get((Object)"SERVICE", String.class);
            String method = (String)headers.get((Object)"METHOD", String.class);
            String checkTimes = (String)headers.get((Object)"TRANSACTION_CHECK_TIMES", String.class);
            ServiceSession serviceSession = (ServiceSession)JSONObject.parseObject((String)((String)message.getHeaders().get((Object)"session", String.class)), ServiceSession.class);
            SpringContext.putSession((ServiceSession)serviceSession);
            StaticVariable.put((String)"dbKeyCode", (Object)serviceSession.getDbKeyCode());
            BackCheckDTO backCheckDTO = new BackCheckDTO(jsonStr, Integer.parseInt(checkTimes));
            String value = JSONObject.toJSONString((Object)backCheckDTO);
            String body = (String)RestUtils.doPost((String)("http://" + service + "/rest?method=" + method), null, (String)value, String.class);
            ServiceResponse response = (ServiceResponse)JSON.parseObject((String)body, ServiceResponse.class);
            String returncode = response.getReturncode();
            if (!StringUtils.equals((CharSequence)returncode, (CharSequence)"0")) {
                return RocketMQLocalTransactionState.UNKNOWN;
            }
            Object data = response.getData();
            if (ObjectUtils.isNotEmpty((Object)data)) {
                if (data instanceof RocketMQLocalTransactionState) {
                    return (RocketMQLocalTransactionState)data;
                }
                return RocketMQLocalTransactionState.ROLLBACK;
            }
            return RocketMQLocalTransactionState.ROLLBACK;
        }
        catch (Exception e) {
            e.printStackTrace();
            return RocketMQLocalTransactionState.ROLLBACK;
        }
    }
}

