/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.efuture.common.utils.ExceptionUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.springframework.util.CollectionUtils;

public class HttpClientUtil {
    public static String doGet(String url, Map<String, String> params) throws Exception {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            String string;
            block14: {
                URIBuilder uriBuilder = new URIBuilder(url);
                if (params != null) {
                    for (Map.Entry<String, String> entry : params.entrySet()) {
                        uriBuilder.addParameter(entry.getKey(), entry.getValue());
                    }
                }
                HttpGet httpGet = new HttpGet(uriBuilder.build());
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                try {
                    string = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                    if (response == null) break block14;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
    }

    public static String doPost(String url, Map<String, String> params) throws Exception {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(60000).setConnectionRequestTimeout(60000).setSocketTimeout(600000).build();
        try (CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).build();){
            String string;
            block14: {
                HttpPost httpPost = new HttpPost(url);
                if (params != null) {
                    ArrayList<BasicNameValuePair> paramList = new ArrayList<BasicNameValuePair>();
                    for (Map.Entry entry : params.entrySet()) {
                        paramList.add(new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue()));
                    }
                    httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(paramList, StandardCharsets.UTF_8));
                }
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                try {
                    string = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                    if (response == null) break block14;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
    }

    public static String doPostJson(String url, Map<String, Object> params) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json;charset=UTF-8");
        return HttpClientUtil.doPost(url, params, headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, Map<String, Object> params, Map<String, String> headers) {
        String result = "";
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setConnectTimeout(5000);
        configBuilder.setSocketTimeout(60000);
        configBuilder.setConnectionRequestTimeout(5000);
        httpPost.setConfig(configBuilder.build());
        if (!CollectionUtils.isEmpty(headers)) {
            headers.forEach((arg_0, arg_1) -> ((HttpPost)httpPost).addHeader(arg_0, arg_1));
        }
        if (!CollectionUtils.isEmpty(params)) {
            httpPost.setEntity((HttpEntity)new StringEntity(JSON.toJSONString(params, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), "UTF-8"));
        }
        try {
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            EntityUtils.consume((HttpEntity)entity);
        }
        catch (IOException e) {
            e.printStackTrace();
            ExceptionUtils.raise("\u8bf7\u6c42\u5931\u8d25");
        }
        finally {
            try {
                if (null != httpclient) {
                    httpclient.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                ExceptionUtils.raise("\u8bf7\u6c42\u5173\u95ed\u5931\u8d25");
            }
        }
        return result;
    }
}

