/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.utils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import org.springframework.beans.BeanWrapperImpl;

public class CustomBeanUtils {
    public static String[] getNullPropertyNames(Object source, String ... ignoreProperties) {
        BeanWrapperImpl src = new BeanWrapperImpl(source);
        PropertyDescriptor[] pds = src.getPropertyDescriptors();
        HashSet<String> emptyNames = new HashSet<String>();
        for (PropertyDescriptor pd : pds) {
            Object srcValue = src.getPropertyValue(pd.getName());
            if (srcValue != null) continue;
            emptyNames.add(pd.getName());
        }
        emptyNames.addAll(Arrays.asList(ignoreProperties));
        String[] result = new String[emptyNames.size()];
        return emptyNames.toArray(result);
    }

    public static void copyFields(Object source, Object destination, String ... fields) throws NoSuchFieldException, IllegalAccessException {
        Class<?> sourceClass = source.getClass();
        Class<?> destinationClass = destination.getClass();
        if (Objects.nonNull(fields)) {
            for (String field : fields) {
                Field sourceField = sourceClass.getDeclaredField(field);
                Field destinationField = destinationClass.getDeclaredField(field);
                sourceField.setAccessible(true);
                destinationField.setAccessible(true);
                destinationField.set(destination, sourceField.get(source));
            }
        }
    }
}

