/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.component.impl;

import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import com.efuture.common.component.impl.IsceLogMongoRecoderServiceImpl;
import com.efuture.common.model.Slf4jDbLog;
import com.product.util.SpringContext;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

@Component
public class MongoDBAppender
extends UnsynchronizedAppenderBase<LoggingEvent> {
    private IsceLogMongoRecoderServiceImpl logMongoRecoderService = null;
    private MongoTemplate mongoTemplate;

    protected void append(LoggingEvent loggingEvent) {
        if (Objects.nonNull(SpringContext.getContext())) {
            this.logMongoRecoderService = (IsceLogMongoRecoderServiceImpl)SpringContext.getContext().getBean(IsceLogMongoRecoderServiceImpl.class);
            if (Objects.nonNull(this.logMongoRecoderService)) {
                String loggerName = loggingEvent.getLoggerName();
                Slf4jDbLog log = new Slf4jDbLog();
                Date date = new Date();
                log.setLogTime(date);
                log.setLogThread(loggingEvent.getThreadName());
                log.setLogClass(loggerName);
                log.setLogLevel(loggingEvent.getLevel().toString());
                Map propertyMap = loggingEvent.getMDCPropertyMap();
                log.setTrackId(Objects.isNull(propertyMap) ? "" : (String)propertyMap.get("TRACE_ID"));
                log.setLogContent(loggingEvent.getFormattedMessage());
                this.logMongoRecoderService.saveSlf4jLog(log);
            }
        }
    }
}

