/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.isce.wmsinv.service.impl.invcell;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.common.utils.ExceptionUtils;
import com.efuture.common.utils.IsceModelUtil;
import com.efuture.common.utils.QueryUtils;
import com.efuture.isce.wms.inv.inv.InvCellMove;
import com.efuture.isce.wms.inv.inv.InvCellQty;
import com.efuture.isce.wms.inv.model.entity.InvLock;
import com.efuture.isce.wms.inv.model.entity.InvLockItem;
import com.efuture.isce.wms.inv.model.entity.InvLocksItem;
import com.efuture.isce.wms.inv.model.entity.InvLot;
import com.efuture.isce.wms.inv.model.entity.InvLotInfo;
import com.efuture.isce.wms.inv.vo.DedInvcellqtyOrderVo;
import com.efuture.isce.wms.inv.vo.DedInvcellqtyVo;
import com.efuture.isce.wms.inv.vo.InvCellFreezeVo;
import com.efuture.isce.wms.inv.vo.InvLotProVo;
import com.efuture.isce.wms.inv.vo.InvcellMoveLogVo;
import com.efuture.isce.wms.inv.vo.InvcellqtyMoveVo;
import com.efuture.isce.wms.inv.vo.InvcellqtyOrderVo;
import com.efuture.isce.wms.inv.vo.InvcellqtyVo;
import com.efuture.isce.wms.inv.vo.RealTimeInvVo;
import com.efuture.isce.wms.stock.Omoutstocksitem;
import com.efuture.isce.wmsinv.enums.SheetFlagEnum;
import com.efuture.isce.wmsinv.service.impl.invcell.InvLockServiceImpl;
import com.efuture.isce.wmsinv.service.invcell.InvCellQtyService;
import com.efuture.isce.wmsinv.service.invlog.InvCellMoveService;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.product.component.JDBCCompomentServiceImpl;
import com.product.model.ServiceSession;
import com.product.storage.template.FMybatisTemplate;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class InvCellQtyServiceImpl
extends JDBCCompomentServiceImpl<InvCellQty>
implements InvCellQtyService {
    private static final Logger log = LoggerFactory.getLogger(InvCellQtyServiceImpl.class);
    @Autowired
    private InvCellMoveService cellmoveService;
    @Autowired
    private InvLockServiceImpl invLockService;

    public InvCellQtyServiceImpl(FMybatisTemplate mybatisTemplate) {
        super(mybatisTemplate, "invcellqty", "id");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer addInvCell(InvcellqtyVo invcellqtyVo) {
        InvLotInfo invLotinfo = this.getInvLotinfo(invcellqtyVo.getEntid(), invcellqtyVo.getGdcode(), invcellqtyVo.getLotid());
        if (invLotinfo == null) {
            ExceptionUtils.raise((String)MessageFormat.format("\u4f01\u4e1a[{0}]\u4e0b\u6ca1\u6709\u5546\u54c1\u5185\u7801\u4e3a[{1}]\u5546\u54c1\u5c5e\u6027ID\u4e3a[{2}]\u7684\u4fe1\u606f\uff01[{3}]", invcellqtyVo.getEntid(), invcellqtyVo.getGdcode(), invcellqtyVo.getLotid(), "addInvCell"));
        }
        String entid = invcellqtyVo.getEntid();
        String shopid = invcellqtyVo.getShopid();
        String cellno = invcellqtyVo.getCellno();
        JSONObject paramMap = new JSONObject();
        paramMap.put("entid", (Object)entid);
        paramMap.put("shopid", (Object)shopid);
        paramMap.put("cellno", (Object)cellno);
        InvCellQty invcellqty = null;
        if (invcellqtyVo.getCellid() != -1) {
            Integer cellid = invcellqtyVo.getCellid();
            paramMap.put("cellid", (Object)cellid);
            invcellqty = (InvCellQty)this.getTemplate().selectOne(QueryUtils.build((Map)paramMap), InvCellQty.class);
            if (invcellqty == null) {
                invcellqty = this.getAddInvcellqtyEntity(invcellqtyVo, invLotinfo);
                this.onInsert(ServiceSession.getSession(), invcellqty);
            } else {
                Update update = Update.update((String)"qty", (Object)invcellqty.getQty().add(invcellqtyVo.getQty())).set("modifier", (Object)invcellqtyVo.getOperator()).set("modifytime", (Object)new Date());
                int row = this.getTemplate().update(QueryUtils.build((Map)paramMap), update, InvCellQty.class);
                if (row != 1) {
                    log.error("\u66f4\u65b0\u5e93\u5b58\u5931\u8d25\uff01[{}]", (Object)paramMap);
                    ExceptionUtils.raise((String)"\u66f4\u65b0\u5e93\u5b58\u5931\u8d25\uff01");
                }
            }
        } else {
            Integer cellid = this.getMaxCellid(entid, shopid, cellno);
            invcellqty = this.getAddInvcellqtyEntity(invcellqtyVo, invLotinfo);
            invcellqty.setCellid(cellid);
            this.getTemplate().insert((Object)invcellqty);
        }
        this.cleanInvCellqty(invcellqtyVo.getEntid(), invcellqtyVo.getShopid(), invcellqtyVo.getCellno());
        return invcellqty.getCellid();
    }

    private Integer getMaxCellid(String entid, String shopid, String cellno) {
        JSONObject paramObj = new JSONObject();
        paramObj.put("entid", (Object)entid);
        paramObj.put("shopid", (Object)shopid);
        paramObj.put("cellno", (Object)cellno);
        Integer cellid = -1;
        List invcellqtyList = this.dataQuery(ServiceSession.getSession(), paramObj, InvCellQty.class);
        if (!CollectionUtils.isEmpty((Collection)invcellqtyList)) {
            InvCellQty maxcell = invcellqtyList.stream().max(Comparator.comparing(InvCellQty::getCellid)).get();
            cellid = maxcell.getCellid() + 1;
        } else {
            log.info("\u6839\u636e\u6761\u4ef6[{}],\u67e5\u8be2\u4e0d\u5230\u50a8\u4f4d\u5e93\u5b58\u8bb0\u5f55\uff01", (Object)paramObj);
        }
        return cellid;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer invCellOrder(InvcellqtyOrderVo invcellqtyOrderVo) {
        InvCellQty invcellqty;
        BigDecimal subQty;
        InvLotInfo invLotinfo = this.getInvLotinfo(invcellqtyOrderVo.getEntid(), invcellqtyOrderVo.getGdcode(), invcellqtyOrderVo.getLotid());
        if (invLotinfo == null) {
            ExceptionUtils.raise((String)MessageFormat.format("\u4f01\u4e1a[{0}]\u4e0b\u6ca1\u6709\u5546\u54c1\u5185\u7801\u4e3a[{1}]\u5546\u54c1\u5c5e\u6027ID\u4e3a[{2}]\u7684\u4fe1\u606f\uff01[{3}]", invcellqtyOrderVo.getEntid(), invcellqtyOrderVo.getGdcode(), invcellqtyOrderVo.getLotid(), "invCellOrder"));
        }
        if ((subQty = (invcellqty = this.getInvcellqty(invcellqtyOrderVo.getEntid(), invcellqtyOrderVo.getShopid(), invcellqtyOrderVo.getCellno(), invcellqtyOrderVo.getCellid())).getQty().subtract(invcellqty.getOutstockqty()).add(invcellqty.getInstockqty()).subtract(invcellqty.getFreezeqty()).subtract(invcellqtyOrderVo.getQty())).compareTo(BigDecimal.ZERO) == -1) {
            ExceptionUtils.raise((String)MessageFormat.format("\u4f01\u4e1a[{0}]\u4ed3\u522b[{1}]\u50a8\u4f4d\u4ee3\u7801[{2}]\u50a8\u4f4dID[{3}]\u7684\u50a8\u4f4d\u5e93\u5b58[{4}]\u4e0d\u8db3\u4ee5\u9884\u7ea6\uff01[{5}]", invcellqtyOrderVo.getEntid(), invcellqtyOrderVo.getShopid(), invcellqtyOrderVo.getCellno(), invcellqtyOrderVo.getCellid(), invcellqty.getQty(), "invCellOrder"));
        }
        HashMap map = Maps.newHashMap();
        map.put("entid", invcellqtyOrderVo.getEntid());
        map.put("shopid", invcellqtyOrderVo.getShopid());
        map.put("cellno", invcellqtyOrderVo.getCellno());
        map.put("cellid", invcellqtyOrderVo.getCellid());
        InvCellQty tarInvcellqty = null;
        Update update = null;
        invcellqty.setOutstockqty(invcellqty.getOutstockqty().add(invcellqtyOrderVo.getQty()));
        int up = this.onUpdateBean(invcellqty, Sets.newHashSet((Object[])new String[]{"outstockqty"}));
        if (up == 1) {
            String lpnname = invcellqty.getLpnname();
            if (StringUtils.isEmpty((Object)lpnname)) {
                lpnname = invcellqtyOrderVo.getLpnname();
            }
            HashMap tmap = Maps.newHashMap();
            tmap.put("entid", invcellqtyOrderVo.getEntid());
            tmap.put("shopid", invcellqtyOrderVo.getShopid());
            tmap.put("cellno", StringUtils.isEmpty((Object)invcellqtyOrderVo.getTargetCellno()) ? "-1" : invcellqtyOrderVo.getTargetCellno());
            tmap.put("gdcode", invcellqtyOrderVo.getGdcode());
            tmap.put("lotid", invcellqtyOrderVo.getLotid());
            tmap.put("lpnname", invcellqtyOrderVo.getLpnname());
            tmap.put("instocktype", invcellqtyOrderVo.getInstocktype());
            tmap.put("deptid", invcellqtyOrderVo.getTargetDeptid());
            tarInvcellqty = (InvCellQty)this.getTemplate().selectOne(QueryUtils.build((Map)tmap), InvCellQty.class);
            if (tarInvcellqty != null) {
                update = Update.update((String)"outstockqty", (Object)tarInvcellqty.getOutstockqty().subtract(invcellqtyOrderVo.getQty()));
                int tup = this.getTemplate().update(QueryUtils.build((Map)tmap), update, InvCellQty.class);
                if (tup != 1) {
                    ExceptionUtils.raise((String)MessageFormat.format("\u66f4\u65b0\u50a8\u4f4d\u5e93\u5b58\u5931\u8d25\uff01{0}", tmap));
                }
            } else {
                InvCellQty invcell = this.getAddInvcellqtyEntity((InvcellqtyVo)invcellqtyOrderVo, invLotinfo);
                invcell.setQty(BigDecimal.ZERO);
                invcell.setOutstockqty(BigDecimal.ZERO);
                invcell.setInstockqty(invcellqtyOrderVo.getQty());
                this.onInsert(ServiceSession.getSession(), invcell);
                tarInvcellqty = (InvCellQty)this.getTemplate().selectOne(QueryUtils.build((Map)tmap), InvCellQty.class);
            }
        } else {
            log.error("[{}]\u66f4\u65b0\u50a8\u4f4d\u5e93\u5b58\u5931\u8d25\uff01{}", (Object)"invCellOrder", (Object)map);
            ExceptionUtils.raise((String)"\u66f4\u65b0\u50a8\u4f4d\u5e93\u5b58\u5931\u8d25\uff01");
        }
        return tarInvcellqty.getCellid();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void dedInvCellOrder(DedInvcellqtyOrderVo dedInvQtyOrderVo) {
        InvCellQty invcellqty = this.getInvcellqty(dedInvQtyOrderVo.getEntid(), dedInvQtyOrderVo.getShopid(), dedInvQtyOrderVo.getCellno(), dedInvQtyOrderVo.getCellid());
        String gdcode = invcellqty.getGdcode();
        String lotid = invcellqty.getLotid();
        InvLotInfo invLotinfo = this.getInvLotinfo(dedInvQtyOrderVo.getEntid(), gdcode, lotid);
        if (invLotinfo == null) {
            ExceptionUtils.raise((String)MessageFormat.format("\u4f01\u4e1a[{0}]\u4e0b\u6ca1\u6709\u5546\u54c1\u5185\u7801\u4e3a[{1}]\u5546\u54c1\u5c5e\u6027ID\u4e3a[{2}]\u7684\u4fe1\u606f\uff01[dedInvCellOrder]", dedInvQtyOrderVo.getEntid(), gdcode, lotid));
        }
        invcellqty.setQty(invcellqty.getQty().subtract(dedInvQtyOrderVo.getQty()));
        invcellqty.setOutstockqty(invcellqty.getOutstockqty().subtract(dedInvQtyOrderVo.getQty()));
        int row = this.onUpdateBean(invcellqty, Sets.newHashSet((Object[])new String[]{"qty", "outstockqty"}));
        if (row == 1) {
            Integer tarCellid;
            boolean isManLpn = false;
            String lpnname = dedInvQtyOrderVo.getTargetCellno();
            if (isManLpn) {
                lpnname = dedInvQtyOrderVo.getLpnname();
            }
            if ((tarCellid = dedInvQtyOrderVo.getTargetCellId()) == -1) {
                tarCellid = this.getMaxCellid(dedInvQtyOrderVo.getEntid(), dedInvQtyOrderVo.getShopid(), dedInvQtyOrderVo.getTargetCellno());
                InvCellQty tarInvcellqty = this.getDedInvcellqtyEntity(dedInvQtyOrderVo, invLotinfo);
                tarInvcellqty.setCellid(tarCellid);
                tarInvcellqty.setLpnname(lpnname);
                this.getTemplate().insert((Object)tarInvcellqty);
            } else {
                invcellqty.setQty(invcellqty.getQty().add(dedInvQtyOrderVo.getQty()));
                invcellqty.setInstockqty(invcellqty.getInstockqty().subtract(dedInvQtyOrderVo.getQty()));
                invcellqty.setLpnname(lpnname);
                row = this.onUpdateBean(invcellqty, Sets.newHashSet((Object[])new String[]{"qty", "instockqty", "lpnname"}));
                if (row == 1) {
                    this.cleanInvCellqty(dedInvQtyOrderVo.getEntid(), dedInvQtyOrderVo.getShopid(), dedInvQtyOrderVo.getCellno());
                    this.cleanInvCellqty(dedInvQtyOrderVo.getEntid(), dedInvQtyOrderVo.getShopid(), dedInvQtyOrderVo.getTargetCellno());
                } else {
                    ExceptionUtils.raise((String)MessageFormat.format("--\u66f4\u65b0\u76ee\u7684\u50a8\u4f4d\u5e93\u5b58\u5931\u8d25\uff01{0}", invcellqty.getCellid()));
                }
            }
        } else {
            log.error("\u66f4\u65b0\u50a8\u4f4d\u5e93\u5b58\u5931\u8d25id={},[dedInvCellOrder]", (Object)invcellqty.getId());
            ExceptionUtils.raise((String)MessageFormat.format("\u66f4\u65b0\u50a8\u4f4d\u5e93\u5b58\u5931\u8d25\uff01id[{}]", invcellqty.getId()));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer invCellMove(InvcellqtyMoveVo invcellqtyMoveVo) {
        Integer tarCellid;
        InvCellQty invcellqty = this.getInvcellqty(invcellqtyMoveVo.getEntid(), invcellqtyMoveVo.getShopid(), invcellqtyMoveVo.getCellno(), invcellqtyMoveVo.getCellid());
        String gdcode = invcellqty.getGdcode();
        String lotid = invcellqty.getLotid();
        InvLotInfo invLotinfo = this.getInvLotinfo(invcellqtyMoveVo.getEntid(), gdcode, lotid);
        if (invLotinfo == null) {
            ExceptionUtils.raise((String)MessageFormat.format("\u4f01\u4e1a[{0}]\u4e0b\u6ca1\u6709\u5546\u54c1\u5185\u7801\u4e3a[{1}]\u5546\u54c1\u5c5e\u6027ID\u4e3a[{2}]\u7684\u4fe1\u606f\uff01", invcellqtyMoveVo.getEntid(), gdcode, lotid));
        }
        if (invcellqty.getQty().subtract(invcellqtyMoveVo.getQty()).compareTo(BigDecimal.ZERO) == -1) {
            log.error("\u50a8\u4f4d\u5e93\u5b58[{}]\uff0c\u4e0d\u8db3\u4ee5\u6263\u51cf[{}]\uff01", (Object)String.join((CharSequence)"entid=", invcellqtyMoveVo.getEntid(), "shopid=", invcellqtyMoveVo.getShopid(), "cellno=", invcellqtyMoveVo.getCellno(), "cellid=", String.valueOf(invcellqtyMoveVo.getCellid())), (Object)invcellqtyMoveVo.getQty());
            ExceptionUtils.raise((String)MessageFormat.format("\u50a8\u4f4d\u5e93\u5b58[{0}]\uff0c\u4e0d\u8db3\u4ee5\u6263\u51cf[{1}]\uff01", String.join((CharSequence)"entid=", invcellqtyMoveVo.getEntid(), "shopid=", invcellqtyMoveVo.getShopid(), "cellno=", invcellqtyMoveVo.getCellno(), "cellid=", String.valueOf(invcellqtyMoveVo.getCellid())), invcellqtyMoveVo.getQty()));
        }
        invcellqty.setQty(invcellqty.getQty().subtract(invcellqtyMoveVo.getQty()));
        int row = this.onUpdateBean(invcellqty, Sets.newHashSet((Object[])new String[]{"qty"}));
        if (row != 1) {
            ExceptionUtils.raise((String)"\u6263\u51cf\u5e93\u5b58\u5931\u8d25\uff01");
        }
        boolean isManLpn = false;
        String lpnname = invcellqtyMoveVo.getTargetCellno();
        if (isManLpn) {
            lpnname = invcellqtyMoveVo.getLpnname();
        }
        if ((tarCellid = invcellqtyMoveVo.getTargetCellId()) == -1) {
            tarCellid = this.getMaxCellid(invcellqtyMoveVo.getEntid(), invcellqtyMoveVo.getShopid(), invcellqtyMoveVo.getTargetCellno());
            InvCellQty tarInvcellqty = this.getMoveInvcellqtyEntity(invcellqtyMoveVo, invLotinfo);
            tarInvcellqty.setCellid(tarCellid);
            tarInvcellqty.setLpnname(lpnname);
            this.getTemplate().insert((Object)tarInvcellqty);
        } else {
            invcellqty.setQty(invcellqty.getQty().add(invcellqtyMoveVo.getQty()));
            invcellqty.setLpnname(lpnname);
            row = this.onUpdateBean(invcellqty, Sets.newHashSet((Object[])new String[]{"qty", "lpnname"}));
            if (row == 1) {
                this.cleanInvCellqty(invcellqtyMoveVo.getEntid(), invcellqtyMoveVo.getShopid(), invcellqtyMoveVo.getCellno());
                this.cleanInvCellqty(invcellqtyMoveVo.getEntid(), invcellqtyMoveVo.getShopid(), invcellqtyMoveVo.getTargetCellno());
            } else {
                ExceptionUtils.raise((String)MessageFormat.format("--\u66f4\u65b0\u76ee\u7684\u50a8\u4f4d\u5e93\u5b58\u5931\u8d25\uff01{0}", invcellqty.getCellid()));
            }
        }
        return tarCellid;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void dedInvCell(DedInvcellqtyVo dedInvcellqtyVo) {
        List<InvCellQty> invcellqtyList = this.getInvcellqtys(dedInvcellqtyVo.getEntid(), dedInvcellqtyVo.getShopid(), dedInvcellqtyVo.getOwnerid(), dedInvcellqtyVo.getCellno(), dedInvcellqtyVo.getGdcode(), dedInvcellqtyVo.getLotid());
        if (invcellqtyList.isEmpty()) {
            log.error("\u6ca1\u6709\u6ee1\u8db3\u6761\u4ef6\u7684\u4ee3\u6263\u5e93\u5b58\u8bb0\u5f55![{}]", (Object)JSON.toJSONString((Object)dedInvcellqtyVo));
            ExceptionUtils.raise((String)"\u6ca1\u6709\u6ee1\u8db3\u6761\u4ef6\u7684\u4ee3\u6263\u5e93\u5b58\u8bb0\u5f55\uff01");
        }
        BigDecimal qty = dedInvcellqtyVo.getQty();
        invcellqtyList.forEach(c -> {
            if (qty.compareTo(BigDecimal.ZERO) == 1) {
                if (qty.subtract(c.getQty()).compareTo(BigDecimal.ZERO) != -1) {
                    c.setQty(BigDecimal.ZERO);
                } else {
                    c.setQty(c.getQty().subtract(qty));
                }
                this.onUpdateBean(c, Sets.newHashSet((Object[])new String[]{"qty"}));
            }
        });
        if (qty.compareTo(BigDecimal.ZERO) == 1) {
            log.error("\u5e93\u5b58\u4e0d\u8db3\u4ee5\u6263\u51cf\uff01[{}]", (Object)JSON.toJSONString((Object)dedInvcellqtyVo));
            ExceptionUtils.raise((String)"\u5e93\u5b58\u4e0d\u8db3\u4ee5\u6263\u51cf\uff01");
        }
        this.cleanInvCellqty(dedInvcellqtyVo.getEntid(), dedInvcellqtyVo.getShopid(), dedInvcellqtyVo.getCellno());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void realTimeInvMove(RealTimeInvVo realTimeInvVo) {
        Update update;
        HashMap map;
        InvCellQty invcellqty;
        InvCellQty tarInvcellqty;
        Integer cellid;
        String gdcode = realTimeInvVo.getGdcode();
        String lotid = realTimeInvVo.getLotid();
        InvLotInfo invLotinfo = this.getInvLotinfo(realTimeInvVo.getEntid(), gdcode, lotid);
        if (invLotinfo == null) {
            ExceptionUtils.raise((String)MessageFormat.format("\u4f01\u4e1a[{0}]\u4e0b\u6ca1\u6709\u5546\u54c1\u5185\u7801\u4e3a[{1}]\u5546\u54c1\u5c5e\u6027ID\u4e3a[{2}]\u7684\u4fe1\u606f\uff01", realTimeInvVo.getEntid(), gdcode, lotid));
        }
        boolean isManLpn = false;
        String lpnname = realTimeInvVo.getCellno();
        if (isManLpn) {
            lpnname = realTimeInvVo.getLpnname();
        }
        int row = 0;
        if (realTimeInvVo.getCellid() == -1) {
            cellid = this.getMaxCellid(realTimeInvVo.getEntid(), realTimeInvVo.getShopid(), realTimeInvVo.getCellno());
            tarInvcellqty = this.getRealTimeInvcellqtyEntity(realTimeInvVo, invLotinfo);
            tarInvcellqty.setCellid(cellid);
            tarInvcellqty.setLpnname(lpnname);
            this.getTemplate().insert((Object)tarInvcellqty);
        } else {
            invcellqty = this.getInvcellqty(realTimeInvVo.getEntid(), realTimeInvVo.getShopid(), realTimeInvVo.getCellno(), realTimeInvVo.getCellid());
            map = Maps.newHashMap();
            map.put("entid", realTimeInvVo.getEntid());
            map.put("shopid", realTimeInvVo.getShopid());
            map.put("cellno", realTimeInvVo.getCellno());
            map.put("cellid", realTimeInvVo.getCellid());
            update = Update.update((String)"qty", (Object)invcellqty.getQty().subtract(realTimeInvVo.getQty())).set("lpnname", (Object)lpnname);
            row = this.getTemplate().update(QueryUtils.build((Map)map), update, InvCellQty.class);
            if (row != 1) {
                log.error("[{}]\u50a8\u4f4d\u5e93\u5b58\u66f4\u65b0\u5931\u8d25\uff01[{}]", (Object)"realTimeInvMove", (Object)map);
                ExceptionUtils.raise((String)"\u50a8\u4f4d\u5e93\u5b58\u66f4\u65b0\u5931\u8d25\uff01");
            }
        }
        lpnname = realTimeInvVo.getTargetCellno();
        if (isManLpn) {
            lpnname = realTimeInvVo.getLpnname();
        }
        if (realTimeInvVo.getTargetCellId() == -1) {
            cellid = this.getMaxCellid(realTimeInvVo.getEntid(), realTimeInvVo.getShopid(), realTimeInvVo.getTargetCellno());
            tarInvcellqty = this.getRealTimeInvcellqtyEntity(realTimeInvVo, invLotinfo);
            tarInvcellqty.setCellid(cellid);
            tarInvcellqty.setLpnname(lpnname);
            this.getTemplate().insert((Object)tarInvcellqty);
        } else {
            invcellqty = this.getInvcellqty(realTimeInvVo.getEntid(), realTimeInvVo.getShopid(), realTimeInvVo.getTargetCellno(), realTimeInvVo.getTargetCellId());
            map = Maps.newHashMap();
            map.put("entid", realTimeInvVo.getEntid());
            map.put("shopid", realTimeInvVo.getShopid());
            map.put("cellno", realTimeInvVo.getTargetCellno());
            map.put("cellid", realTimeInvVo.getTargetCellId());
            update = Update.update((String)"qty", (Object)invcellqty.getQty().add(realTimeInvVo.getQty())).set("lpnname", (Object)lpnname);
            row = this.getTemplate().update(QueryUtils.build((Map)map), update, InvCellQty.class);
            if (row != 1) {
                log.error("\u50a8\u4f4d\u5e93\u5b58\u66f4\u65b0\u5931\u8d25\uff01[{}]", (Object)map);
                ExceptionUtils.raise((String)"\u50a8\u4f4d\u5e93\u5b58\u66f4\u65b0\u5931\u8d25\uff01");
            }
        }
        this.cleanInvCellqty(realTimeInvVo.getEntid(), realTimeInvVo.getShopid(), realTimeInvVo.getCellno());
        this.cleanInvCellqty(realTimeInvVo.getEntid(), realTimeInvVo.getShopid(), realTimeInvVo.getTargetCellno());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void invCellMoveLog(InvcellMoveLogVo invcellMoveVo) {
        String gdcode = invcellMoveVo.getGdcode();
        String lotid = invcellMoveVo.getLotid();
        InvLotInfo invLotinfo = this.getInvLotinfo(invcellMoveVo.getEntid(), gdcode, lotid);
        InvCellQty sInvcellqty = this.getInvcellqty(invcellMoveVo.getEntid(), invcellMoveVo.getShopid(), invcellMoveVo.getScellno(), invcellMoveVo.getScellid());
        InvCellQty tInvcellqty = this.getInvcellqty(invcellMoveVo.getEntid(), invcellMoveVo.getShopid(), invcellMoveVo.getDcellno(), invcellMoveVo.getDcellid());
        HashMap map = Maps.newHashMap();
        map.put("entid", invcellMoveVo.getEntid());
        map.put("shopid", invcellMoveVo.getShopid());
        map.put("ownerid", invcellMoveVo.getOwnerid());
        map.put("papertype", invcellMoveVo.getPapertype());
        map.put("paperno", invcellMoveVo.getPaperno());
        map.put("gdcode", invcellMoveVo.getGdcode());
        map.put("lotid", invcellMoveVo.getLotid());
        map.put("scellno", invcellMoveVo.getScellno());
        map.put("scellid", invcellMoveVo.getScellid());
        map.put("dcellno", invcellMoveVo.getDcellno());
        map.put("dcellid", invcellMoveVo.getDcellid());
        map.put("deptid", invcellMoveVo.getDeptid());
        InvCellMove invcellmove = (InvCellMove)this.getTemplate().selectOne(QueryUtils.build((Map)map), InvCellMove.class);
        if (invcellmove == null) {
            invcellmove = new InvCellMove();
            BeanUtils.copyProperties((Object)invcellMoveVo, (Object)invcellmove);
            BeanUtils.copyProperties((Object)invLotinfo, (Object)invcellmove);
            invcellmove.setMoveqty(invcellMoveVo.getQty());
            invcellmove.setScontainerno("N");
            invcellmove.setSfirstqty(sInvcellqty.getQty());
            invcellmove.setSfirstinstockqty(sInvcellqty.getInstockqty());
            invcellmove.setSfirstoutstockqty(sInvcellqty.getOutstockqty());
            invcellmove.setDcontainerno("N");
            invcellmove.setDfirstqty(tInvcellqty.getQty());
            invcellmove.setDfirstinstockqty(tInvcellqty.getInstockqty());
            invcellmove.setDfirstoutstockqty(tInvcellqty.getOutstockqty());
            this.cellmoveService.onInsert(ServiceSession.getSession(), (JSONObject)JSONObject.toJSON((Object)invcellmove));
        } else {
            Update update = Update.update((String)"sfirstqty", (Object)invcellmove.getSfirstqty().add(sInvcellqty.getQty())).set("sfirstinstockqty", (Object)invcellmove.getSfirstinstockqty().add(sInvcellqty.getInstockqty())).set("sfirstoutstockqty", (Object)invcellmove.getSfirstoutstockqty().add(sInvcellqty.getOutstockqty())).set("dfirstqty", (Object)invcellmove.getDfirstqty().add(tInvcellqty.getQty())).set("dfirstinstockqty", (Object)invcellmove.getDfirstinstockqty().add(tInvcellqty.getInstockqty())).set("dfirstoutstockqty", (Object)invcellmove.getDfirstoutstockqty().add(tInvcellqty.getOutstockqty())).set("moveqty", (Object)invcellmove.getMoveqty().add(invcellMoveVo.getQty()));
            Criteria criteria = Criteria.where((String)"id").is((Object)invcellmove.getId());
            int row = this.getTemplate().update(QueryUtils.build((Criteria)criteria), update, InvCellMove.class);
            if (row != 1) {
                log.error("\u50a8\u4f4d\u5f02\u52a8\u65e5\u5fd7\u66f4\u65b0\u5931\u8d25![id={}]", (Object)invcellmove.getId());
                ExceptionUtils.raise((String)"\u50a8\u4f4d\u5f02\u52a8\u65e5\u5fd7\u66f4\u65b0\u5931\u8d25\uff01");
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void invCellFreeze(InvCellFreezeVo invCellFreezeVo) {
        HashMap map = Maps.newHashMap();
        map.put("entid", invCellFreezeVo.getEntid());
        map.put("shopid", invCellFreezeVo.getShopid());
        map.put("ownerid", invCellFreezeVo.getOwnerid());
        map.put("sheetid", invCellFreezeVo.getSheetid());
        if (invCellFreezeVo.getFlag() == 0) {
            Update update = Update.update((String)"flag", (Object)SheetFlagEnum.CANCEL.getFlag());
            int row = this.getTemplate().update(QueryUtils.build((Map)map), update, InvLock.class);
            if (row != 1) {
                log.error("\u4f5c\u5e9f\u64cd\u4f5c\u5f02\u5e38:{}", (Object)map);
                ExceptionUtils.raise((String)"\u4f5c\u5e9f\u5f02\u5e38\uff01");
            }
        } else if (invCellFreezeVo.getFlag() == 1) {
            InvLock invlock = (InvLock)this.getTemplate().selectOne(QueryUtils.build((Map)map), InvLock.class);
            if (invlock == null) {
                ExceptionUtils.raise((String)MessageFormat.format("\u65e0\u4f01\u4e1a[{0}]\u5355\u636e[{1}]\u7684\u5e93\u5b58\u9501\u5b9a\u8bb0\u5f55\uff01", invCellFreezeVo.getEntid(), invCellFreezeVo.getSheetid()));
            }
            if (invlock.getFlag().equals(SheetFlagEnum.CANCEL.getFlag()) || invlock.getFlag().equals(SheetFlagEnum.AUDIT.getFlag())) {
                ExceptionUtils.raise((String)"\u5e93\u5b58\u9501\u5b9a\u8bb0\u5f55\u5df2\u4f5c\u5e9f\u6216\u5df2\u6838\u5ba1\uff01");
            }
            Integer lockflag = invlock.getLockflag();
            List invlocks = this.getTemplate().select(QueryUtils.build((Map)map), InvLocksItem.class);
            if (lockflag == 0) {
                if (!invlocks.isEmpty()) {
                    invlocks.forEach(l -> this.updateInvCell(invlock, (InvLocksItem)l));
                }
            } else if (lockflag == 1 && !invlocks.isEmpty()) {
                invlocks.forEach(l -> this.updateInvCell(invlock, (InvLocksItem)l));
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("flag", (Object)SheetFlagEnum.AUDIT.getFlag());
            jsonObject.put("operator", (Object)invCellFreezeVo.getOperator());
            jsonObject.put("date", (Object)new Date());
            this.invLockService.onUpdate(ServiceSession.getSession(), jsonObject);
        } else {
            ExceptionUtils.raise((String)MessageFormat.format("\u5904\u7406\u6807\u8bb0\u5f02\u5e38[{0}]\uff01\u4e3a\u975e0/1", invCellFreezeVo.getFlag()));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void invLotProAdj(InvLotProVo invLotProVo) {
        HashMap param = Maps.newHashMap();
        param.put("entid", invLotProVo.getEntid());
        param.put("sheetid", invLotProVo.getSheetid());
        if (invLotProVo.getFlag() == 0) {
            Update update = Update.update((String)"flag", (Object)SheetFlagEnum.CANCEL.getFlag()).set("checker", (Object)invLotProVo.getOperator()).set("checkdate", (Object)new Date());
            int row = this.getTemplate().update(QueryUtils.build((Map)param), update, InvLot.class);
            if (row != 1) {
                ExceptionUtils.raise((String)"\u66f4\u65b0\u6279\u6b21\u5c5e\u6027\u8c03\u6574\u5355\u636e\u5f02\u5e38\uff01");
            }
        } else if (invLotProVo.getFlag() == 1) {
            List invlotitemList;
            InvLot invlot = (InvLot)this.getTemplate().selectOne(QueryUtils.build((Map)param), InvLot.class);
            if (Objects.isNull(invlot)) {
                log.info("\u65e0\u6279\u6b21\u5c5e\u6027\u8c03\u6574\u5355\u636e\u8bb0\u5f55\uff01\u6761\u4ef6[{}]", (Object)param);
                return;
            }
            if (invlot.getFlag().equals(SheetFlagEnum.CANCEL.getFlag()) || invlot.getFlag().equals(SheetFlagEnum.AUDIT.getFlag())) {
                ExceptionUtils.raise((String)MessageFormat.format("\u6279\u6b21\u5c5e\u6027\u8c03\u6574\u5355\u636e[{0}]\u5df2\u4f5c\u5e9f\u6216\u88ab\u5ba1\u6838\uff01", invlot.getSheetid()));
            }
            if (!(invlotitemList = this.getTemplate().select(QueryUtils.build((Map)param), InvLockItem.class)).isEmpty()) {
                invlotitemList.forEach(l -> {
                    Omoutstocksitem stocksitem;
                    BigDecimal packQty = l.getPackingqty();
                    String entid = l.getEntid();
                    String gdcode = l.getGdcode();
                    String lotid = l.getLotid();
                    HashMap map = Maps.newHashMap();
                    map.put("entid", entid);
                    map.put("gdcode", gdcode);
                    map.put("lotid", lotid);
                    InvCellQty invcellqty = (InvCellQty)this.getTemplate().selectOne(QueryUtils.build((Map)map), InvCellQty.class);
                    if (invcellqty != null && packQty.compareTo(invcellqty.getPackingqty()) != 0) {
                        invcellqty.setPackingqty(packQty);
                        this.onUpdateBean(invcellqty, Sets.newHashSet((Object[])new String[]{"packingqty"}));
                    }
                    if ((stocksitem = (Omoutstocksitem)this.getTemplate().selectOne(QueryUtils.build((Map)map), Omoutstocksitem.class)) != null && packQty.compareTo(stocksitem.getPackingqty()) != 0) {
                        Update update = Update.update((String)"packingqty", (Object)packQty);
                        this.getTemplate().update(QueryUtils.build((Map)map), update, Omoutstocksitem.class);
                    }
                });
            }
            Update update = Update.update((String)"flag", (Object)SheetFlagEnum.AUDIT.getFlag()).set("checker", (Object)invLotProVo.getOperator()).set("checkdate", (Object)new Date());
            this.getTemplate().update(QueryUtils.build((Map)param), update, InvLot.class);
        } else {
            ExceptionUtils.raise((String)"\u5904\u7406\u6807\u8bb0\u5f02\u5e38\uff01\u975e[0/1]");
        }
    }

    @Override
    public List<InvCellQty> selectCellQty(Map param) {
        return this.dataQuery(QueryUtils.build((Map)param));
    }

    private void updateInvCell(InvLock invlock, InvLocksItem locksItem) {
        Integer lockflag = invlock.getLockflag();
        HashMap map = Maps.newHashMap();
        map.put("entid", invlock.getEntid());
        map.put("ownerid", invlock.getOwnerid());
        map.put("cellno", locksItem.getCellno());
        map.put("deptid", invlock.getDeptid());
        map.put("gdcode", locksItem.getGdcode());
        map.put("checkstatus", 0);
        InvCellQty invcellqty = (InvCellQty)this.getTemplate().selectOne(QueryUtils.build((Map)map), InvCellQty.class);
        if (invcellqty != null) {
            if (lockflag == 0 && invcellqty.getQty().subtract(locksItem.getQty()).compareTo(BigDecimal.ZERO) == -1) {
                ExceptionUtils.raise((String)MessageFormat.format("ownerid[{0}],cellno[{1}],deptid[{2}],gdcode[{3}]\u50a8\u4f4d\u5e93\u5b58\u6570[{4}]\u5c0f\u4e8e\u9501\u5b9a\u6570[{5}]\uff01", invlock.getOwnerid(), locksItem.getCellno(), invlock.getDeptid(), locksItem.getGdcode(), invcellqty.getQty(), locksItem.getQty()));
            }
            if (lockflag == 1 && invcellqty.getFreezeqty().subtract(locksItem.getQty()).compareTo(BigDecimal.ZERO) == -1) {
                ExceptionUtils.raise((String)MessageFormat.format("ownerid[{0}],cellno[{1}],deptid[{2}],gdcode[{3}]\u50a8\u4f4d\u5e93\u5b58\u51bb\u7ed3\u6570[{4}]\u5c0f\u4e8e\u89e3\u51bb\u6570[{5}]\uff01", invlock.getOwnerid(), locksItem.getCellno(), invlock.getDeptid(), locksItem.getGdcode(), invcellqty.getFreezeqty(), locksItem.getQty()));
            }
            Criteria criteria = Criteria.where((String)"id").is((Object)invcellqty.getId());
            Update update = Update.update((String)"qty", (Object)invcellqty.getQty().subtract(locksItem.getQty()));
            this.getTemplate().update(QueryUtils.build((Criteria)criteria), update, InvCellQty.class);
        }
    }

    private List<InvCellQty> getInvcellqtys(String entid, String shopid, String ownerid, String cellno, String gdcode, String lotid) {
        HashMap map = Maps.newHashMap();
        map.put("entid", entid);
        map.put("shopid", shopid);
        map.put("ownerid", ownerid);
        map.put("cellno", cellno);
        map.put("gdcode", gdcode);
        map.put("lotid", lotid);
        List invcellqtyList = this.getTemplate().select(QueryUtils.build((Map)map), InvCellQty.class);
        return invcellqtyList;
    }

    private InvCellQty getInvcellqty(String entid, String shopid, String cellno, Integer cellid) {
        JSONObject paramsObject = new JSONObject();
        paramsObject.put("entid", (Object)entid);
        paramsObject.put("shopid", (Object)shopid);
        paramsObject.put("cellno", (Object)cellno);
        paramsObject.put("cellid", (Object)cellid);
        InvCellQty invcellqty = (InvCellQty)this.dataQueryFirst(ServiceSession.getSession(), paramsObject, InvCellQty.class);
        if (invcellqty == null) {
            ExceptionUtils.raise((String)MessageFormat.format("\u4f01\u4e1a[{0}]\u4ed3\u522b[{1}]\u50a8\u4f4d\u4ee3\u7801[{2}]\u50a8\u4f4dID[{3}]\u7684\u50a8\u4f4d\u5e93\u5b58\u4e0d\u5b58\u5728\uff01", entid, shopid, cellno, cellid));
        }
        return invcellqty;
    }

    private void cleanInvCellqty(String entid, String shopid, String cellno) {
        HashMap cleanParam = Maps.newHashMap();
        cleanParam.put("entid", entid);
        cleanParam.put("shopid", shopid);
        cleanParam.put("cellno", cellno);
        cleanParam.put("qty", BigDecimal.ZERO);
        cleanParam.put("instockqty", BigDecimal.ZERO);
        cleanParam.put("outstockqty", BigDecimal.ZERO);
        cleanParam.put("freezeqty", BigDecimal.ZERO);
        int del = this.getTemplate().delete(QueryUtils.build((Map)cleanParam), InvCellQty.class);
        log.info("\u5220\u9664[{}]\u6761\u50a8\u4f4d\u5b58\u50a8\u8bb0\u5f55\uff01\u6761\u4ef6\uff1a{}", (Object)del, (Object)cleanParam);
    }

    private InvCellQty getRealTimeInvcellqtyEntity(RealTimeInvVo realTimeInvVo, InvLotInfo invLotinfo) {
        InvCellQty invcellqty = new InvCellQty();
        BeanUtils.copyProperties((Object)realTimeInvVo, (Object)invcellqty, (String[])new String[]{"operator"});
        this.setInvcellqtyLotInfo(invcellqty, invLotinfo);
        IsceModelUtil.setModeCreator((Object)invcellqty, (String)realTimeInvVo.getOperator());
        IsceModelUtil.setModeCreatetime((Object)invcellqty, (Date)new Date());
        return invcellqty;
    }

    private InvCellQty getMoveInvcellqtyEntity(InvcellqtyMoveVo invcellqtyVo, InvLotInfo invLotinfo) {
        InvCellQty invcellqty = new InvCellQty();
        BeanUtils.copyProperties((Object)invcellqtyVo, (Object)invcellqty, (String[])new String[]{"operator"});
        this.setInvcellqtyLotInfo(invcellqty, invLotinfo);
        IsceModelUtil.setModeCreator((Object)invcellqty, (String)invcellqtyVo.getOperator());
        IsceModelUtil.setModeCreatetime((Object)invcellqty, (Date)new Date());
        return invcellqty;
    }

    private InvCellQty getDedInvcellqtyEntity(DedInvcellqtyOrderVo invcellqtyVo, InvLotInfo invLotinfo) {
        InvCellQty invcellqty = new InvCellQty();
        BeanUtils.copyProperties((Object)invcellqtyVo, (Object)invcellqty, (String[])new String[]{"operator"});
        this.setInvcellqtyLotInfo(invcellqty, invLotinfo);
        IsceModelUtil.setModeCreator((Object)invcellqty, (String)invcellqtyVo.getOperator());
        IsceModelUtil.setModeCreatetime((Object)invcellqty, (Date)new Date());
        return invcellqty;
    }

    private InvCellQty getAddInvcellqtyEntity(InvcellqtyVo invcellqtyVo, InvLotInfo invLotinfo) {
        InvCellQty invcellqty = new InvCellQty();
        BeanUtils.copyProperties((Object)invcellqtyVo, (Object)invcellqty, (String[])new String[]{"operator"});
        this.setInvcellqtyLotInfo(invcellqty, invLotinfo);
        IsceModelUtil.setModeCreator((Object)invcellqty, (String)invcellqtyVo.getOperator());
        IsceModelUtil.setModeCreatetime((Object)invcellqty, (Date)new Date());
        return invcellqty;
    }

    private void setInvcellqtyLotInfo(InvCellQty invcellqty, InvLotInfo invLotinfo) {
        invcellqty.setGdname(invLotinfo.getGdname());
        invcellqty.setPackingqty(invLotinfo.getPackingqty());
        invcellqty.setBarcode(invLotinfo.getBarcode());
        invcellqty.setVenderid(invLotinfo.getVenderid());
        invcellqty.setVendername(invLotinfo.getVendername());
        invcellqty.setGroupno(invLotinfo.getGroupno());
        invcellqty.setGroupname(invLotinfo.getGroupname());
        invcellqty.setGdname(invLotinfo.getGdname());
        invcellqty.setBrandid(invLotinfo.getBrandid());
        invcellqty.setBrandname(invLotinfo.getBrandname());
    }

    private InvLotInfo getInvLotinfo(String entid, String gdcode, String lotid) {
        Criteria criteria = Criteria.where((String)"entid").is((Object)entid).and("gdcode").is((Object)gdcode).and("lotid").is((Object)lotid);
        InvLotInfo invLotinfo = (InvLotInfo)this.getTemplate().selectOne(QueryUtils.build((Criteria)criteria), InvLotInfo.class);
        return invLotinfo;
    }

    protected Document onBeforeRowInsert(Query query, Update update) {
        return this.onDefaultRowInsert(query, update);
    }
}

