/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.isce.wmsinv.service.impl.invlpn.create;

import com.alibaba.fastjson.JSONObject;
import com.efuture.common.enums.LpnEnum;
import com.efuture.common.utils.GenRuleCodeUtils;
import com.efuture.isce.wms.inv.inv.InvLpn;
import com.efuture.isce.wmsinv.service.invlpn.InvLpnService;
import com.efuture.isce.wmsinv.service.invlpn.create.InvLpnCreateService;
import com.google.common.collect.Lists;
import com.product.model.ServiceResponse;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PutwayLpnServiceImpl
implements InvLpnCreateService {
    private static final Logger log = LoggerFactory.getLogger(PutwayLpnServiceImpl.class);
    @Autowired
    private InvLpnService invLpnService;

    @Override
    public ServiceResponse create(JSONObject paramsObject) {
        String entid = paramsObject.getString("entid");
        String shopid = paramsObject.getString("shopid");
        String lpnname = paramsObject.getString("lpnname");
        String venderid = paramsObject.getString("venderid");
        String checksumno = paramsObject.getString("checksumno");
        int refsheettype = paramsObject.getIntValue("refsheettype");
        String deptid = paramsObject.getString("deptid");
        String gdcode = paramsObject.getString("gdcode");
        String operator = paramsObject.getString("operator");
        Criteria criteria = Criteria.where((String)"entid").is((Object)entid).and("shopid").is((Object)shopid).and("lpnname").is((Object)lpnname).and("flag").in(new Object[]{13, 23, 43, 93, 73, 53, 41, 83});
        Query query = new Query((CriteriaDefinition)criteria);
        List list = this.invLpnService.dataQuery(query);
        String lpnid = "";
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (InvLpn lpn : list) {
                ServiceResponse response = this.verify(lpn);
                if (!"0".equals(response.getReturncode())) continue;
                lpnid = lpn.getLpnid();
                log.info("-----Putaway[\u4e0a\u67b6]---lpnid[{}]\u9a8c\u8bc1\u6210\u529f\uff01{}", (Object)lpnid, (Object)paramsObject.toJSONString());
            }
        } else {
            lpnid = GenRuleCodeUtils.getGenCode((String)"lpnid", (String)LpnEnum.LPN_TYPE.getLpnType());
            InvLpn invLpn = new InvLpn();
            invLpn.setFlag(Integer.valueOf(10));
            invLpn.setOwnerlpnid(lpnid);
            invLpn.setOwnerlpnname(lpnname);
            invLpn.setExpno(checksumno);
            invLpn.setUsetype(Integer.valueOf(1));
            invLpn.setRefsheetid(checksumno);
            invLpn.setRefsheettype(Integer.valueOf(refsheettype));
            invLpn.setDeptid(deptid);
            this.invLpnService.onInsert(invLpn);
        }
        return ServiceResponse.buildSuccess((Object)lpnid);
    }

    @Override
    public ServiceResponse verify(InvLpn invLpn) {
        ServiceResponse response = ServiceResponse.buildSuccess(null);
        if (Objects.nonNull(invLpn)) {
            int status = invLpn.getFlag();
            if (status == 11) {
                response = ServiceResponse.buildFailure(null, (String)"1", (String)"\u677f\u53f7\u4e0a\u67b6\u4e2d!");
            } else if (Lists.newArrayList((Object[])new Integer[]{20, 21}).contains(status)) {
                response = ServiceResponse.buildFailure(null, (String)"1", (String)"\u677f\u53f7\u5728\u79fb\u5e93\u73af\u8282\u4e2d\u4e14\u79fb\u5e93\u672a\u5b8c\u6210!");
            } else if (Lists.newArrayList((Object[])new Integer[]{41, 42}).contains(status)) {
                response = ServiceResponse.buildFailure(null, (String)"1", (String)"\u677f\u53f7\u5728\u5206\u64ad\u73af\u8282\u4e2d\u4e14\u5206\u64ad\u672a\u5b8c\u6210!");
            } else if (Lists.newArrayList((Object[])new Integer[]{50, 51}).contains(status)) {
                response = ServiceResponse.buildFailure(null, (String)"1", (String)"\u677f\u53f7\u5728\u4ee3\u8fd0\u73af\u8282\u4e2d!");
            } else if (Lists.newArrayList((Object[])new Integer[]{30, 31}).contains(status)) {
                response = ServiceResponse.buildFailure(null, (String)"1", (String)"\u677f\u53f7\u5728\u914d\u9001\u73af\u8282\u4e2d!");
            } else if (Lists.newArrayList((Object[])new Integer[]{70, 71}).contains(status)) {
                response = ServiceResponse.buildFailure(null, (String)"1", (String)"\u677f\u53f7\u5728\u8fd4\u914d\u73af\u8282\u4e2d!");
            } else if (Lists.newArrayList((Object[])new Integer[]{80, 81}).contains(status)) {
                response = ServiceResponse.buildFailure(null, (String)"1", (String)"\u677f\u53f7\u5728\u9000\u5382\u73af\u8282\u4e2d!");
            } else if (status == 90) {
                response = ServiceResponse.buildFailure(null, (String)"1", (String)"\u677f\u53f7\u5df2\u5c01\u7b3c!");
            } else if (status == 91) {
                response = ServiceResponse.buildFailure(null, (String)"1", (String)"\u677f\u53f7\u5df2\u88c5\u8f66!");
            }
        }
        return response;
    }
}

