/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.isce.wmsinv.service.impl.invlotinfo;

import com.efuture.common.utils.ExceptionUtils;
import com.efuture.common.utils.GenRuleCodeUtils;
import com.efuture.common.utils.QueryUtils;
import com.efuture.isce.mdm.exposedapi.BmGoodsDubboService;
import com.efuture.isce.mdm.exposedapi.BmVenderDubboService;
import com.efuture.isce.mdm.goods.BmGoodsOwner;
import com.efuture.isce.mdm.vender.BmVender;
import com.efuture.isce.wms.inv.model.entity.InvLotInfo;
import com.efuture.isce.wmsinv.service.invlotinfo.InvLotInfoService;
import com.product.config.dynamicds.DynamicJDBCCompomentServiceImpl;
import com.product.model.ServiceResponse;
import com.product.storage.template.FMybatisTemplate;
import com.shiji.core.exception.BaseException;
import java.util.Optional;
import org.apache.dubbo.config.annotation.DubboReference;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

@Service
@CacheConfig(cacheNames={"invlotinfo"})
public class InvLotInfoServiceImpl
extends DynamicJDBCCompomentServiceImpl<InvLotInfo>
implements InvLotInfoService {
    private static final Logger log = LoggerFactory.getLogger(InvLotInfoServiceImpl.class);
    @DubboReference
    private BmGoodsDubboService goodsDubboService;
    @DubboReference
    private BmVenderDubboService venderDubboService;

    public InvLotInfoServiceImpl(FMybatisTemplate mybatisTemplate) {
        super(mybatisTemplate, "invlotinfo", "id");
    }

    protected Document onBeforeRowInsert(Query query, Update update) {
        return this.onDefaultRowInsert(query, update);
    }

    @Override
    @CachePut(key="#lotInfo.entid +'-'+ #lotInfo.ownerid +'-'+ #lotInfo.gdid +'-'+ #lotInfo.lotid")
    public InvLotInfo createLot(InvLotInfo lotInfo) {
        BmGoodsOwner goodsOwner = this.goodsDubboService.getGoodsOwnerByGdid(lotInfo.getEntid(), lotInfo.getOwnerid(), lotInfo.getGdid());
        Optional.ofNullable(goodsOwner).orElseThrow(() -> new BaseException("\u67e5\u8be2\u5546\u54c1\u8d27\u4e3b\u4fe1\u606f\u4e3a\u7a7a!"));
        BmVender bmvender = this.venderDubboService.getBmVender(lotInfo.getEntid(), lotInfo.getOwnerid(), lotInfo.getVenderid());
        String lotid = GenRuleCodeUtils.getGenCode((String)"sheetid", (String)"LOT");
        lotInfo.setOwnername(goodsOwner.getOwnername());
        lotInfo.setGdcode(goodsOwner.getGdcode());
        lotInfo.setGdname(goodsOwner.getGdname());
        lotInfo.setSkuspec(goodsOwner.getSkuspec());
        lotInfo.setSkuunit(goodsOwner.getSkuunit());
        lotInfo.setBrandid(goodsOwner.getBrandid());
        lotInfo.setBrandname(goodsOwner.getBrandname());
        lotInfo.setPackingspec(goodsOwner.getPackingspec());
        lotInfo.setVendername(null == bmvender ? "N" : bmvender.getVendername());
        lotInfo.setLotid(lotid);
        lotInfo.setDbsplitcode(goodsOwner.getDbsplitcode());
        ServiceResponse serviceResponse = super.onInsert((Object)lotInfo);
        if (!serviceResponse.getReturncode().equals("0")) {
            ExceptionUtils.raise((String)"\u751f\u6210\u6279\u6b21\u5c5e\u6027\u6570\u636e\u5931\u8d25!");
        }
        return lotInfo;
    }

    @Override
    @Cacheable(key="#entid +'-'+ #ownerid +'-'+ #gdid +'-'+ #lotid", unless="#result == null")
    public InvLotInfo getInvLotInfo(String entid, String ownerid, String gdid, String lotid) {
        return (InvLotInfo)this.dataQueryFirst(QueryUtils.build((Criteria)Criteria.where((String)"entid").is((Object)entid).and("ownerid").is((Object)ownerid).and("gdid").is((Object)gdid).and("lotid").is((Object)lotid)));
    }

    @Override
    @Cacheable(key="#entid +'-'+ #gdid +'-'+ #lotid", unless="#result == null")
    public InvLotInfo getInvLotInfo(String entid, String gdid, String lotid) {
        return (InvLotInfo)this.dataQueryFirst(QueryUtils.build((Criteria)Criteria.where((String)"entid").is((Object)entid).and("gdid").is((Object)gdid).and("lotid").is((Object)lotid)));
    }
}

