/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.isce.wmsinv.service.impl.invlpn.create;

import com.alibaba.fastjson.JSONObject;
import com.efuture.common.annotation.Key;
import com.efuture.common.annotation.RedisLock;
import com.efuture.common.enums.LpnEnum;
import com.efuture.common.utils.ExceptionUtils;
import com.efuture.common.utils.GenRuleCodeUtils;
import com.efuture.isce.mdm.code.BsContainer;
import com.efuture.isce.mdm.exposedapi.BmGoodsDubboService;
import com.efuture.isce.mdm.goods.BmGoodsOwner;
import com.efuture.isce.wms.im.ImCheckSum;
import com.efuture.isce.wms.inv.inv.InvLpn;
import com.efuture.isce.wms.inv.inv.InvLpnItem;
import com.efuture.isce.wms.inv.vo.DaiYunLpnCreateVo;
import com.efuture.isce.wmsinv.service.invlog.InvLpnMoveLogService;
import com.efuture.isce.wmsinv.service.invlpn.InvLpnItemService;
import com.efuture.isce.wmsinv.service.invlpn.InvLpnService;
import com.efuture.isce.wmsinv.service.invlpn.create.InvLpnCreateService;
import com.google.common.collect.Lists;
import com.product.model.ServiceResponse;
import com.product.storage.template.FMybatisTemplate;
import com.product.util.SpringContext;
import com.shiji.core.util.I18nUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DaiYunLpnServiceImpl
implements InvLpnCreateService<DaiYunLpnCreateVo> {
    private static final Logger log = LoggerFactory.getLogger(DaiYunLpnServiceImpl.class);
    @Autowired
    private InvLpnService invLpnService;
    @Autowired
    private InvLpnItemService invLpnItemService;
    @Resource
    @Qualifier(value="moreStorageOperation")
    private FMybatisTemplate template;
    @Autowired
    private InvLpnMoveLogService invLpnMoveLogService;
    @DubboReference
    private BmGoodsDubboService bmGoodsDubboService;

    @Override
    @RedisLock(prefix="createlpn")
    public String create(@Key(expr="#daiYunLpn.entid +'-'+ #daiYunLpn.lpnname") DaiYunLpnCreateVo daiYunLpn) throws Exception {
        log.info("\u4ee3\u8fd0\u6807\u7b7e\u751f\u6210\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)daiYunLpn));
        String entid = daiYunLpn.getEntid();
        String shopid = daiYunLpn.getShopid();
        String lpnname = daiYunLpn.getLpnname();
        String checksumno = daiYunLpn.getChecksumno();
        int refsheettype = daiYunLpn.getRefsheettype();
        String deptid = daiYunLpn.getDeptid();
        Criteria criteria = Criteria.where((String)"entid").is((Object)entid).and("shopid").is((Object)shopid).and("lpnname").is((Object)lpnname).and("flag").nin(new Object[]{13, 23, 43, 93, 73, 53, 41, 83});
        Query query = new Query((CriteriaDefinition)criteria);
        InvLpn invLpn = null;
        String lpnid = "";
        List invLpnList = this.invLpnService.dataQueryTotal(query);
        if (!CollectionUtils.isEmpty((Collection)invLpnList)) {
            BmGoodsOwner bmGoodsOwner;
            if (invLpnList.size() > 1) {
                log.error("\u67e5\u8be2\u7ed3\u679c\u4e3a\u591a\u6761!{}", (Object)criteria.toString());
                ExceptionUtils.raise((String)I18nUtil.getMessageWithStringLocale((String)"DaiYunLpnServiceImpl-1", (String)SpringContext.getSession().getLocale()));
            } else {
                invLpn = (InvLpn)invLpnList.get(0);
            }
            if (this.verify(invLpn)) {
                lpnid = invLpn.getLpnid();
                log.info("-----DaiYun[\u4ee3\u8fd0]---lpnid[{}]\u9a8c\u8bc1\u6210\u529f\uff01{}", (Object)lpnid, (Object)JSONObject.toJSONString((Object)daiYunLpn));
            }
            if (Objects.isNull(bmGoodsOwner = this.bmGoodsDubboService.getGoodsOwnerByGdid(invLpn.getEntid(), invLpn.getOwnerid(), daiYunLpn.getGdid()))) {
                ExceptionUtils.raise((String)I18nUtil.getMessageWithStringLocale((String)"DaiYunLpnServiceImpl-2", (String)SpringContext.getSession().getLocale()), (Object[])new Object[]{invLpn.getEntid(), invLpn.getOwnerid(), daiYunLpn.getGdid()});
            }
            InvLpnItem invLpnItem = new InvLpnItem();
            invLpnItem.setEntid(invLpn.getEntid());
            invLpnItem.setShopid(invLpn.getShopid());
            invLpnItem.setShopname(invLpn.getShopname());
            invLpnItem.setLpnid(lpnid);
            invLpnItem.setRowno(Integer.valueOf(1));
            invLpnItem.setOwnerid(invLpn.getOwnerid());
            invLpnItem.setOwnername(invLpn.getOwnername());
            invLpnItem.setCustid(daiYunLpn.getCustid());
            invLpnItem.setCustname("");
            invLpnItem.setOwnercustid(invLpn.getOwnercustid());
            invLpnItem.setOwnercustname(invLpn.getOwnercustname());
            invLpnItem.setDeptid(daiYunLpn.getDeptid());
            invLpnItem.setDeptname("");
            invLpnItem.setGdid(daiYunLpn.getGdid());
            invLpnItem.setGdcode(bmGoodsOwner.getGdcode());
            invLpnItem.setGdname(bmGoodsOwner.getGdname());
            invLpnItem.setSkuspec(bmGoodsOwner.getSkuspec());
            invLpnItem.setSkuunit(bmGoodsOwner.getSkuunit());
            invLpnItem.setBarcode(bmGoodsOwner.getBarcode());
            invLpnItem.setGroupno(bmGoodsOwner.getGroupno());
            invLpnItem.setGroupname(bmGoodsOwner.getGroupname());
            invLpnItem.setPackingqty(bmGoodsOwner.getPackingqty());
            invLpnItem.setPackingspec(bmGoodsOwner.getPackingspec());
            invLpnItem.setQty(Double.valueOf(daiYunLpn.getQty().doubleValue()));
            invLpnItem.setExpno(daiYunLpn.getChecksumno());
            this.invLpnItemService.onInsert(invLpnItem);
        } else {
            ImCheckSum checkSum;
            BsContainer bsContainer = this.getLpntype(entid, "1", 1, lpnname);
            if (Objects.isNull(bsContainer)) {
                log.error("lpnname:{}", (Object)lpnname);
                ExceptionUtils.raise((String)I18nUtil.getMessageWithStringLocale((String)"DaiYunLpnServiceImpl-3", (String)SpringContext.getSession().getLocale()));
            }
            if (Objects.isNull(checkSum = (ImCheckSum)this.template.selectOne(query = new Query((CriteriaDefinition)(criteria = Criteria.where((String)"entid").is((Object)entid).and("sheetid").is((Object)checksumno))), ImCheckSum.class))) {
                log.error("\u67e5\u8be2\u4e0d\u5230\u9a8c\u6536\u6c47\u603b\u5355\u4e3b\u6863\u4fe1\u606f!{}", (Object)JSONObject.toJSONString((Object)criteria));
                ExceptionUtils.raise((String)I18nUtil.getMessageWithStringLocale((String)"DaiYunLpnServiceImpl-4", (String)SpringContext.getSession().getLocale()));
            }
            lpnid = GenRuleCodeUtils.getGenCode((String)"lpnid", (String)LpnEnum.LPN_TYPE.getLpnType());
            invLpn = new InvLpn();
            invLpn.setFlag(Integer.valueOf(50));
            invLpn.setOwnerlpnid(lpnid);
            invLpn.setOwnerlpnname(lpnname);
            invLpn.setExpno(checksumno);
            invLpn.setUsetype(Integer.valueOf(5));
            invLpn.setChangetype(Integer.valueOf(51));
            invLpn.setRefsheetid(checksumno);
            invLpn.setRefsheettype(Integer.valueOf(refsheettype));
            invLpn.setDeptid(deptid);
            invLpn.setLpnid(lpnid);
            invLpn.setLpntype(bsContainer.getLpntype());
            invLpn.setLpntypeid(bsContainer.getLpntypeid());
            invLpn.setLpntypename(bsContainer.getLpnname());
            invLpn.setLpnname(lpnname);
            invLpn.setShopid(shopid);
            invLpn.setEntid(entid);
            invLpn.setOwnercustid("N");
            invLpn.setOwnercustname("N");
            invLpn.setCustid(daiYunLpn.getCustid());
            invLpn.setCustname("N");
            invLpn.setCarrierno("N");
            invLpn.setCarriername("N");
            invLpn.setCellno("N");
            invLpn.setDbsplitcode("1");
            invLpn.setOwnerid(checkSum.getOwnerid());
            invLpn.setOwnername(checkSum.getOwnername());
            invLpn.setShopname(checkSum.getShopname());
            invLpn.setDeptid(checkSum.getDeptid());
            invLpn.setDeptname(checkSum.getDeptname());
            invLpn.setRealpackageqty(Integer.valueOf(daiYunLpn.getBoxQty().intValue()));
            this.invLpnService.onInsert(invLpn);
            this.invLpnMoveLogService.insert(invLpn);
        }
        return lpnid;
    }

    @Override
    public boolean verify(InvLpn invLpn) {
        ServiceResponse response = ServiceResponse.buildSuccess(null);
        if (Objects.nonNull(invLpn)) {
            int status = invLpn.getFlag();
            if (status == 10) {
                ExceptionUtils.raise((String)I18nUtil.getMessageWithStringLocale((String)"DaiYunLpnServiceImpl-5", (String)SpringContext.getSession().getLocale()));
            } else if (status == 11) {
                ExceptionUtils.raise((String)I18nUtil.getMessageWithStringLocale((String)"DaiYunLpnServiceImpl-6", (String)SpringContext.getSession().getLocale()));
            } else if (Lists.newArrayList((Object[])new Integer[]{20, 21}).contains(status)) {
                ExceptionUtils.raise((String)I18nUtil.getMessageWithStringLocale((String)"DaiYunLpnServiceImpl-7", (String)SpringContext.getSession().getLocale()));
            } else if (Lists.newArrayList((Object[])new Integer[]{41, 42}).contains(status)) {
                ExceptionUtils.raise((String)I18nUtil.getMessageWithStringLocale((String)"DaiYunLpnServiceImpl-8", (String)SpringContext.getSession().getLocale()));
            } else if (Lists.newArrayList((Object[])new Integer[]{30, 31}).contains(status)) {
                ExceptionUtils.raise((String)I18nUtil.getMessageWithStringLocale((String)"DaiYunLpnServiceImpl-9", (String)SpringContext.getSession().getLocale()));
            } else if (Lists.newArrayList((Object[])new Integer[]{70, 71}).contains(status)) {
                ExceptionUtils.raise((String)I18nUtil.getMessageWithStringLocale((String)"DaiYunLpnServiceImpl-10", (String)SpringContext.getSession().getLocale()));
            } else if (Lists.newArrayList((Object[])new Integer[]{80, 81}).contains(status)) {
                ExceptionUtils.raise((String)I18nUtil.getMessageWithStringLocale((String)"DaiYunLpnServiceImpl-11", (String)SpringContext.getSession().getLocale()));
            } else if (status == 90) {
                ExceptionUtils.raise((String)I18nUtil.getMessageWithStringLocale((String)"DaiYunLpnServiceImpl-12", (String)SpringContext.getSession().getLocale()));
            } else if (status == 91) {
                ExceptionUtils.raise((String)I18nUtil.getMessageWithStringLocale((String)"DaiYunLpnServiceImpl-13", (String)SpringContext.getSession().getLocale()));
            }
        }
        return true;
    }
}

