/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.isce.wmsinv.service.impl.invlpn.create;

import com.alibaba.fastjson.JSONObject;
import com.efuture.common.annotation.Key;
import com.efuture.common.annotation.RedisLock;
import com.efuture.common.enums.LpnEnum;
import com.efuture.common.utils.ExceptionUtils;
import com.efuture.common.utils.GenRuleCodeUtils;
import com.efuture.isce.mdm.code.BsContainer;
import com.efuture.isce.wms.conf.exposedapi.WmsConfApi;
import com.efuture.isce.wms.im.ImImportSum;
import com.efuture.isce.wms.inv.inv.InvLpn;
import com.efuture.isce.wms.inv.vo.DivideLpnCreateVo;
import com.efuture.isce.wms.stock.OmOutStocksItem;
import com.efuture.isce.wmsinv.service.invlog.InvLpnMoveLogService;
import com.efuture.isce.wmsinv.service.invlpn.InvLpnService;
import com.efuture.isce.wmsinv.service.invlpn.create.InvLpnCreateService;
import com.google.common.collect.Lists;
import com.product.model.ServiceResponse;
import com.product.storage.template.FMybatisTemplate;
import com.product.util.SpringContext;
import com.shiji.core.util.I18nUtil;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DivideLpnServiceImpl
implements InvLpnCreateService<DivideLpnCreateVo> {
    private static final Logger log = LoggerFactory.getLogger(DivideLpnServiceImpl.class);
    @Autowired
    private InvLpnService invLpnService;
    @Resource
    @Qualifier(value="moreStorageOperation")
    private FMybatisTemplate template;
    @Autowired
    private InvLpnMoveLogService invLpnMoveLogService;
    @DubboReference
    private WmsConfApi wmsConfApi;

    @Override
    @RedisLock(prefix="createlpn")
    public String create(@Key(expr="#divideLpn.entid +'-'+ #divideLpn.lpnname") DivideLpnCreateVo divideLpn) throws Exception {
        log.info("\u5206\u64ad\u6807\u7b7e\u751f\u6210\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)divideLpn));
        long start = System.currentTimeMillis();
        String entid = divideLpn.getEntid();
        String shopid = divideLpn.getShopid();
        String lpnname = divideLpn.getLpnname();
        int lpndevtype = divideLpn.getLpndevtype();
        int refsheettype = divideLpn.getRefsheettype();
        String deptid = divideLpn.getDeptid();
        Criteria criteria = lpndevtype == 1 ? Criteria.where((String)"entid").is((Object)entid).and("shopid").is((Object)shopid).and("lpnname").is((Object)lpnname).and("usetype").is((Object)4).and("flag").nin(new Object[]{13, 23, 30, 93, 43, 73, 83, 53}) : Criteria.where((String)"entid").is((Object)entid).and("shopid").is((Object)shopid).and("lpnname").is((Object)lpnname).and("usetype").is((Object)4).and("flag").nin(new Object[]{13, 23, 93, 43, 73, 83, 53});
        Query query = new Query((CriteriaDefinition)criteria);
        InvLpn invLpn = null;
        String lpnid = "";
        List invLpnList = this.invLpnService.dataQueryTotal(query);
        log.info("\u9a8c\u6536\u63d0\u4ea4\u8282\u70b9\u521b\u5efa\u5206\u64ad\u5bb9\u56681\u8017\u65f6 - \u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        if (!CollectionUtils.isEmpty((Collection)invLpnList)) {
            if (invLpnList.size() > 1) {
                log.error("\u67e5\u8be2\u7ed3\u679c\u4e3a\u591a\u6761!{}", (Object)criteria.toString());
                ExceptionUtils.raise((String)I18nUtil.getMessageWithStringLocale((String)"DeliveryLpnServiceImpl-4", (String)SpringContext.getSession().getLocale()));
            } else {
                invLpn = (InvLpn)invLpnList.get(0);
            }
            if (this.verify(invLpn)) {
                lpnid = invLpn.getLpnid();
                log.info("-----Distribution[\u5206\u64ad]---lpnid[{}]\u9a8c\u8bc1\u6210\u529f\uff01{}", (Object)lpnid, (Object)JSONObject.toJSONString((Object)divideLpn));
            }
            log.info("\u9a8c\u6536\u63d0\u4ea4\u8282\u70b9\u521b\u5efa\u5206\u64ad\u5bb9\u56682\u8017\u65f6 - \u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
            start = System.currentTimeMillis();
        } else {
            BsContainer bsContainer = this.getLpntype(entid, "1", 1, lpnname);
            String checklab = this.wmsConfApi.getGlobParaValue(entid, shopid, "INSTOCKCHECKLAB", "1");
            if ("1".equals(checklab)) {
                if (Objects.isNull(bsContainer)) {
                    log.error("lpnname:{}", (Object)lpnname);
                    ExceptionUtils.raise((String)I18nUtil.getMessageWithStringLocale((String)"PutwayLpnServiceImpl-3", (String)SpringContext.getSession().getLocale()));
                }
            } else {
                bsContainer = new BsContainer();
                bsContainer.setLpntype(Integer.valueOf(0));
                bsContainer.setLpntypeid("P");
                bsContainer.setLpnname("BOXID");
            }
            criteria = Criteria.where((String)"entid").is((Object)entid).and("shopid").is((Object)shopid).and("lpnname").is((Object)lpnname);
            query = new Query((CriteriaDefinition)criteria);
            String ownerid = "";
            String ownername = "";
            String shopname = "";
            String deptname = "";
            if (lpndevtype == 0) {
                List outStocksItemList = this.template.select(query, OmOutStocksItem.class);
                if (!CollectionUtils.isEmpty((Collection)outStocksItemList)) {
                    ownerid = ((OmOutStocksItem)outStocksItemList.get(0)).getOwnerid();
                    ownername = ((OmOutStocksItem)outStocksItemList.get(0)).getOwnername();
                    shopname = ((OmOutStocksItem)outStocksItemList.get(0)).getShopname();
                    deptid = ((OmOutStocksItem)outStocksItemList.get(0)).getDeptid();
                    deptname = ((OmOutStocksItem)outStocksItemList.get(0)).getDeptname();
                } else {
                    ExceptionUtils.raise((String)MessageFormat.format(I18nUtil.getMessageWithStringLocale((String)"DeliveryLpnServiceImpl-2", (String)SpringContext.getSession().getLocale()), JSONObject.toJSONString((Object)query)));
                }
            } else {
                criteria = Criteria.where((String)"entid").is((Object)entid).and("sheetid").is((Object)divideLpn.getSheetid());
                query = new Query((CriteriaDefinition)criteria);
                ImImportSum imImportSum = (ImImportSum)this.template.selectOne(query, ImImportSum.class);
                if (Objects.nonNull(imImportSum)) {
                    ownerid = imImportSum.getOwnerid();
                    ownername = imImportSum.getOwnername();
                    shopname = imImportSum.getShopname();
                    deptid = imImportSum.getDeptid();
                    deptname = imImportSum.getDeptname();
                } else {
                    ExceptionUtils.raise((String)MessageFormat.format(I18nUtil.getMessageWithStringLocale((String)"DivideLpnServiceImpl-1", (String)SpringContext.getSession().getLocale()), JSONObject.toJSONString((Object)query)));
                }
            }
            log.info("\u9a8c\u6536\u63d0\u4ea4\u8282\u70b9\u521b\u5efa\u5206\u64ad\u5bb9\u56683\u8017\u65f6 - \u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
            start = System.currentTimeMillis();
            lpnid = GenRuleCodeUtils.getGenCode((String)"lpnid", (String)LpnEnum.LPN_TYPE.getLpnType());
            invLpn = new InvLpn();
            invLpn.setFlag(Integer.valueOf(40));
            invLpn.setOwnerlpnid(lpnid);
            invLpn.setOwnerlpnname(lpnname);
            invLpn.setUsetype(Integer.valueOf(4));
            invLpn.setChangetype(Integer.valueOf(41));
            invLpn.setLpndevtype(Integer.valueOf(lpndevtype));
            invLpn.setRefsheetid(divideLpn.getSheetid());
            invLpn.setRefsheettype(Integer.valueOf(refsheettype));
            invLpn.setDeptid(deptid);
            invLpn.setLpnid(lpnid);
            invLpn.setLpntype(bsContainer.getLpntype());
            invLpn.setLpntypeid(bsContainer.getLpntypeid());
            invLpn.setLpntypename(bsContainer.getLpnname());
            invLpn.setLpnname(lpnname);
            invLpn.setShopid(shopid);
            invLpn.setEntid(entid);
            invLpn.setOwnercustid("N");
            invLpn.setOwnercustname("N");
            invLpn.setCustid("N");
            invLpn.setCustname("N");
            invLpn.setCarrierno("N");
            invLpn.setCarriername("N");
            invLpn.setCellno("N");
            invLpn.setDbsplitcode("1");
            invLpn.setOwnerid(ownerid);
            invLpn.setOwnername(ownername);
            invLpn.setShopname(shopname);
            invLpn.setDeptid(deptid);
            invLpn.setDeptname(deptname);
            this.invLpnService.onInsert(invLpn);
            this.invLpnMoveLogService.insert(invLpn);
            log.info("\u9a8c\u6536\u63d0\u4ea4\u8282\u70b9\u521b\u5efa\u5206\u64ad\u5bb9\u56684\u8017\u65f6 - \u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
            start = System.currentTimeMillis();
        }
        return lpnid;
    }

    @Override
    public boolean verify(InvLpn invLpn) {
        ServiceResponse response = ServiceResponse.buildSuccess(null);
        if (Objects.nonNull(invLpn)) {
            int status = invLpn.getFlag();
            if (status == 10) {
                ExceptionUtils.raise((String)I18nUtil.getMessageWithStringLocale((String)"DivideLpnServiceImpl-2", (String)SpringContext.getSession().getLocale()));
            } else if (status == 11) {
                ExceptionUtils.raise((String)I18nUtil.getMessageWithStringLocale((String)"DivideLpnServiceImpl-3", (String)SpringContext.getSession().getLocale()));
            } else if (Lists.newArrayList((Object[])new Integer[]{20, 21}).contains(status)) {
                ExceptionUtils.raise((String)I18nUtil.getMessageWithStringLocale((String)"DivideLpnServiceImpl-4", (String)SpringContext.getSession().getLocale()));
            } else if (Lists.newArrayList((Object[])new Integer[]{50, 51}).contains(status)) {
                ExceptionUtils.raise((String)I18nUtil.getMessageWithStringLocale((String)"DivideLpnServiceImpl-5", (String)SpringContext.getSession().getLocale()));
            } else if (Lists.newArrayList((Object[])new Integer[]{30, 31}).contains(status)) {
                ExceptionUtils.raise((String)I18nUtil.getMessageWithStringLocale((String)"DivideLpnServiceImpl-6", (String)SpringContext.getSession().getLocale()));
            } else if (Lists.newArrayList((Object[])new Integer[]{70, 71}).contains(status)) {
                ExceptionUtils.raise((String)I18nUtil.getMessageWithStringLocale((String)"DivideLpnServiceImpl-7", (String)SpringContext.getSession().getLocale()));
            } else if (Lists.newArrayList((Object[])new Integer[]{80, 81}).contains(status)) {
                ExceptionUtils.raise((String)I18nUtil.getMessageWithStringLocale((String)"DivideLpnServiceImpl-8", (String)SpringContext.getSession().getLocale()));
            } else if (status == 90) {
                ExceptionUtils.raise((String)I18nUtil.getMessageWithStringLocale((String)"DivideLpnServiceImpl-9", (String)SpringContext.getSession().getLocale()));
            } else if (status == 91) {
                ExceptionUtils.raise((String)I18nUtil.getMessageWithStringLocale((String)"DivideLpnServiceImpl-10", (String)SpringContext.getSession().getLocale()));
            }
        }
        return true;
    }
}

