/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.isce.wmsinv.service.impl.invlpn;

import com.alibaba.fastjson.JSONObject;
import com.efuture.common.utils.AccountUtils;
import com.efuture.common.utils.QueryUtils;
import com.efuture.isce.wms.inv.inv.InvLpnItem;
import com.efuture.isce.wmsinv.mapper.Inv.InvLpnMapper;
import com.efuture.isce.wmsinv.service.invlpn.InvLpnItemService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.product.config.dynamicds.DynamicJDBCCompomentServiceImpl;
import com.product.model.ServiceResponse;
import com.product.storage.template.FMybatisTemplate;
import com.product.util.SpringContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

@Service
public class InvLpnItemServiceImpl
extends DynamicJDBCCompomentServiceImpl<InvLpnItem>
implements InvLpnItemService {
    private static final Logger log = LoggerFactory.getLogger(InvLpnItemServiceImpl.class);
    @Autowired
    private InvLpnMapper invLpnMapper;

    public InvLpnItemServiceImpl(FMybatisTemplate mybatisTemplate) {
        super(mybatisTemplate, "invlpnitem", "id");
    }

    protected Document onBeforeRowInsert(Query query, Update update) {
        return this.onDefaultRowInsert(query, update);
    }

    @Override
    public int getItemCountByLpnid(String entid, String shopid, String lpnid) {
        return (int)this.onCount(SpringContext.getSession(), this.getTemplate(), QueryUtils.build((Criteria)Criteria.where((String)"entid").is((Object)entid).and("shopid").is((Object)shopid).and("lpnid").is((Object)lpnid)), this.getCollectionName());
    }

    @Override
    public List<InvLpnItem> getItemByLpnid(String entid, String shopid, String lpnid) {
        return this.dataQueryTotal(QueryUtils.build((Criteria)Criteria.where((String)"entid").is((Object)entid).and("shopid").is((Object)shopid).and("lpnid").is((Object)lpnid)));
    }

    @Override
    public List<InvLpnItem> getItemByGdid(String entid, String shopid, String lpnid, String gdid, Double packingqty) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("entid", entid);
        param.put("shopid", shopid);
        param.put("lpnid", lpnid);
        param.put("gdid", gdid);
        if (null != packingqty) {
            param.put("packingqty", packingqty);
        }
        return this.dataQueryTotal(QueryUtils.build(param, (String)"qty asc"));
    }

    @Override
    public List<InvLpnItem> selectItemByHeadUsertype(String entid, String expno, List<Integer> expids) {
        return this.invLpnMapper.selectItemByHeadUsertype(entid, expno, expids);
    }

    @Override
    public ServiceResponse queryForPartmoveBatch(InvLpnItem entry) {
        PageInfo pageinfo = PageHelper.startPage((int)entry.getPage_no(), (int)entry.getPage_size()).doSelectPageInfo(() -> this.invLpnMapper.queryForPartmoveBatch(entry));
        List list = pageinfo.getList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            Map accountMap = AccountUtils.getAccountUsernameMap();
            list.forEach(i -> {
                if (StringUtils.isNotBlank((CharSequence)i.getCreator())) {
                    i.setCreatorStr("[" + i.getCreator() + "]" + (String)accountMap.get(i.getCreator()));
                }
                if (StringUtils.isNotBlank((CharSequence)i.getModifier())) {
                    i.setModifierStr("[" + i.getModifier() + "]" + (String)accountMap.get(i.getModifier()));
                }
            });
        }
        JSONObject obj = new JSONObject();
        obj.put("invlpnitem", (Object)list);
        obj.put("total_results", (Object)pageinfo.getTotal());
        return ServiceResponse.buildSuccess((Object)obj);
    }
}

