/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.isce.wmsinv.utils;

import com.alibaba.fastjson.JSONObject;
import com.efuture.isce.mdm.code.BsContainer;
import com.efuture.isce.mdm.exposedapi.MdmDubboApi;
import com.efuture.isce.wms.inv.inv.InvLpnItem;
import com.efuture.isce.wmsinv.service.invlpn.InvLpnItemService;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.support.atomic.RedisAtomicLong;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class StaticLpnRowUtils {
    @Autowired
    @Lazy
    private InvLpnItemService invLpnItemService;
    @Autowired
    private RedisTemplate redisTemplate;
    @DubboReference
    private MdmDubboApi mdmDubboApi;

    public Integer onIncrementName(String entid, String shopid, String lpnid) {
        RedisAtomicLong redisAtomicLong = new RedisAtomicLong("LpnRowIncrement:" + entid + ":" + shopid + "-" + lpnid, this.redisTemplate.getConnectionFactory());
        long l = redisAtomicLong.get();
        if (l == 0L) {
            JSONObject itemParam = new JSONObject();
            itemParam.put("entid", (Object)entid);
            itemParam.put("shopid", (Object)shopid);
            itemParam.put("lpnid", (Object)lpnid);
            List invLpnItemList = this.invLpnItemService.dataQueryTotal(itemParam);
            Integer maxrow = invLpnItemList.stream().mapToInt(InvLpnItem::getRowno).max().getAsInt() + 1;
            redisAtomicLong.set(maxrow == null ? 0L : maxrow.longValue());
        }
        long l1 = redisAtomicLong.incrementAndGet();
        redisAtomicLong.expire(1L, TimeUnit.DAYS);
        return NumberUtils.toInt((String)Long.toString(l1));
    }

    public BsContainer getLpntype(String entid, String dbsplitcode, Integer status, String lpnname) throws Exception {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Pattern pattern = Pattern.compile("(^[A-Za-z]+)");
        Matcher matcher = pattern.matcher(lpnname);
        String lpntypeid = "";
        Integer lpnlength = 0;
        if (matcher.find()) {
            lpntypeid = matcher.group(1);
        }
        if (StringUtils.isEmpty((Object)lpntypeid)) {
            if (!StringUtils.isEmpty((Object)lpnname)) {
                lpntypeid = lpnname.substring(0, 1);
            } else {
                logger.info("--------[getLpntype]lpnname\u4e3a\u7a7a\uff01\uff01\uff01");
            }
        }
        lpnlength = lpnname.substring(lpntypeid.length()).length();
        if (!lpnname.substring(lpntypeid.length()).matches("\\d+")) {
            logger.info("\u68c0\u67e5\u5e8f\u5217\u53f7\u4e2d\u662f\u6709\u975e\u6570\u5b57");
            return null;
        }
        JSONObject param = new JSONObject();
        param.put("entid", (Object)entid);
        param.put("dbsplitcode", (Object)dbsplitcode);
        param.put("status", (Object)status);
        List containerList = this.mdmDubboApi.getContainers(entid, dbsplitcode, status);
        if (!CollectionUtils.isEmpty((Collection)containerList)) {
            String finalLpntypeid = lpntypeid;
            Optional<BsContainer> optional = containerList.stream().filter(c -> c.getLpntypeid().equals(finalLpntypeid)).findFirst();
            if (optional.isPresent()) {
                if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)"P", (CharSequence)optional.get().getLpntypeid()) && lpnlength.intValue() != optional.get().getSerialnolength().intValue()) {
                    logger.info("\u5bb9\u5668\u53f7\u3010{}\u3011\u957f\u5ea6\u4e0e\u6d41\u6c34\u7801\u957f\u5ea6\u3010{}\u3011\u4e0d\u4e00\u81f4\uff01", (Object)lpnname.substring(lpntypeid.length()), (Object)optional.get().getSerialnolength());
                    return null;
                }
                return optional.get();
            }
        }
        return null;
    }
}

