/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.isce.wmsinv.service.impl.invlpn;

import com.efuture.common.Constant;
import com.efuture.common.enums.VerifyStatus;
import com.efuture.common.utils.QueryUtils;
import com.efuture.isce.mdm.clz.BmClassOwner;
import com.efuture.isce.wms.delivery.OmDeliverItem;
import com.efuture.isce.wms.inv.inv.InvLpn;
import com.efuture.isce.wms.inv.inv.InvLpnItem;
import com.efuture.isce.wmsinv.mapper.Inv.InvLpnMapper;
import com.efuture.isce.wmsinv.service.invlpn.InvLpnLogService;
import com.efuture.isce.wmsinv.service.invlpn.InvLpnService;
import com.product.config.dynamicds.DynamicJDBCCompomentServiceImpl;
import com.product.model.ServiceSession;
import com.product.storage.template.FMybatisTemplate;
import jakarta.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

@Service
public class InvLpnServiceImpl
extends DynamicJDBCCompomentServiceImpl<InvLpn>
implements InvLpnService {
    private static final Logger log = LoggerFactory.getLogger(InvLpnServiceImpl.class);
    @Autowired
    private InvLpnLogService lpnLogService;
    @Resource
    private InvLpnMapper invLpnMapper;

    public InvLpnServiceImpl(FMybatisTemplate mybatisTemplate) {
        super(mybatisTemplate, "invlpn", "id");
    }

    protected Document onBeforeRowInsert(Query query, Update update) {
        return this.onDefaultRowInsert(query, update);
    }

    @Override
    public int batchDelete(String entid, String shopid, List<String> lpnid) {
        return this.getTemplate().delete((Object)QueryUtils.build((Criteria)Criteria.where((String)"entid").is((Object)entid).and("shopid").is((Object)shopid).and("lpnid").in(lpnid)));
    }

    protected void onBeforeDelete(ServiceSession session, Criteria criteria) {
        List invLpns = this.dataQuery(QueryUtils.build((Criteria)criteria));
        if (CollectionUtils.isNotEmpty((Collection)invLpns)) {
            invLpns.forEach(invLpn -> this.lpnLogService.log((InvLpn)invLpn, VerifyStatus.REJECT.value()));
        }
    }

    @Override
    public List<BmClassOwner> getInvLpnGroup(String entid, String shopid, String custid) {
        return this.invLpnMapper.getInvLpnGroup(entid, shopid, custid);
    }

    @Override
    public List<OmDeliverItem> getInvLpnGroupDetail(String entid, String shopid, String custid, String groupno) {
        ArrayList<OmDeliverItem> list = new ArrayList<OmDeliverItem>();
        List<InvLpnItem> itemList = this.invLpnMapper.getInvLpnGroupDetail(entid, shopid, custid, groupno);
        Map<String, List<InvLpnItem>> itemMap = itemList.stream().collect(Collectors.groupingBy(InvLpnItem::getGdid));
        itemMap.forEach((k, v) -> {
            InvLpnItem temp = (InvLpnItem)v.get(0);
            OmDeliverItem entry = new OmDeliverItem();
            BeanUtils.copyProperties((Object)temp, (Object)entry, (String[])Constant.DEFAULT_IGNOREPROPERTIES);
            entry.setGdcode(temp.getGdid());
            double qty = v.stream().mapToDouble(InvLpnItem::getQty).sum();
            entry.setRealqty(BigDecimal.valueOf(qty));
            Map<BigDecimal, List<InvLpnItem>> packingqtyMap = v.stream().collect(Collectors.groupingBy(InvLpnItem::getPackingqty));
            double boxqty = 0.0;
            for (BigDecimal m : packingqtyMap.keySet()) {
                List<InvLpnItem> n = packingqtyMap.get(m);
                double tempQty = n.stream().mapToDouble(InvLpnItem::getQty).sum();
                double tempBoxqty = Math.floor(tempQty / m.doubleValue());
                boxqty += tempBoxqty;
            }
            entry.setBoxQty(BigDecimal.valueOf(boxqty));
            list.add(entry);
        });
        return list;
    }
}

