/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.isce.wmsinv.service.impl.invlpn;

import com.efuture.common.utils.ExceptionUtils;
import com.efuture.isce.wms.inv.inv.InvLpn;
import com.efuture.isce.wms.inv.inv.InvLpnItem;
import com.efuture.isce.wms.inv.invlog.InvLpnLog;
import com.efuture.isce.wmsinv.service.invlpn.InvLpnLogService;
import com.product.config.dynamicds.DynamicJDBCCompomentServiceImpl;
import com.product.storage.template.FMybatisTemplate;
import com.product.util.SpringContext;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bson.Document;
import org.springframework.beans.BeanUtils;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

@Service
public class InvLpnLogServiceImpl
extends DynamicJDBCCompomentServiceImpl<InvLpnLog>
implements InvLpnLogService {
    private final String[] ignore = new String[]{"id", "creator", "createtime", "modifier", "modifytime"};

    public InvLpnLogServiceImpl(FMybatisTemplate mybatisTemplate) {
        super(mybatisTemplate, "invlpnlog", "id");
    }

    public void initUpsert() {
        this.setUpsert(false);
    }

    protected Document onBeforeRowInsert(Query query, Update update) {
        return this.onDefaultRowInsert(query, update);
    }

    @Override
    public int log(InvLpn fmlpn, InvLpn tolpn, Integer status) {
        Date date = new Date();
        InvLpnLog invLpnLog = new InvLpnLog();
        BeanUtils.copyProperties((Object)fmlpn, (Object)invLpnLog, (String[])this.ignore);
        invLpnLog.setOperatedate(date);
        invLpnLog.setConchangeflag(status);
        invLpnLog.setFmownerlpnid(fmlpn.getLpnid());
        invLpnLog.setFmownerlpnname(fmlpn.getLpnname());
        invLpnLog.setFmlpnid(fmlpn.getLpnid());
        invLpnLog.setFmlpnname(fmlpn.getLpnname());
        invLpnLog.setToownerlpnid(tolpn.getLpnid());
        invLpnLog.setToownerlpnname(tolpn.getLpnname());
        invLpnLog.setTolpnid(fmlpn.getLpnid());
        invLpnLog.setTolpnname(fmlpn.getLpnname());
        invLpnLog.setGdcode("N");
        invLpnLog.setGdname("N");
        invLpnLog.setPackingqty(Double.valueOf(1.0));
        invLpnLog.setLotid("N");
        this.onInsert(invLpnLog);
        return 1;
    }

    @Override
    public int log(InvLpn fmlpn, List<InvLpnItem> fmlpnitems, InvLpn tolpn) {
        List invLpnLogs = fmlpnitems.stream().map(fmlpnitem -> {
            InvLpnLog invLpnLog = new InvLpnLog();
            BeanUtils.copyProperties((Object)fmlpnitem, (Object)invLpnLog, (String[])this.ignore);
            invLpnLog.setOperatedate(new Date());
            invLpnLog.setPackingqty(Double.valueOf(fmlpnitem.getPackingqty().doubleValue()));
            invLpnLog.setConchangeflag(Integer.valueOf(1));
            invLpnLog.setFmlpnid(fmlpn.getLpnid());
            invLpnLog.setFmlpnname(fmlpn.getLpnname());
            invLpnLog.setFmownerlpnid(fmlpn.getOwnerlpnid());
            invLpnLog.setFmownerlpnname(fmlpn.getOwnerlpnname());
            invLpnLog.setTolpnid(tolpn.getLpnid());
            invLpnLog.setTolpnname(tolpn.getLpnname());
            invLpnLog.setToownerlpnid(tolpn.getOwnerlpnid());
            invLpnLog.setToownerlpnname(tolpn.getOwnerlpnname());
            return invLpnLog;
        }).collect(Collectors.toList());
        try {
            this.batchInsert(invLpnLogs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return invLpnLogs.size();
    }

    @Override
    public int log(InvLpn lpn, Integer status) {
        return this.log(lpn, status, null);
    }

    @Override
    public int log(InvLpn lpn, Integer status, String operator) {
        Date date = new Date();
        InvLpnLog invLpnLog = new InvLpnLog();
        BeanUtils.copyProperties((Object)lpn, (Object)invLpnLog, (String[])this.ignore);
        invLpnLog.setOperatedate(date);
        invLpnLog.setConchangeflag(status);
        invLpnLog.setFmownerlpnid(lpn.getOwnerlpnid());
        invLpnLog.setFmownerlpnname(lpn.getOwnerlpnname());
        invLpnLog.setFmlpnid(lpn.getLpnid());
        invLpnLog.setFmlpnname(lpn.getLpnname());
        invLpnLog.setGdcode("N");
        invLpnLog.setGdname("N");
        invLpnLog.setPackingqty(Double.valueOf(1.0));
        invLpnLog.setLotid("N");
        invLpnLog.setCreator(Optional.ofNullable(operator).orElse(SpringContext.getSession().getUser_code()));
        invLpnLog.setCreatetime(new Date());
        this.onInsert(invLpnLog);
        return 1;
    }

    @Override
    public int log(InvLpn lpn, List<InvLpnItem> targetLpnItem, Integer status) {
        Date date = new Date();
        List invLpnLogs = targetLpnItem.stream().map(fmlpnitem -> {
            InvLpnLog invLpnLog = new InvLpnLog();
            BeanUtils.copyProperties((Object)fmlpnitem, (Object)invLpnLog, (String[])this.ignore);
            invLpnLog.setOperatedate(date);
            invLpnLog.setPackingqty(Double.valueOf(fmlpnitem.getPackingqty().doubleValue()));
            invLpnLog.setConchangeflag(status);
            invLpnLog.setFmlpnid(lpn.getLpnid());
            invLpnLog.setFmlpnname(lpn.getLpnname());
            invLpnLog.setFmownerlpnid(lpn.getOwnerlpnid());
            invLpnLog.setFmownerlpnname(lpn.getOwnerlpnname());
            return invLpnLog;
        }).collect(Collectors.toList());
        try {
            this.batchInsert(invLpnLogs);
        }
        catch (Exception e) {
            ExceptionUtils.raise((String)"\u5bb9\u5668\u8f6c\u79fb\u65e5\u5fd7\u6279\u91cf\u65b0\u589e\u5931\u8d25\uff01");
        }
        return invLpnLogs.size();
    }
}

