/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.congou.core.util;

import com.efuture.congou.core.util.ByteUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/*
 * Exception performing whole class analysis ignored.
 */
public class Convert {
    public static String Int32ToString(int value) {
        return Integer.toString(value);
    }

    public static String Int16ToString(short value) {
        return Short.toString(value);
    }

    public static String DoubleToString(double value) {
        return Double.toString(value);
    }

    public static String FloatToString(float value) {
        return Float.toString(value);
    }

    public static String Int64ToString(long value) {
        return Long.toString(value);
    }

    public static long StringToInt64(String value) {
        return Long.parseLong(value);
    }

    public static byte[] BlobToBytes(Blob value) {
        if (value == null) {
            return null;
        }
        byte[] data = null;
        try {
            data = value.getBytes(1L, (int)value.length());
            return data;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public static String ClobToString(Clob cl) {
        try {
            String reString = "";
            Reader is = cl.getCharacterStream();
            BufferedReader br = new BufferedReader(is);
            String s = br.readLine();
            StringBuffer sb = new StringBuffer();
            while (s != null) {
                sb.append(s);
                s = br.readLine();
            }
            reString = sb.toString();
            return reString;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
        catch (SQLException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static Timestamp ConvertToSQLDate(Date value) {
        return new Timestamp(value.getTime());
    }

    public static String ToString(Object value) {
        if (value instanceof Integer) {
            int value2 = (Integer)value;
            return Convert.Int32ToString((int)value2);
        }
        if (value instanceof Short) {
            Short s = (Short)value;
            return Convert.Int16ToString((short)s);
        }
        if (value instanceof Character) {
            Character s = (Character)value;
            return s.toString();
        }
        if (value instanceof String) {
            String s = (String)value;
            return s;
        }
        if (value instanceof StringBuffer) {
            StringBuffer s = (StringBuffer)value;
            return s.toString();
        }
        if (value instanceof Double) {
            double d = (Double)value;
            String str = Convert.DoubleToString((double)d);
            if (str.endsWith(".0")) {
                str = str.replaceAll("\\.0", "");
            }
            if (str.endsWith(".00")) {
                str = str.replaceAll("\\.00", "");
            }
            return str;
        }
        if (value instanceof Float) {
            float f = ((Float)value).floatValue();
            String str = Convert.FloatToString((float)f);
            if (str.endsWith(".0")) {
                str = str.replaceAll("\\.0", "");
            }
            if (str.endsWith(".00")) {
                str = str.replaceAll("\\.00", "");
            }
            return str;
        }
        if (value instanceof Long) {
            long l = (Long)value;
            return Convert.Int64ToString((long)l);
        }
        if (value instanceof Blob) {
            Blob blob = (Blob)value;
            if (blob == null) {
                return "";
            }
            byte[] data = Convert.BlobToBytes((Blob)blob);
            return ByteUtils.logBytes((byte[])data);
        }
        if (value instanceof Clob) {
            Clob clob = (Clob)value;
            if (clob == null) {
                return "";
            }
            return Convert.ClobToString((Clob)clob);
        }
        if (value instanceof Boolean) {
            boolean b = (Boolean)value;
            return b ? "true" : "false";
        }
        if (value instanceof Date) {
            Date d = (Date)value;
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String str = formatter.format(d);
            return str;
        }
        if (value instanceof Timestamp) {
            Timestamp d2 = (Timestamp)value;
            Timestamp d = Convert.ConvertToSQLDate((Date)d2);
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String str = formatter.format(d);
            return str;
        }
        if (value instanceof Calendar) {
            Calendar d = (Calendar)value;
            Date d2 = d.getTime();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String str = formatter.format(d2);
            return str;
        }
        if (value instanceof BigDecimal) {
            BigDecimal d = (BigDecimal)value;
            return d.toString();
        }
        return "";
    }

    public static Long ToInt64(Object value) {
        if (value instanceof Integer) {
            int value2 = (Integer)value;
            return value2;
        }
        if (value instanceof Short) {
            Short s = (Short)value;
            return (long)s;
        }
        if (value instanceof String) {
            String s = (String)value;
            return Convert.StringToInt64((String)s);
        }
        if (value instanceof StringBuffer) {
            StringBuffer s = (StringBuffer)value;
            return Convert.StringToInt64((String)s.toString());
        }
        if (value instanceof Double) {
            double d = (Double)value;
            int value2 = (int)d;
            return value2;
        }
        if (value instanceof Float) {
            float f = ((Float)value).floatValue();
            int value2 = (int)f;
            return value2;
        }
        if (value instanceof Long) {
            long l = (Long)value;
            return l;
        }
        if (value instanceof Boolean) {
            boolean b = (Boolean)value;
            int i = b ? 1 : 0;
            return i;
        }
        if (value instanceof Date) {
            return 0L;
        }
        if (value instanceof BigDecimal) {
            BigDecimal d = (BigDecimal)value;
            long value2 = d.toBigInteger().longValue();
            return value2;
        }
        return 0L;
    }
}

