/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.starter.config.bean;

import com.efuture.ocp.common.cache.CacheConfig;
import com.efuture.ocp.common.cache.CacheUtils;
import com.efuture.ocp.common.cache.CacheUtilsInMemory;
import com.efuture.ocp.common.cache.CacheUtilsInMemoryObject;
import com.efuture.ocp.common.cache.CacheUtilsMemcached;
import com.efuture.ocp.common.cache.CacheUtilsRedisCluster;
import com.efuture.ocp.common.cache.CacheUtilsRedisSentinel;
import com.efuture.ocp.common.cache.CacheUtilsRediscached;
import com.efuture.starter.config.bean.CacheProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={CacheProperties.class})
public class CacheConfiguration {
    private CacheProperties properties;

    public CacheConfiguration(CacheProperties properties) {
        this.properties = properties;
    }

    public CacheConfig getCacheConfig() {
        CacheConfig cacheConfig = new CacheConfig();
        cacheConfig.setServerList(this.properties.getServerList());
        cacheConfig.setPoolsize(this.properties.getPoolsize());
        cacheConfig.setRcvbuf(this.properties.getRcvbuf());
        cacheConfig.setSndbuf(this.properties.getSndbuf());
        cacheConfig.setTimeout(this.properties.getTimeout());
        cacheConfig.setMerge(this.properties.getMerge());
        cacheConfig.setHeart(this.properties.isHeart());
        cacheConfig.setRebuild(this.properties.isRebuild());
        cacheConfig.setCachetime(this.properties.getCachetime());
        cacheConfig.setRedisHost(this.properties.getRedisHost());
        cacheConfig.setRedisPort(this.properties.getRedisPort());
        cacheConfig.setRedisMaxActive(this.properties.getRedisMaxActive());
        cacheConfig.setRedisMaxIdle(this.properties.getRedisMaxIdle());
        cacheConfig.setRedisMinIdle(this.properties.getRedisMinIdle());
        cacheConfig.setRedisMaxWait(this.properties.getRedisMaxWait());
        cacheConfig.setRedisTimeout(this.properties.getRedisTimeout());
        cacheConfig.setRedisTestOnBorrow(this.properties.isRedisTestOnBorrow());
        cacheConfig.setRedisPassword(this.properties.getRedisPassword());
        cacheConfig.setRedisDatabase(this.properties.getRedisDatabase());
        cacheConfig.setRedisNodes(this.properties.getRedisNodes());
        cacheConfig.setRedisMaster(this.properties.getRedisMaster());
        cacheConfig.setCompressSize(this.properties.getCompressSize());
        cacheConfig.setRedisMaxAttempts(this.properties.getRedisMaxAttempts());
        cacheConfig.setAutoCache(this.properties.isAutoCache());
        return cacheConfig;
    }

    @Bean(name={"CacheUtils"})
    @ConditionalOnMissingBean(name={"CacheUtils"})
    public CacheUtils CacheUtils() {
        if ("memcached".equalsIgnoreCase(this.properties.getCacheType())) {
            CacheUtilsMemcached cacheUtils = new CacheUtilsMemcached();
            cacheUtils.setConfig(this.getCacheConfig());
            return cacheUtils;
        }
        if ("memory".equalsIgnoreCase(this.properties.getCacheType())) {
            CacheUtilsInMemory cacheUtils = new CacheUtilsInMemory();
            return cacheUtils;
        }
        if ("sentinel".equalsIgnoreCase(this.properties.getCacheType())) {
            CacheUtilsRedisSentinel cacheUtils = new CacheUtilsRedisSentinel();
            cacheUtils.setConfig(this.getCacheConfig());
            return cacheUtils;
        }
        if ("cluster".equalsIgnoreCase(this.properties.getCacheType())) {
            CacheUtilsRedisCluster cacheUtils = new CacheUtilsRedisCluster();
            cacheUtils.setConfig(this.getCacheConfig());
            return cacheUtils;
        }
        CacheUtilsRediscached cacheUtils = new CacheUtilsRediscached();
        cacheUtils.setConfig(this.getCacheConfig());
        return cacheUtils;
    }

    @Bean(name={"CacheInMemory"})
    @ConditionalOnMissingBean(name={"CacheInMemory"})
    public CacheUtils CacheInMemory() {
        CacheUtilsInMemory cacheUtils = new CacheUtilsInMemory();
        return cacheUtils;
    }

    @Bean(name={"CacheInMemoryObject"})
    @ConditionalOnMissingBean(name={"CacheInMemoryObject"})
    public CacheUtils CacheInMemoryObject() {
        CacheUtilsInMemoryObject cacheUtils = new CacheUtilsInMemoryObject();
        return cacheUtils;
    }

    @Bean(name={"CacheRedis"})
    @ConditionalOnMissingBean(name={"CacheRedis"})
    public CacheUtilsRediscached CacheRedis() {
        CacheUtilsRediscached cacheUtils = new CacheUtilsRediscached();
        cacheUtils.setConfig(this.getCacheConfig());
        return cacheUtils;
    }
}

