/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.starter.nacos;

import com.efuture.ocp.common.util.EnviromentUtil;
import com.efuture.ocp.common.util.NetworkUtils;
import com.efuture.starter.nacos.NacosConfig;
import com.efuture.starter.nacos.NacosNaming;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class NacosDiscovery {
    public static boolean nacosDiscoveryEnabled = false;

    public static String getNacosDiscoveryServer() {
        Environment env = EnviromentUtil.getEnv();
        nacosDiscoveryEnabled = (Boolean)env.getProperty("nacos.discovery.enabled", Boolean.class, (Object)true);
        if (!nacosDiscoveryEnabled) {
            return null;
        }
        String nacossvr = env.getProperty("nacos.discovery.server-addr");
        if (StringUtils.isEmpty((Object)nacossvr)) {
            nacossvr = env.getProperty("nacos.config.server-addr");
        }
        return nacossvr;
    }

    public static String getNacosConfigServer() {
        Environment env = EnviromentUtil.getEnv();
        boolean config = (Boolean)env.getProperty("nacos.config.enabled", Boolean.class, (Object)true);
        if (!config) {
            return null;
        }
        String nacossvr = env.getProperty("nacos.config.server-addr");
        return nacossvr;
    }

    public static void NacosServiceRegister() throws Exception {
        String nacossvr = NacosDiscovery.getNacosDiscoveryServer();
        if (!StringUtils.isEmpty((Object)nacossvr)) {
            System.out.println("\u670d\u52a1 " + NacosNaming.getSelfServiceName() + " \u5f53\u524d\u8fd0\u884c\u6a21\u5f0f [" + EnviromentUtil.getProperty((String)"package.type") + "] Enable Nacos Discovery...");
            System.out.println("IP  : " + NetworkUtils.getLocalIP());
            System.out.println("Port: " + NetworkUtils.getLocalPort());
            System.out.println("Ver : " + EnviromentUtil.getProperty((String)"efuture.build.version") + " build " + EnviromentUtil.getProperty((String)"efuture.build.timestamp"));
            if (StringUtils.isEmpty((Object)System.getProperty("project.name"))) {
                System.setProperty("project.name", NacosNaming.getSelfServiceName());
            }
            NacosNaming reg = NacosNaming.createNacosNaming(nacossvr);
            reg.registerInstance();
        }
        if (!StringUtils.isEmpty((Object)(nacossvr = NacosDiscovery.getNacosConfigServer()))) {
            NacosConfig cfg = NacosConfig.createNacosConfig(nacossvr);
            cfg.listenerConfig(EnviromentUtil.getProperty((String)"app.id"), "mall");
        }
    }

    public String selectOneHealthyInstance(String serviceName) throws Exception {
        String nacossvr = NacosDiscovery.getNacosDiscoveryServer();
        if (!StringUtils.isEmpty((Object)nacossvr)) {
            return NacosNaming.getNacosNaming().selectOneHealthyInstance(serviceName);
        }
        return null;
    }
}

