/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.starter.config.ocp;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.efuture.ocp.common.filter.ExecutorWrapper;
import com.efuture.ocp.common.filter.LogMybatisPlugin;
import com.efuture.ocp.common.util.HashMapCase;
import com.github.pagehelper.PageHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.plugin.Interceptor;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.StringUtils;

public abstract class DBConfigAbstract {
    @Autowired
    protected Environment env;
    @Autowired
    protected ResourceLoader resourceLoader = new DefaultResourceLoader();

    protected String getValue(String key, String defaultVal) {
        String val = this.env.getProperty(key);
        if (val == null || val.isEmpty()) {
            return defaultVal;
        }
        return val;
    }

    protected DataSource getDs(String dbkey) {
        Properties props = new Properties();
        String prestr = "efuture.dataSource." + dbkey;
        props.put("driverClassName", this.env.getProperty(prestr + ".driverClassName"));
        props.put("url", this.env.getProperty(prestr + ".url"));
        props.put("username", this.env.getProperty(prestr + ".username"));
        props.put("password", this.env.getProperty(prestr + ".password"));
        props.put("maxActive", this.getValue(prestr + ".maxActive", "50"));
        props.put("maxWait", this.getValue(prestr + ".maxWaitMillis", "60000"));
        props.put("maxIdle", this.getValue(prestr + ".maxIdle", "20"));
        props.put("minIdle", this.getValue(prestr + ".minIdle", "3"));
        props.put("removeAbandoned", this.getValue(prestr + ".removeAbandoned", "true"));
        props.put("removeAbandonedTimeout", this.getValue(prestr + ".removeAbandonedTimeout", "600"));
        props.put("validationQuery", this.env.getProperty(prestr + ".validationQuery"));
        try {
            DruidDataSource datasource = (DruidDataSource)DruidDataSourceFactory.createDataSource((Properties)props);
            datasource.setDbType(this.env.getProperty(prestr + ".dbtype"));
            return datasource;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void setSqlSessionResources(SqlSessionFactoryBean bean, String dbtype, DataSource db, String ... mappers) throws IOException {
        bean.setDataSource(db);
        this.setSqlSessionProperties(bean, dbtype, null);
        this.setSqlSessionAliases(bean, null);
        this.setSqlSessionPlugins(bean, dbtype, null);
        this.setSqlSessionMappers(bean, mappers);
    }

    protected void setSqlSessionProperties(SqlSessionFactoryBean bean, String dbtype, String filename) throws IOException {
        Properties prop = new Properties();
        InputStream in = this.resourceLoader.getClassLoader().getResourceAsStream((String)(StringUtils.isEmpty((Object)filename) ? "sqlfunc_" + dbtype + ".properties" : filename));
        prop.load(in);
        bean.setConfigurationProperties(prop);
    }

    protected void setSqlSessionAliases(SqlSessionFactoryBean bean, List<Class<?>> list) {
        if (list == null) {
            bean.setTypeAliases(new Class[]{HashMapCase.class});
        } else {
            list.add(HashMapCase.class);
            bean.setTypeAliases(list.toArray(new Class[list.size()]));
        }
    }

    protected void setSqlSessionPlugins(SqlSessionFactoryBean bean, String dbtype, List<Interceptor> list) {
        Interceptor[] plugins = new Interceptor[3];
        Properties p0 = new Properties();
        p0.setProperty("dbType", dbtype);
        plugins[0] = new ExecutorWrapper();
        plugins[0].setProperties(p0);
        plugins[1] = new LogMybatisPlugin();
        Properties p2 = new Properties();
        p2.setProperty("offsetAsPageNum", "false");
        p2.setProperty("rowBoundsWithCount", "true");
        p2.setProperty("pageSizeZero", "false");
        plugins[2] = new PageHelper();
        plugins[2].setProperties(p2);
        bean.setPlugins(plugins);
    }

    protected void setSqlSessionMappers(SqlSessionFactoryBean bean, String ... mappers) throws IOException {
        PathMatchingResourcePatternResolver resourceResolver = null;
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(this.resourceLoader.getResource("classpath:mybatis/mybatis-crud.xml"));
        for (int i = 0; mappers != null && i < mappers.length; ++i) {
            if (mappers[i].indexOf("*") > 0) {
                if (resourceResolver == null) {
                    resourceResolver = new PathMatchingResourcePatternResolver();
                }
                Resource[] res = resourceResolver.getResources((String)(mappers[i].indexOf(":") > 0 ? mappers[i] : "classpath*:" + mappers[i]));
                resources.addAll(Arrays.asList(res));
                continue;
            }
            resources.add(this.resourceLoader.getResource((String)(mappers[i].indexOf(":") > 0 ? mappers[i] : "classpath:" + mappers[i])));
        }
        bean.setMapperLocations(resources.toArray(new Resource[resources.size()]));
    }
}

