/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.starter.config.ocp;

import com.alibaba.druid.pool.DruidDataSource;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.omd.storage.FMybatisTemplate;
import com.efuture.starter.config.ocp.DBConfigAbstract;
import com.efuture.starter.config.ocp.DBConfigExtend;
import java.io.IOException;
import javax.sql.DataSource;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@ConditionalOnProperty(prefix="efuture.global", name={"db"})
@Configuration
public class DBGlobConfig
extends DBConfigAbstract {
    @Bean(name={"globalDS"})
    public DataSource onDataSource_glob() {
        return this.getDs(this.env.getProperty("efuture.global.db"));
    }

    @Bean(name={"globalTransactionManager"})
    public DataSourceTransactionManager transactionManager_glob(@Qualifier(value="globalDS") DataSource datasource_glob) throws Exception {
        return new DataSourceTransactionManager(datasource_glob);
    }

    @Bean(name={"globalSqlSessionFactory"})
    public SqlSessionFactoryBean onSqlSessionFactoryBean_glob(@Qualifier(value="globalDS") DataSource datasource_glob) throws IOException {
        SqlSessionFactoryBean service = new SqlSessionFactoryBean();
        String dbtype = ((DruidDataSource)datasource_glob).getDbType();
        DBConfigExtend ext = null;
        if (SpringBeanFactory.containsBean((String)"efuture.global.db.extend")) {
            ext = (DBConfigExtend)SpringBeanFactory.getBean((String)"efuture.global.db.extend", DBConfigExtend.class);
        }
        service.setDataSource(datasource_glob);
        this.setSqlSessionProperties(service, dbtype, null);
        this.setSqlSessionAliases(service, ext != null ? ext.getSqlTypeAliases() : null);
        this.setSqlSessionPlugins(service, dbtype, null);
        this.setSqlSessionMappers(service, ext != null ? ext.getSqlMappers() : null);
        return service;
    }

    @Bean(name={"GlobalStorageOperation"})
    public FMybatisTemplate onFMybatisTemplate_glob(@Qualifier(value="globalSqlSessionFactory") SqlSessionFactory sqlSessionFactory_Glob) {
        return new FMybatisTemplate(sqlSessionFactory_Glob, ExecutorType.BATCH);
    }
}

