/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.starter.config.bean;

import com.efuture.ocp.common.cache.CacheUtils;
import com.efuture.ocp.common.rest.ServiceVersion;
import com.efuture.ocp.common.sysparam.PropertiesCommon;
import com.efuture.ocp.common.sysparam.SystemParamUtil;
import com.efuture.ocp.common.util.RestClientUtils;
import com.efuture.ocp.common.util.UniqueID;
import java.util.HashMap;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="efuture.build", name={"timestamp"})
public class CommonConfig {
    private Logger log = LoggerFactory.getLogger(CommonConfig.class);
    @Value(value="${efuture.build.timestamp}")
    String versiondate;
    @Value(value="${efuture.build.version}")
    String version;
    @Value(value="${efuture.ocmomp.uniqueid.hostid:60}")
    String hostid;
    @Value(value="${efuture.rest.filepath:}")
    String config;
    @Value(value="${efuture.rest.poolSize:60}")
    int rest_poolSize;
    @Value(value="${efuture.rest.maxWait:10000}")
    int maxWait;
    @Value(value="${efuture.rest.connectTimeout:2000}")
    int connectTimeout;
    @Value(value="${efuture.rest.readTimeout:20000}")
    int readTimeout;

    @Bean(name={"ServiceVersion"})
    @ConditionalOnMissingBean(name={"ServiceVersion"})
    public ServiceVersion serviceVersion() {
        String sdf = this.version + " build " + this.versiondate;
        ServiceVersion sv = new ServiceVersion(sdf, "y", "json");
        this.log.info("--------------------------ServiceVersion " + sdf + " init success!-----------------------------------------");
        return sv;
    }

    @Bean(name={"UniqueID"})
    @ConditionalOnMissingBean(name={"UniqueID"})
    public UniqueID uniqueID(@Qualifier(value="CacheUtils") CacheUtils cacheUtils) {
        UniqueID rbm = new UniqueID();
        rbm.setHostId(this.hostid);
        return rbm;
    }

    @Bean(name={"RestUtils"}, initMethod="init")
    @ConditionalOnMissingBean(name={"RestUtils"})
    public RestClientUtils RestUtils() {
        RestClientUtils udrs = new RestClientUtils(this.rest_poolSize, (long)this.maxWait, this.config);
        HashMap<String, Integer> clientProp = new HashMap<String, Integer>();
        clientProp.put("connectTimeout", this.connectTimeout);
        clientProp.put("readTimeout", this.readTimeout);
        udrs.setClientProperties(clientProp);
        return udrs;
    }

    @Bean(name={"PrintCommonParamList"})
    public JSONObject PrintSystemParamListImpl() {
        JSONObject json = new JSONObject();
        json.put((Object)"\u901a\u7528\u57fa\u7840\u914d\u7f6e", (Object)SystemParamUtil.systemParamEnumList((Class[])new Class[]{PropertiesCommon.CONFIG.class, PropertiesCommon.REFERENCE.class}));
        return json;
    }

    @Bean(name={"PrintXxlJobList"})
    public JSONObject PrintXxlJobList() {
        JSONObject json = new JSONObject();
        json.put((Object)"XXLJOB", (Object)SystemParamUtil.xxlJobEnumList());
        return json;
    }
}

