/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.starter.config.bean;

import com.efuture.ocp.common.language.MessageSourceHelper;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.AbstractResourceBasedMessageSource;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;

@Configuration
public class MessageSourceConfiguration {
    @Value(value="${efuture.main.message.lang:cn}")
    private String lang;
    @Value(value="${efuture.main.message.file:classpath:message}")
    private String basename;
    @Value(value="${efuture.main.message.cache:-1}")
    private int cache;
    @Value(value="${efuture.main.message.prior:false}")
    private boolean prior;

    @Bean(name={"messageSource"})
    @ConditionalOnMissingBean(name={"messageSource"})
    public ReloadableResourceBundleMessageSource resourcebundlemessageSource() {
        ReloadableResourceBundleMessageSource rbm = new ReloadableResourceBundleMessageSource();
        rbm.setDefaultEncoding("UTF-8");
        System.out.println("efuture.main.message.lang : " + this.lang);
        System.out.println("efuture.main.message.file : " + this.basename);
        System.out.println("efuture.main.message.cache: " + this.cache);
        System.out.println("efuture.main.message.prior: " + this.prior);
        rbm.setBasename(this.basename);
        rbm.setCacheSeconds(this.cache);
        return rbm;
    }

    @Bean(name={"messageSourceHelper"})
    @ConditionalOnMissingBean(name={"messageSourceHelper"})
    public MessageSourceHelper messageSourceHelper() {
        MessageSourceHelper rbm = new MessageSourceHelper();
        rbm.setMessageSource((AbstractResourceBasedMessageSource)this.resourcebundlemessageSource());
        return rbm;
    }
}

