/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.starter.config.ocp;

import com.alibaba.druid.pool.DruidDataSource;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.omd.storage.FMybatisTemplate;
import com.efuture.starter.config.ocp.DBConfigAbstract;
import com.efuture.starter.config.ocp.DBConfigExtend;
import java.io.IOException;
import javax.sql.DataSource;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@ConditionalOnProperty(prefix="efuture.portal", name={"db"})
@Configuration
public class DBPortalConfig
extends DBConfigAbstract {
    @Bean(name={"portalDS"})
    public DataSource onDataSource_task() {
        return this.getDs(this.env.getProperty("efuture.portal.db"));
    }

    @Bean(name={"transactionManager_portal"})
    public DataSourceTransactionManager transactionManager(@Qualifier(value="portalDS") DataSource datasource) throws Exception {
        return new DataSourceTransactionManager(datasource);
    }

    @Bean(name={"SqlSessionFactory_portal"})
    public SqlSessionFactoryBean onSqlSessionFactoryBean(@Qualifier(value="portalDS") DataSource datasource) throws IOException {
        SqlSessionFactoryBean service = new SqlSessionFactoryBean();
        String dbtype = ((DruidDataSource)datasource).getDbType();
        DBConfigExtend ext = null;
        if (SpringBeanFactory.containsBean((String)"efuture.portal.db.extend")) {
            ext = (DBConfigExtend)SpringBeanFactory.getBean((String)"efuture.portal.db.extend", DBConfigExtend.class);
        }
        service.setDataSource(datasource);
        this.setSqlSessionProperties(service, dbtype, null);
        this.setSqlSessionAliases(service, ext != null ? ext.getSqlTypeAliases() : null);
        this.setSqlSessionPlugins(service, dbtype, null);
        this.setSqlSessionMappers(service, ext != null ? ext.getSqlMappers() : null);
        return service;
    }

    @Bean(name={"StorageOperation_portal"})
    public FMybatisTemplate onFMybatisTemplate(@Qualifier(value="SqlSessionFactory_portal") SqlSessionFactory factory) {
        return new FMybatisTemplate(factory, ExecutorType.BATCH);
    }
}

