/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.starter.nacos;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.efuture.ocp.common.sysparam.PropertiesAware;
import com.efuture.ocp.common.util.EnviromentUtil;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.starter.nacos.NacosDiscovery;
import com.efuture.starter.nacos.NacosNaming;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.springframework.util.StringUtils;

public class NacosConfig {
    static NacosConfig cfg;
    String server;
    String namespace;
    String group;
    Properties prop;

    public NacosConfig(String svr) throws Exception {
        this.server = svr;
        this.namespace = NacosConfig.getNamespace();
        this.group = EnviromentUtil.getProperty((String)"nacos.config.group", (String)"DEFAULT_GROUP");
        this.prop = new Properties();
        this.prop.setProperty("serverAddr", this.server);
        this.prop.setProperty("namespace", this.namespace);
        NacosConfig.checkAuth(this.prop);
    }

    public static NacosConfig createNacosConfig(String svr) throws Exception {
        if (cfg == null) {
            cfg = new NacosConfig(svr);
        }
        return cfg;
    }

    public static NacosConfig getNacosConfig() throws Exception {
        if (cfg == null) {
            throw new Exception("Nacos Config Center not create ...");
        }
        return cfg;
    }

    public static String getNamespace() {
        String name = EnviromentUtil.getProperty((String)"nacos.config.namespace", (String)"public");
        return name;
    }

    private static void checkAuth(Properties prop) {
        boolean auth = (Boolean)EnviromentUtil.getEnv().getProperty("nacos.core.auth.enabled", Boolean.class, (Object)false);
        if (auth) {
            prop.setProperty("username", EnviromentUtil.getProperty((String)"nacos.config.username"));
            prop.setProperty("password", EnviromentUtil.getProperty((String)"nacos.config.password"));
        }
    }

    public void listenerConfig(String ... dataid) throws Exception {
        if (dataid == null || dataid.length <= 0) {
            return;
        }
        final Map as = SpringBeanFactory.getContext().getBeansOfType(PropertiesAware.class);
        if (as == null || as.size() <= 0) {
            return;
        }
        ConfigService configService = NacosFactory.createConfigService((Properties)this.prop);
        for (final String id : dataid) {
            if (StringUtils.isEmpty((Object)id)) continue;
            configService.addListener(id, this.group, new Listener(){

                public void receiveConfigInfo(String configInfo) {
                    System.out.println("recieve1:" + configInfo);
                    Properties prop = NacosConfig.this.convertProperties(configInfo);
                    if (prop != null) {
                        try {
                            String nacossvr;
                            boolean chg;
                            if (prop.containsKey("nacos.discovery.enabled") && NacosDiscovery.nacosDiscoveryEnabled != (chg = Boolean.parseBoolean(prop.getProperty("nacos.discovery.enabled"))) && !StringUtils.isEmpty((Object)(nacossvr = NacosDiscovery.getNacosDiscoveryServer()))) {
                                NacosNaming reg = NacosNaming.createNacosNaming(nacossvr);
                                if (chg) {
                                    reg.registerInstance();
                                } else {
                                    reg.deregisterInstance();
                                }
                            }
                            for (PropertiesAware aware : as.values()) {
                                aware.propertiesChanged(id, prop);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }

                public Executor getExecutor() {
                    return null;
                }
            });
        }
    }

    protected Properties convertProperties(String configInfo) {
        try {
            String line;
            if (StringUtils.isEmpty((Object)configInfo)) {
                return null;
            }
            Properties prop = new Properties();
            BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(configInfo.getBytes())));
            while ((line = br.readLine()) != null) {
                int p;
                if (StringUtils.isEmpty((Object)line) || line.trim().startsWith("#") || (p = line.indexOf("=")) <= 0) continue;
                prop.put(line.substring(0, p).trim(), line.substring(p + 1).trim());
            }
            br.close();
            return prop;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

