/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.billservice;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.annotation.CheckRepeatAnnotation;
import com.efuture.ocp.common.billservice.BillAbstractHeadBean;
import com.efuture.ocp.common.billservice.BillCommonService;
import com.efuture.ocp.common.billservice.BillOperLogService;
import com.efuture.ocp.common.billservice.BillOperLogSrvImpl;
import com.efuture.ocp.common.billservice.MallMessageTemplate;
import com.efuture.ocp.common.billservice.VoucherService;
import com.efuture.ocp.common.bpm.BpmService;
import com.efuture.ocp.common.component.GlobRuleSrv;
import com.efuture.ocp.common.component.MasterSlaveComponent;
import com.efuture.ocp.common.entity.AbstractEntityBean;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.MessageSourceHelper;
import com.efuture.ocp.common.user.UserDataRangeSrv;
import com.efuture.ocp.common.util.HttpUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.common.util.SslUtils;
import com.efuture.ocp.common.util.StorageUtils;
import com.efuture.ocp.common.util.Utils;
import com.efuture.omd.storage.FMybatisTemplate;
import com.efuture.omd.storage.parser.QueryExtractor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.DocumentException;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

public class BillCommonServiceImpl<T extends BillAbstractHeadBean>
extends MasterSlaveComponent<T>
implements BillCommonService {
    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
    private Map<String, String> STATUSNAME = new HashMap<String, String>();
    private BillOperLogService operlog;
    @Autowired
    private GlobRuleSrv globrulesrv;
    @Autowired
    MallMessageTemplate mallMessageTemplate;

    public static BillCommonServiceImpl getInstance() {
        return (BillCommonServiceImpl)SpringBeanFactory.getContext().getBean("bill.common", BillCommonServiceImpl.class);
    }

    @Override
    protected String getMasterSlaveKey() throws IllegalArgumentException, IllegalAccessException {
        return this.getMasterSlaveKey(null);
    }

    @Override
    protected String getMasterSlaveKey(Class<?> cl) throws IllegalArgumentException, IllegalAccessException {
        return (String)AbstractEntityBean.fetchDeclaredField(cl == null ? this.getBeanClass() : cl, "MASTER_SLAVE_KEY").get(null);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public ServiceResponse applybillno(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"moduleid"))) {
            return ServiceResponse.buildFailure(session, "50000", "{0} {1} is empty", "", "moduleid");
        }
        String ruleid = jsonparam.getString("ruleid");
        if (StringUtils.isEmpty((Object)ruleid)) {
            ruleid = "billno";
        }
        int num = 1;
        if (jsonparam.containsKey((Object)"count")) {
            num = jsonparam.getInteger("count");
        }
        JSONObject json = new JSONObject();
        if (num > 1) {
            json.put(ruleid, this.doApplyBillNoBatch(session.getEnt_id(), ruleid, jsonparam.getString("moduleid"), jsonparam.getString("type"), jsonparam.getString("level"), num));
        } else {
            json.put(ruleid, (Object)this.doApplyBillNo(session.getEnt_id(), ruleid, jsonparam.getString("moduleid"), jsonparam.getString("type"), jsonparam.getString("level")));
        }
        return ServiceResponse.buildSuccess(json);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public String doApplyBillNo(long ent_id, String ruleid, String moduleid, String type, String level) {
        List<String> list = this.doApplyBillNoBatch(ent_id, ruleid, moduleid, type, level, 1);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<String> doApplyBillNoBatch(long ent_id, String ruleid, String moduleid, String type, String level, int num) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("moduleid", moduleid);
        List<String> billnolist = this.globrulesrv.doGenRuleCodeBatch(ent_id, ruleid, null, level, num, fields);
        return billnolist;
    }

    protected String getBillNoRuleID(String billmoduleid) {
        return "billno";
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public long doAdd(AbstractEntityBean bean, String id, String ... uniques) throws Exception {
        if (bean instanceof BillAbstractHeadBean) {
            BillAbstractHeadBean bill = (BillAbstractHeadBean)bean;
            if (StringUtils.isEmpty((Object)bill.getBillno()) && !StringUtils.isEmpty((Object)bill.getBillmoduleid())) {
                String ruleid = this.getBillNoRuleID(bill.getBillmoduleid());
                String billno = this.doApplyBillNo(bill.getEnt_id(), ruleid, bill.getBillmoduleid(), null, null);
                bill.setBillno(billno);
                if (!StringUtils.isEmpty((Object)this.getBillKeyField())) {
                    this.getBillKeyField().set(bean, billno);
                }
            }
            if (StringUtils.isEmpty((Object)bill.getBillsgno())) {
                bill.setBillsgno(bill.getBillno());
            }
            bill.setInputdate(new Date());
            bill.setLastmodby(bill.getInputer());
            bill.setLastmodby_name(bill.getInputer_name());
            this.getOperlog().log(bill.getInputer(), bill.getInputer_name(), "\u65b0\u589e", "", bill);
        }
        return super.doAdd(bean, id, uniques);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public Object doDelete(AbstractEntityBean bean, String id, String ... keys) throws Exception {
        if (bean instanceof BillAbstractHeadBean) {
            BillAbstractHeadBean bill = (BillAbstractHeadBean)bean;
            BillAbstractHeadBean oribill = this.checkBillStatus(bill);
            if (!"N".equalsIgnoreCase(oribill.getBillstatus())) {
                throw new ServiceException("10000", "[{0}]\u5355\u636e\u4e0d\u662f\u5f55\u5165\u72b6\u6001\u7684\u5355\u636e,\u4e0d\u80fd\u5220\u9664!", oribill.getBillno());
            }
            this.getOperlog().log("\u5220\u9664", "", bill);
        }
        return super.doDelete(bean, id, keys);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public Object doUpdate(AbstractEntityBean bean, Set<String> keys, String id, String ... uniques) throws Exception {
        if (bean instanceof BillAbstractHeadBean) {
            BillAbstractHeadBean bill = (BillAbstractHeadBean)bean;
            BillAbstractHeadBean oribill = this.checkBillStatus(bill);
            if (!"N".equalsIgnoreCase(oribill.getBillstatus())) {
                throw new ServiceException("10000", "[{0}]\u5355\u636e\u4e0d\u662f\u5f55\u5165\u72b6\u6001\u7684\u5355\u636e,\u4e0d\u80fd\u4fee\u6539!", oribill.getBillno());
            }
            this.getOperlog().log("\u4fee\u6539", "", bill);
        }
        return super.doUpdate(bean, keys, id, uniques);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    protected BillAbstractHeadBean checkBillStatus(BillAbstractHeadBean bill) throws Exception {
        HashSet<String> keys = new HashSet<String>();
        bill.setPh_timestamp(new Date());
        keys.add("ph_timestamp");
        super.doUpdate(bill, keys, "billno", new String[0]);
        JSONObject json = new JSONObject();
        json.put("fields", (Object)"*");
        json.put("ent_id", (Object)bill.getEnt_id());
        json.put("billno", (Object)bill.getBillno());
        BillAbstractHeadBean oribill = (BillAbstractHeadBean)this.doSearchOne(json, this.getBeanClass());
        if (oribill == null) {
            throw new ServiceException("10003", "{0} {1} [{2}] does not exist", MessageSourceHelper.getMessage(bill.fetchAnnotationTableName(), bill.getLang(), new Object[0]), "billno", bill.getBillno());
        }
        return oribill;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    protected BillAbstractHeadBean checkBillStatusNew(BillAbstractHeadBean bill) throws Exception {
        JSONObject json = new JSONObject();
        json.put("fields", (Object)"*");
        json.put("ent_id", (Object)bill.getEnt_id());
        json.put("billno", (Object)bill.getBillno());
        BillAbstractHeadBean oribill = (BillAbstractHeadBean)this.doSearchOne(json, this.getBeanClass());
        if (oribill == null) {
            throw new ServiceException("10003", "{0} {1} [{2}] does not exist", MessageSourceHelper.getMessage(bill.fetchAnnotationTableName(), bill.getLang(), new Object[0]), "billno", bill.getBillno());
        }
        return oribill;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse billaudit(ServiceSession session, JSONObject jsonparam) throws Exception {
        UserDataRangeSrv.setlocalisrange(false);
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"billno"))) {
            return ServiceResponse.buildFailure(session, "50000", "{0} {1} is empty", "", "billno");
        }
        boolean force = false;
        if (jsonparam.containsKey((Object)"force")) {
            force = jsonparam.getBoolean("force");
        }
        BillAbstractHeadBean bean = (BillAbstractHeadBean)StorageUtils.parseBeanObject(jsonparam, this.getBeanClass());
        bean.initUpdateMember(session);
        Object auditdata = this.doBillAudit(bean, session, force);
        this.mallMessageTemplate.generateEventMessage(bean);
        JSONObject json = new JSONObject();
        if (!force && auditdata != null) {
            json.put("data", auditdata);
            json.put("msg", (Object)("[" + jsonparam.get((Object)"billno") + "] \u5355\u636e\u5ba1\u6838\u4e0d\u6210\u529f,\u9700\u518d\u6b21\u786e\u8ba4!"));
        } else {
            json.put("msg", (Object)("[" + jsonparam.get((Object)"billno") + "] \u5355\u636e\u5ba1\u6838\u6210\u529f!"));
        }
        return ServiceResponse.buildSuccess(json);
    }

    protected Set<String> beforeBillAudit(BillAbstractHeadBean bill) throws Exception {
        if ("WAITTING".equalsIgnoreCase(bill.getBillsgno())) {
            bill.setBillstatus("W");
        }
        return null;
    }

    protected void bizBillAudit(BillAbstractHeadBean bill) throws Exception {
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Object doBillAudit(BillAbstractHeadBean bill, ServiceSession session, boolean force) throws Exception {
        BillAbstractHeadBean oribill = this.checkBillStatus(bill);
        String status = null;
        try {
            Map<String, Object> billmain = this.getbillmain(oribill);
            status = StringUtils.isEmpty((Object)billmain.get("billwfstartflag")) ? "N" : billmain.get("billwfstartflag").toString();
        }
        catch (Exception e) {
            status = "N";
        }
        if ("Y".equalsIgnoreCase(oribill.getBillstatus())) {
            throw new ServiceException("10000", "[{0}]\u5355\u636e\u5df2\u5ba1\u6838,\u4e0d\u80fd\u91cd\u590d\u5ba1\u6838!", oribill.getBillno());
        }
        if (!status.equalsIgnoreCase(oribill.getBillstatus())) {
            if ("W".equalsIgnoreCase(oribill.getBillstatus()) && !"asyncaudit".equalsIgnoreCase(bill.getBillsgno())) {
                throw new ServiceException("10000", "[{0}]\u5355\u636e\u5df2\u5ba1\u6838,\u4e0d\u80fd\u91cd\u590d\u5ba1\u6838!", oribill.getBillno());
            }
            if (!("W".equalsIgnoreCase(oribill.getBillstatus()) && "asyncaudit".equalsIgnoreCase(bill.getBillsgno()) || "A".equalsIgnoreCase(oribill.getBillstatus()))) {
                throw new ServiceException("10000", "[{0}]\u5355\u636e\u4e0d\u662f\u5f85\u5ba1\u6838\u5355\u636e,\u4e0d\u80fd\u5ba1\u6838!", oribill.getBillno());
            }
        }
        bill.setBillmoduleid(oribill.getBillmoduleid());
        bill.setBillstatus(null);
        if (StringUtils.isEmpty((Object)bill.getBillstatus()) || "N".equalsIgnoreCase(bill.getBillstatus())) {
            bill.setBillstatus("Y");
        }
        if (StringUtils.isEmpty((Object)bill.getAuditor()) && session != null) {
            bill.setAuditor(session.getUser_code());
        }
        if (StringUtils.isEmpty((Object)bill.getAuditor_name()) && session != null) {
            bill.setAuditor_name("[" + session.getUser_code() + "]" + session.getUser_name());
        }
        bill.setAuditdate(new Date());
        bill.setLastmodby(bill.getAuditor());
        bill.setLastmodby_name(bill.getAuditor_name());
        Set<String> keys = this.beforeBillAudit(bill);
        this.bizBillAudit(bill);
        if (keys == null) {
            keys = new HashSet<String>();
        }
        keys.add("billstatus");
        keys.add("ph_timestamp");
        keys.add("lastmodby");
        keys.add("lastmodby_name");
        keys.add("auditor");
        keys.add("auditor_name");
        keys.add("auditdate");
        super.doUpdate(bill, keys, "billno", new String[0]);
        this.afterBillAudit(bill);
        this.doGenerateVoucher(bill, "BillAudit");
        if (!force) {
            this.getOperlog().log(bill.getAuditor(), bill.getAuditor_name(), "\u5ba1\u6838", "", bill);
        }
        return null;
    }

    protected void afterBillAudit(BillAbstractHeadBean bill) throws Exception {
    }

    public void doGenerateVoucher(BillAbstractHeadBean bill, String methodName) throws Exception {
        VoucherService voucherService = null;
        try {
            voucherService = SpringBeanFactory.getBean("mss.base.voucher", VoucherService.class);
        }
        catch (Exception e) {
            return;
        }
        voucherService.doGenByBill(bill.getEnt_id(), bill.getBillno(), bill.billmoduleid, methodName);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse billcancel(ServiceSession session, JSONObject jsonparam) throws Exception {
        UserDataRangeSrv.setlocalisrange(false);
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"billno"))) {
            return ServiceResponse.buildFailure(session, "50000", "{0} {1} is empty", "", "billno");
        }
        boolean force = false;
        if (jsonparam.containsKey((Object)"force")) {
            force = jsonparam.getBoolean("force");
        }
        BillAbstractHeadBean bean = (BillAbstractHeadBean)StorageUtils.parseBeanObject(jsonparam, this.getBeanClass());
        bean.initUpdateMember(session);
        Object canceldata = this.doBillCancel(bean, session, force);
        JSONObject json = new JSONObject();
        if (!force && canceldata != null) {
            json.put("data", canceldata);
            json.put("msg", (Object)("[" + jsonparam.get((Object)"billno") + "] \u5355\u636e\u53d6\u6d88\u4e0d\u6210\u529f,\u9700\u518d\u6b21\u786e\u8ba4!"));
        } else {
            json.put("msg", (Object)("[" + jsonparam.get((Object)"billno") + "] \u5355\u636e\u53d6\u6d88\u6210\u529f!"));
        }
        return ServiceResponse.buildSuccess(json);
    }

    protected Set<String> beforeBillCancel(BillAbstractHeadBean bill) throws Exception {
        if ("WAITTING".equalsIgnoreCase(bill.getBillsgno())) {
            bill.setBillstatus("W");
        }
        return null;
    }

    public void checkBillCancel(ServiceSession session, BillAbstractHeadBean oribill) {
        if ("C".equalsIgnoreCase(oribill.getBillstatus())) {
            throw new ServiceException("10000", "[{0}]\u5355\u636e\u5df2\u53d6\u6d88,\u4e0d\u80fd\u91cd\u590d\u53d6\u6d88!", oribill.getBillno());
        }
        if (!"Y".equalsIgnoreCase(oribill.getBillstatus())) {
            throw new ServiceException("10000", "[{0}]\u5355\u636e\u4e0d\u662f\u5df2\u5ba1\u6838\u5355\u636e,\u4e0d\u80fd\u53d6\u6d88!", oribill.getBillno());
        }
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Object doBillCancel(BillAbstractHeadBean bill, ServiceSession session, boolean force) throws Exception {
        BillAbstractHeadBean oribill = this.checkBillStatus(bill);
        this.checkBillCancel(session, oribill);
        bill.setBillmoduleid(oribill.getBillmoduleid());
        bill.setBillstatus(null);
        Set<String> keys = this.beforeBillCancel(bill);
        this.bizBillCancel(bill);
        if (StringUtils.isEmpty((Object)bill.getBillstatus()) || "Y".equalsIgnoreCase(bill.getBillstatus())) {
            bill.setBillstatus("C");
        }
        if (StringUtils.isEmpty((Object)bill.getCanceler()) && session != null && session.getUser_code() != null) {
            bill.setCanceler(session.getUser_code());
        }
        if (StringUtils.isEmpty((Object)bill.getCanceler_name()) && session != null && session.getUser_name() != null) {
            bill.setCanceler_name("[" + session.getUser_code() + "]" + session.getUser_name());
        }
        bill.setCanceldate(new Date());
        bill.setLastmodby(bill.getCanceler());
        bill.setLastmodby_name(bill.getCanceler_name());
        if (keys == null) {
            keys = new HashSet<String>();
        }
        keys.add("billstatus");
        keys.add("ph_timestamp");
        keys.add("lastmodby");
        keys.add("lastmodby_name");
        keys.add("canceler");
        keys.add("canceler_name");
        keys.add("canceldate");
        super.doUpdate(bill, keys, "billno", new String[0]);
        this.getOperlog().log(bill.getCanceler(), bill.getCanceler_name(), "\u53d6\u6d88", "", bill);
        this.afterBillCancel(bill);
        this.doGenerateVoucher(bill, "BillCancel");
        return null;
    }

    protected void bizBillCancel(BillAbstractHeadBean bill) throws Exception {
    }

    protected void afterBillCancel(BillAbstractHeadBean bill) throws Exception {
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse billvoid(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"billno"))) {
            return ServiceResponse.buildFailure(session, "50000", "{0} {1} is empty", "", "billno");
        }
        boolean force = false;
        if (jsonparam.containsKey((Object)"force")) {
            force = jsonparam.getBoolean("force");
        }
        BillAbstractHeadBean bean = (BillAbstractHeadBean)StorageUtils.parseBeanObject(jsonparam, this.getBeanClass());
        bean.initUpdateMember(session);
        Object voiddata = this.doBillVoid(bean, session, force);
        this.doGenerateVoucher(bean, "BillVoid");
        JSONObject json = new JSONObject();
        if (!force && voiddata != null) {
            json.put("data", voiddata);
            json.put("msg", (Object)("[" + jsonparam.get((Object)"billno") + "] \u5355\u636e\u4f5c\u5e9f\u4e0d\u6210\u529f,\u9700\u518d\u6b21\u786e\u8ba4!"));
        } else {
            json.put("msg", (Object)("[" + jsonparam.get((Object)"billno") + "] \u5355\u636e\u4f5c\u5e9f\u6210\u529f!"));
        }
        return ServiceResponse.buildSuccess(json);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Object doBillVoid(BillAbstractHeadBean bill, ServiceSession session, boolean force) throws Exception {
        BillAbstractHeadBean oribill = this.checkBillStatus(bill);
        if ("C".equalsIgnoreCase(oribill.getBillstatus())) {
            throw new ServiceException("10000", "[{0}]\u5355\u636e\u5df2\u4f5c\u5e9f,\u4e0d\u80fd\u91cd\u590d\u4f5c\u5e9f!", oribill.getBillno());
        }
        if (!"Y".equalsIgnoreCase(oribill.getBillstatus())) {
            throw new ServiceException("10000", "[{0}]\u5355\u636e\u4e0d\u662f\u5df2\u5ba1\u6838\u5355\u636e,\u4e0d\u80fd\u4f5c\u5e9f!", oribill.getBillno());
        }
        bill.setBillmoduleid(oribill.getBillmoduleid());
        bill.setBillstatus(null);
        Set<String> keys = this.beforeBillVoid(bill);
        if (StringUtils.isEmpty((Object)bill.getBillstatus()) || "Y".equalsIgnoreCase(bill.getBillstatus())) {
            bill.setBillstatus("C");
        }
        if (StringUtils.isEmpty((Object)bill.getCanceler()) && session != null) {
            bill.setCanceler(session.getUser_code());
        }
        if (StringUtils.isEmpty((Object)bill.getCanceler_name()) && session != null) {
            bill.setCanceler_name("[" + session.getUser_code() + "]" + session.getUser_name());
        }
        bill.setCanceldate(new Date());
        bill.setLastmodby(bill.getCanceler());
        bill.setLastmodby_name(bill.getCanceler_name());
        if (keys == null) {
            keys = new HashSet<String>();
        }
        keys.add("billstatus");
        keys.add("ph_timestamp");
        keys.add("lastmodby");
        keys.add("lastmodby_name");
        keys.add("canceler");
        keys.add("canceler_name");
        keys.add("canceldate");
        super.doUpdate(bill, keys, "billno", new String[0]);
        this.getOperlog().log(bill.getCanceler(), bill.getCanceler_name(), "\u4f5c\u5e9f", "", bill);
        this.afterBillVoid(bill);
        return null;
    }

    protected Set<String> beforeBillVoid(BillAbstractHeadBean bill) throws Exception {
        if ("WAITTING".equalsIgnoreCase(bill.getBillsgno())) {
            bill.setBillstatus("W");
        }
        return null;
    }

    protected void afterBillVoid(BillAbstractHeadBean bill) throws Exception {
    }

    @Override
    protected List<?> doGet(JSONObject jsonparam, Class<?> objClass, StringBuffer total) throws Exception {
        if (!(jsonparam == null || StringUtils.isEmpty((Object)jsonparam.getString("mktid")) && StringUtils.isEmpty((Object)jsonparam.getString("chid")))) {
            JSONObject json;
            Field mktfld = AbstractEntityBean.fetchDeclaredField(objClass, "billmktdetail");
            Field chlfld = AbstractEntityBean.fetchDeclaredField(objClass, "billchanneldetail");
            if (mktfld != null && !StringUtils.isEmpty((Object)jsonparam.get((Object)"mktid"))) {
                Object mktobj = jsonparam.get((Object)"mktid");
                jsonparam.remove((Object)"mktid");
                if (mktobj instanceof JSONObject) {
                    jsonparam.put("billmktdetail:mktid", mktobj);
                } else {
                    json = new JSONObject();
                    json.put("$in", (Object)(mktobj + ",%"));
                    jsonparam.put("billmktdetail:mktid", (Object)json);
                }
            }
            if (chlfld != null && !StringUtils.isEmpty((Object)jsonparam.get((Object)"chid"))) {
                Object chlobj = jsonparam.get((Object)"chid");
                jsonparam.remove((Object)"chid");
                if (chlobj instanceof JSONObject) {
                    jsonparam.put("billchanneldetail:chid", chlobj);
                } else {
                    json = new JSONObject();
                    json.put("$in", (Object)(chlobj + ",%"));
                    jsonparam.put("billchanneldetail:chid", (Object)json);
                }
            }
        }
        return super.doGet(jsonparam, objClass, total);
    }

    public BillOperLogService getOperlog() {
        if (this.operlog == null) {
            this.operlog = BillOperLogSrvImpl.getLog();
        }
        return this.operlog;
    }

    public void setOperlog(BillOperLogService operlog) {
        this.operlog = operlog;
    }

    protected Field getBillKeyField() throws IllegalArgumentException, IllegalAccessException {
        if (!StringUtils.isEmpty((Object)this.getBillKey())) {
            Field idfld = AbstractEntityBean.fetchDeclaredField(this.getBeanClass(), this.getBillKey());
            return idfld;
        }
        return null;
    }

    protected String getBillKey() throws IllegalArgumentException, IllegalAccessException {
        return this.getBillKey(null);
    }

    protected String getBillKey(Class<?> cl) throws IllegalArgumentException, IllegalAccessException {
        Field fld = AbstractEntityBean.fetchDeclaredField(cl == null ? this.getBeanClass() : cl, "BILL_KEY");
        if (fld == null) {
            return null;
        }
        return (String)fld.get(null);
    }

    @Override
    @CheckRepeatAnnotation(KeyArgIndex=1, KeyName="billno")
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse billsubmit(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"billno"))) {
            return ServiceResponse.buildFailure(session, "50000", "{0} {1} is empty", "", "billno");
        }
        BillAbstractHeadBean bean = (BillAbstractHeadBean)StorageUtils.parseBeanObject(jsonparam, this.getBeanClass());
        String comment = "";
        if (!StringUtils.isEmpty((Object)jsonparam.get((Object)"comment"))) {
            comment = jsonparam.getString("comment");
        }
        Object submitdata = this.dobillsubmit(bean, session, StringUtils.isEmpty((Object)jsonparam.get((Object)"cc")) ? null : (List)jsonparam.get((Object)"cc"), comment);
        JSONObject json = new JSONObject();
        json.put("msg", (Object)("[" + jsonparam.get((Object)"billno") + "] \u5355\u636e\u63d0\u4ea4\u6210\u529f!"));
        return ServiceResponse.buildSuccess(json);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse billapproveforthird(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"billno"))) {
            return ServiceResponse.buildFailure(session, "50000", "{0}\u4e3a\u7a7a", "", "billno");
        }
        BillAbstractHeadBean bean = (BillAbstractHeadBean)StorageUtils.parseBeanObject(jsonparam, this.getBeanClass());
        this.dobillthirdbpmexec(bean, "A", session, jsonparam.getString("billislast"));
        JSONObject jsonrtn = new JSONObject();
        jsonrtn.put("msg", (Object)("\u5355\u636e [" + jsonparam.get((Object)"billno") + "] \u5ba1\u6838\u6210\u529f!"));
        return ServiceResponse.buildSuccess(jsonrtn);
    }

    @Override
    public ServiceResponse getTaskByStarter(ServiceSession session, JSONObject jsonparam) throws Exception {
        HashMap<String, Object> bpmdata = new HashMap<String, Object>();
        bpmdata.put("userid", session.getUser_code());
        ServiceResponse resp = BpmService.getBpmService().getTaskByStarter(bpmdata);
        return resp;
    }

    @Override
    public ServiceResponse getTaskByApprover(ServiceSession session, JSONObject jsonparam) throws Exception {
        HashMap<String, Object> bpmdata = new HashMap<String, Object>();
        bpmdata.put("userid", session.getUser_code());
        ServiceResponse resp = BpmService.getBpmService().getTaskByApprover(bpmdata);
        return resp;
    }

    @Override
    public ServiceResponse getTaskByCc(ServiceSession session, JSONObject jsonparam) throws Exception {
        HashMap<String, Object> bpmdata = new HashMap<String, Object>();
        bpmdata.put("userid", session.getUser_code());
        ServiceResponse resp = BpmService.getBpmService().getTaskByCc(bpmdata);
        return resp;
    }

    @Override
    public ServiceResponse getTaskListByApprover(ServiceSession session, JSONObject jsonparam) throws Exception {
        HashMap<String, Object> bpmdata = new HashMap<String, Object>();
        bpmdata.put("userid", session.getUser_code());
        ServiceResponse resp = BpmService.getBpmService().getTaskListByApprover(bpmdata);
        return resp;
    }

    public String getprocessdefkey(BillAbstractHeadBean bill) {
        String[] s;
        FMybatisTemplate fs = this.getStorageOperations(FMybatisTemplate.class);
        Criteria criteria = Criteria.where((String)"modeid").is((Object)bill.getBillmoduleid());
        Query q = new Query((CriteriaDefinition)criteria);
        q.limit(1);
        q.fields().include("billisworkflow");
        Map billmain = fs.selectOne(q, "billmain");
        String processdefkey = "BPM" + bill.getBillmoduleid();
        if (billmain != null && !StringUtils.isEmpty(billmain.get("billisworkflow")) && (s = billmain.get("billisworkflow").toString().split("\\|")).length > 1) {
            processdefkey = s[1];
        }
        return processdefkey;
    }

    public Map<String, Object> getbillmain(BillAbstractHeadBean bill) {
        FMybatisTemplate fs = this.getStorageOperations(FMybatisTemplate.class);
        Criteria criteria = Criteria.where((String)"modeid").is((Object)bill.getBillmoduleid());
        Query q = new Query((CriteriaDefinition)criteria);
        q.limit(1);
        Map billmain = null;
        try {
            billmain = fs.selectOne(q, "billmain");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return billmain;
    }

    public JSONObject getbpmvariable(BillAbstractHeadBean bill, ServiceSession session) {
        JSONObject obj = (JSONObject)Utils.toNormalJSONObject(bill);
        if (!StringUtils.isEmpty((Object)session.getRoleid())) {
            obj.put("roleid", (Object)session.getRoleid());
        }
        if (!StringUtils.isEmpty((Object)session.getRolecode())) {
            obj.put("rolecode", (Object)session.getRolecode());
        }
        if (!StringUtils.isEmpty((Object)session.getPostid())) {
            obj.put("postid", (Object)session.getPostid());
        } else if (!StringUtils.isEmpty((Object)session.getStationId())) {
            obj.put("postid", (Object)session.getStationId());
        }
        return obj;
    }

    public Object getmuid(BillAbstractHeadBean bill, ServiceSession session) {
        Object muid = null;
        try {
            muid = AbstractEntityBean.fetchDeclaredField(bill.getClass(), "muid").get(bill);
        }
        catch (Exception e) {
            muid = session.getDeptcode();
            e.printStackTrace();
        }
        return muid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getbpminfo(BillAbstractHeadBean bill, ServiceSession session, boolean getvariable, String billstatus) throws DocumentException, NumberFormatException, ParseException {
        bill.setBillstatus(billstatus);
        HashMap<String, Object> rtn = new HashMap<String, Object>();
        String processdefkey = this.getprocessdefkey(bill);
        if ("WYC".equalsIgnoreCase(processdefkey)) {
            FMybatisTemplate storage = this.getStorageOperations(FMybatisTemplate.class);
            try {
                try {
                    SslUtils.ignoreSsl();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String workconfig = "dbusrpub.workflagtable";
                Sort order = new Sort(Sort.Direction.ASC, new String[]{"rowno"});
                Criteria criteria = Criteria.where((String)"billmoduleid").is((Object)bill.getBillmoduleid());
                Query query = new Query((CriteriaDefinition)criteria);
                query.with(order);
                List map = storage.select(query, workconfig);
                if (map == null || map.size() == 0) {
                    throw new ServiceException("10000", "\u5355\u636e\u6a21\u5757\u672a\u5b9a\u4e49\u5de5\u4f5c\u6d41\u63d0\u4ea4\u4fe1\u606f\u3010workflagtable\u3011\u914d\u7f6e!", new Object[0]);
                }
                JSONObject jsonpara = new JSONObject();
                String sheet = "";
                String billdets = "";
                for (Map worktable : map) {
                    String colsql = worktable.get("colsql").toString();
                    String sql = colsql.replace("{billno}", bill.getBillno()).replace("{ent_id}", String.valueOf(bill.getEnt_id()));
                    HashMap<String, String> para = new HashMap<String, String>();
                    para.put("value", sql);
                    List colvalues = storage.getSqlSessionTemplate().selectList("mybatis.sql.select", para);
                    if (worktable.get("rowno").toString().equalsIgnoreCase("0")) {
                        sheet = ((Map)colvalues.get(0)).get("value").toString();
                        Map utc = (Map)storage.getSqlSessionTemplate().selectOne("mybatis.sql.select_UNIX_TIMESTAMP");
                        String utctime = utc.get("utctime").toString();
                        sheet = sheet + ",\"submiter\":\"[" + session.getUser_code() + "]" + session.getUser_name() + "\"";
                        continue;
                    }
                    String colname = worktable.get("colname").toString();
                    String billdet = "[" + colname + "]";
                    for (Map det : colvalues) {
                        billdet = billdet + ",[" + det.get("value").toString() + "]";
                    }
                    if (billdets.isEmpty() || billdets == "") {
                        billdets = "[" + billdet + "]";
                        continue;
                    }
                    billdets = billdets + ",[" + billdet + "]";
                }
                sheet = "{" + sheet + ",\"sheetDetail\":\"[" + billdets + "]\"}";
                rtn.put("sheet", sheet);
                rtn.put("processdefkey", processdefkey);
                Criteria cri = Criteria.where((String)"1=1");
                Query queryt = new Query((CriteriaDefinition)cri);
                Map token = storage.selectOne(queryt, "workflagtoken");
                double expired = Double.parseDouble(token.get("expires_in").toString());
                String lasttime = token.get("lasttime").toString();
                String curtime = this.sdf.format(new Date());
                String auth = null;
                if (this.DiffDate(curtime, lasttime) < expired) {
                    String tokenurl = token.get("url").toString();
                    String authorization = token.get("authorization").toString();
                    String tokenkey = token.get("tokenkey").toString();
                    try {
                        HashMap<String, String> paramap = new HashMap<String, String>();
                        paramap.put("username", token.get("username").toString());
                        paramap.put("password", token.get("password").toString());
                        paramap.put("grant_type", token.get("grant_type").toString());
                        String[] rtnfields = new String[]{"access_token", "expires_in"};
                        JSONObject tokenjson = HttpUtils.postRequestWithAuthorization(tokenurl, paramap, authorization, rtnfields);
                        String tokenvalue = tokenjson.getString("access_token");
                        Integer expires_in = Integer.valueOf(tokenjson.getString("expires_in"));
                        Update updaterun = new Update();
                        updaterun.set("token", (Object)tokenvalue);
                        updaterun.set("expires_in", (Object)expires_in);
                        updaterun.set("lasttime", (Object)curtime);
                        Criteria criteriarun = Criteria.where((String)"1=1");
                        Query queryrun = new Query((CriteriaDefinition)criteriarun);
                        storage.update(queryrun, updaterun, "workflagtoken");
                        auth = tokenkey + tokenvalue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        this.getLogger().info((Object)("bpm token errors:" + e.getMessage()));
                    }
                } else {
                    auth = token.get("tokenkey").toString() + token.get("token").toString();
                }
                rtn.put("auth", auth);
            }
            finally {
                if (storage != null) {
                    storage.destroy();
                }
            }
        }
        rtn.put("processdefkey", processdefkey);
        rtn.put("billid", bill.getBillno());
        rtn.put("billno", bill.getBillno());
        rtn.put("userid", session.getUser_code());
        Object muid = null;
        if (billstatus.equalsIgnoreCase("A") || billstatus.equalsIgnoreCase("R")) {
            muid = session.getDeptcode();
        } else {
            String billsource = null;
            try {
                billsource = AbstractEntityBean.fetchDeclaredField(bill.getClass(), "billsource").get(bill) == null ? "MSS" : AbstractEntityBean.fetchDeclaredField(bill.getClass(), "billsource").get(bill);
            }
            catch (Exception e) {
                billsource = "MSS";
            }
            muid = billsource.toString().equalsIgnoreCase("APP") ? this.getmuid(bill, session) : session.getDeptcode();
        }
        rtn.put("unitcode", muid);
        if (!StringUtils.isEmpty((Object)session.getPostid())) {
            rtn.put("positionid", session.getPostid());
        } else if (!StringUtils.isEmpty((Object)session.getStationId())) {
            rtn.put("positionid", session.getStationId());
        }
        rtn.put("billimoduleid", bill.getBillmoduleid());
        System.out.println("\u5ba1\u6279\u6d41\u53c2\u6570:" + ((Object)rtn).toString());
        if (getvariable) {
            JSONObject info = this.getbpmvariable(bill, session);
            info.put("billstatus", (Object)billstatus);
            rtn.put("variable", this.getbpmvariable(bill, session));
        }
        return rtn;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    @Transactional(propagation=Propagation.REQUIRED)
    public Object dobillsubmit(BillAbstractHeadBean bill, ServiceSession session, List<String> cc, String comment) throws Exception {
        String status;
        bill.initUpdateMember(session);
        BillAbstractHeadBean oribill = this.checkBillStatusNew(bill);
        Map<String, Object> billmain = this.getbillmain(oribill);
        String string = status = StringUtils.isEmpty((Object)billmain.get("billwfstartflag")) ? "N" : billmain.get("billwfstartflag").toString();
        if ("S".equalsIgnoreCase(oribill.getBillstatus())) {
            throw new ServiceException("10000", "[{0}]\u5355\u636e\u63d0\u4ea4,\u4e0d\u80fd\u91cd\u590d\u63d0\u4ea4!", oribill.getBillno());
        }
        if (!status.equalsIgnoreCase(oribill.getBillstatus())) {
            throw new ServiceException("10000", "[{0}]\u5355\u636e\u4e0d\u662f\u672a\u63d0\u4ea4\u72b6\u6001,\u4e0d\u80fd\u63d0\u4ea4!", oribill.getBillno());
        }
        bill.setBillmoduleid(oribill.getBillmoduleid());
        bill.setBillstatus("S");
        bill.setLastmodby(Utils.nvl(session.getUser_code(), oribill.getInputer()));
        bill.setLastmodby_name("[" + Utils.nvl(session.getUser_code(), oribill.getInputer()) + "]" + Utils.nvl(session.getUser_name(), oribill.getInputer_name()));
        HashSet<String> keys = null;
        if (this.isOracle().booleanValue()) {
            try {
                BillCommonServiceImpl.getInstance().prebillapproval(bill);
            }
            catch (ServiceException ex) {
                if (!ex.getErrorCode().equalsIgnoreCase("0")) throw ex;
            }
        } else {
            this.prebillapprovalcheck(bill);
        }
        Map<String, Object> bpminfo = this.getbpminfo(oribill, session, true, "S");
        if (!StringUtils.isEmpty(cc) && cc.size() > 0) {
            bpminfo.put("cc", cc);
        }
        if (!StringUtils.isEmpty((Object)comment)) {
            bpminfo.put("comment", comment);
        }
        BpmService.getBpmService().submit(bpminfo);
        if (keys == null) {
            keys = new HashSet<String>();
        }
        keys.add("billstatus");
        keys.add("ph_timestamp");
        keys.add("lastmodby");
        keys.add("lastmodby_name");
        super.doUpdate(oribill, keys, "billno", new String[0]);
        this.getOperlog().log(bill.getLastmodby(), bill.getLastmodby_name(), "\u63d0\u4ea4", "", bill);
        Set<String> postkeys = this.PostBillsubmit(session, oribill);
        return null;
    }

    public Set<String> PostBillsubmit(ServiceSession session, BillAbstractHeadBean bill) {
        Map<String, Object> billmain = this.getbillmain(bill);
        if (billmain == null) {
            return null;
        }
        if (!StringUtils.isEmpty((Object)billmain.get("billbpmdesr"))) {
            String[] fileds = billmain.get("billbpmdesr").toString().split(",");
            HashMap<String, String> para = new HashMap<String, String>();
            para.put("procdefkey_", this.getprocessdefkey(bill));
            para.put("procinstkey_", bill.getBillno());
            para.put("fields", billmain.get("billbpmdesr").toString());
            SqlSessionTemplate db = this.getStorageOperations(FMybatisTemplate.class).getSqlSessionTemplate();
            List list = db.selectList("select_bpmfieldvar", para);
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 0; i < list.size(); ++i) {
                map.put(((Map)list.get(i)).get("name_").toString(), ((Map)list.get(i)).get("text_").toString());
            }
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < fileds.length; ++i) {
                if (StringUtils.isEmpty(map.get(fileds[i].replaceAll("'", "")))) continue;
                sb.append((String)map.get(fileds[i].replaceAll("'", "")));
            }
            if (!StringUtils.isEmpty((Object)sb.toString())) {
                para.put("description_", sb.toString());
                db.update("upt_billbpmdesc", para);
            }
        }
        return null;
    }

    public Set<String> beforeBillsubmit(ServiceSession session, BillAbstractHeadBean bill) {
        return null;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse billsaveandsubmit(ServiceSession session, JSONObject jsonparam) throws Exception {
        ServiceResponse sre = this.add(session, jsonparam.toJSONString());
        if (!sre.getReturncode().equals("0")) {
            return sre;
        }
        JSONObject rtn = (JSONObject)sre.getData();
        long id = (Long)rtn.get((Object)this.getIdKey());
        JSONObject json = new JSONObject();
        json.put("fields", (Object)"*");
        json.put("ent_id", (Object)session.getEnt_id());
        json.put(this.getIdKey(), (Object)id);
        BillAbstractHeadBean oribill = (BillAbstractHeadBean)this.doSearchOne(json, this.getBeanClass());
        try {
            this.dobillsubmit(oribill, session, StringUtils.isEmpty((Object)jsonparam.get((Object)"cc")) ? null : (List)jsonparam.get((Object)"cc"), "");
        }
        catch (Exception e) {
            this.doDelete(oribill, "ph_key", new String[0]);
            return ServiceResponse.buildFailure(session, "10000", "\u63d0\u4ea4\u5ba1\u6279\u9519\u8bef:{0}", e.getMessage());
        }
        JSONObject jsonrtn = new JSONObject();
        jsonrtn.put(this.getIdKey(), (Object)id);
        jsonrtn.put("billno", (Object)oribill.getBillno());
        jsonrtn.put("msg", (Object)"\u5355\u636e\u63d0\u4ea4\u6210\u529f!");
        return ServiceResponse.buildSuccess(jsonrtn);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    @CheckRepeatAnnotation(KeyArgIndex=1, KeyName="billno")
    public ServiceResponse billapproval(ServiceSession session, JSONObject jsonparam) throws Exception {
        return this.billbpmexec(session, jsonparam, "A");
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    @CheckRepeatAnnotation(KeyArgIndex=1, KeyName="billno")
    public ServiceResponse billreject(ServiceSession session, JSONObject jsonparam) throws Exception {
        return this.billbpmexec(session, jsonparam, "R");
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    @CheckRepeatAnnotation(KeyArgIndex=1, KeyName="billno")
    public ServiceResponse billrepeal(ServiceSession session, JSONObject jsonparam) throws Exception {
        return this.billbpmexec(session, jsonparam, "N");
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse billbpmexec(ServiceSession session, JSONObject jsonparam, String billstatus) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"billno"))) {
            return ServiceResponse.buildFailure(session, "50000", "{0} {1} is empty", "", "billno");
        }
        BillAbstractHeadBean bean = (BillAbstractHeadBean)StorageUtils.parseBeanObject(jsonparam, this.getBeanClass());
        this.dobillbpmexec(bean, jsonparam.getString("comment"), jsonparam.getString("taskid"), billstatus, session, jsonparam);
        JSONObject jsonrtn = new JSONObject();
        jsonrtn.put("msg", (Object)("\u5355\u636e [" + jsonparam.get((Object)"billno") + "] " + this.getstatusname(billstatus) + "\u6210\u529f!"));
        return ServiceResponse.buildSuccess(jsonrtn);
    }

    public String getstatusname(String billstatus) {
        if (this.STATUSNAME.size() <= 0) {
            this.STATUSNAME.put("N", "\u64a4\u9500");
            this.STATUSNAME.put("A", "\u5ba1\u6279");
            this.STATUSNAME.put("S", "\u63d0\u4ea4");
            this.STATUSNAME.put("R", "\u9a73\u56de");
            this.STATUSNAME.put("J", "\u52a0\u7b7e");
        }
        return this.STATUSNAME.get(billstatus);
    }

    @Override
    public ServiceResponse gettask(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"billno"))) {
            return ServiceResponse.buildFailure(session, "50000", "{0} {1} is empty", "", "billno");
        }
        JSONObject json = new JSONObject();
        json.put("fields", (Object)"*");
        json.put("ent_id", (Object)session.getEnt_id());
        json.put("billno", jsonparam.get((Object)"billno"));
        BillAbstractHeadBean oribill = null;
        try {
            oribill = (BillAbstractHeadBean)this.doSearchOne(json, this.getBeanClass());
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        Map<String, Object> bpmdata = this.getbpminfo(oribill, session, true, oribill.getBillstatus());
        ServiceResponse resp = BpmService.getBpmService().gettask(bpmdata);
        return resp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Transactional(propagation=Propagation.REQUIRED)
    public Object dobillbpmexec(BillAbstractHeadBean bill, String comment, String taskid, String billstatus, ServiceSession session, JSONObject jsonparam) throws Exception {
        JSONObject json;
        bill.initUpdateMember(session);
        String name = this.getstatusname(billstatus);
        BillAbstractHeadBean oribill = this.checkBillStatusNew(bill);
        if (!(oribill.getBillstatus().equalsIgnoreCase("S") || oribill.getBillstatus().equalsIgnoreCase("A") || oribill.getBillstatus().equalsIgnoreCase("R"))) {
            throw new ServiceException("10000", "\u5355\u636e[{0}]\u53ea\u6709\u63d0\u4ea4\u548c\u5ba1\u6279\u4e2d\u72b6\u6001\u65f6\u624d\u80fd\u6267\u884c{1}!", oribill.getBillno(), name);
        }
        if (oribill.getBillstatus().equalsIgnoreCase("R") && !billstatus.equalsIgnoreCase("N")) {
            throw new ServiceException("10000", "\u5355\u636e[{0}]\u5df2\u88ab\u9a73\u56de,\u4e0d\u80fd\u6267\u884c{1}\u64cd\u4f5c!", oribill.getBillno(), name);
        }
        bill.setBillmoduleid(oribill.getBillmoduleid());
        bill.setBillstatus(billstatus);
        bill.setLastmodby(Utils.nvl(session.getUser_code(), oribill.getInputer()));
        bill.setLastmodby_name("[" + Utils.nvl(session.getUser_code(), oribill.getInputer()) + "]" + Utils.nvl(session.getUser_name(), oribill.getInputer_name()));
        HashSet<String> keys = null;
        Map<String, Object> bpminfo = null;
        bpminfo = this.getbpminfo(oribill, session, true, billstatus);
        bpminfo.put("comment", comment);
        if (!StringUtils.isEmpty((Object)jsonparam.get((Object)"addTaskInfo"))) {
            bpminfo.put("addTaskInfo", jsonparam.get((Object)"addTaskInfo"));
        }
        if (!StringUtils.isEmpty((Object)jsonparam.get((Object)"cc"))) {
            bpminfo.put("cc", jsonparam.get((Object)"cc"));
        }
        Object sbid = null;
        try {
            sbid = AbstractEntityBean.fetchDeclaredField(oribill.getClass(), "sbid").get(oribill);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ServiceResponse resp = null;
        if (billstatus.equalsIgnoreCase("A")) {
            if (this.isOracle().booleanValue()) {
                try {
                    BillCommonServiceImpl.getInstance().prebillapproval(bill);
                }
                catch (ServiceException ex) {
                    if (!ex.getErrorCode().equalsIgnoreCase("0")) throw ex;
                }
            } else {
                this.prebillapprovalcheck(bill);
            }
            resp = BpmService.getBpmService().approval(bpminfo);
        } else if (billstatus.equalsIgnoreCase("R")) {
            resp = BpmService.getBpmService().reject(bpminfo);
            this.notification(oribill, billstatus);
        } else if (billstatus.equalsIgnoreCase("N")) {
            BpmService.getBpmService().repeal(bpminfo);
        } else if (billstatus.equalsIgnoreCase("J")) {
            BpmService.getBpmService().addtask(bpminfo);
        }
        if (!(StringUtils.isEmpty((Object)resp) || StringUtils.isEmpty((Object)resp.getData()) || StringUtils.isEmpty((Object)(json = JSONObject.parseObject((String)resp.getData().toString()))) || StringUtils.isEmpty((Object)json.get((Object)"ismulti")) || !"Y".equals(json.getString("ismulti")))) {
            bill.setBillstatus(json.getString("billstatus"));
        }
        if (billstatus.equalsIgnoreCase("J")) {
            bill.setBillstatus("A");
        }
        if (keys == null) {
            keys = new HashSet<String>();
        }
        keys.add("billstatus");
        keys.add("ph_timestamp");
        keys.add("lastmodby");
        keys.add("lastmodby_name");
        super.doUpdate(bill, keys, "billno", new String[0]);
        this.getOperlog().log(bill.getLastmodby(), bill.getLastmodby_name(), name, comment, bill);
        if (billstatus.equalsIgnoreCase("A")) {
            if (StringUtils.isEmpty((Object)resp)) return null;
            if (StringUtils.isEmpty((Object)resp.getData())) return null;
            json = JSONObject.parseObject((String)resp.getData().toString());
            String islast = json.getString("islast");
            if (!islast.equals("Y")) return null;
            this.doReturnStatus(oribill);
            this.doBillAudit(oribill, session, true);
            this.notification(oribill, billstatus);
            return null;
        }
        if (!billstatus.equalsIgnoreCase("N")) return null;
        this.doReturnStatus(oribill);
        return null;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void prebillapproval(BillAbstractHeadBean bill) throws Exception {
        String oldstatus = bill.getBillstatus();
        try {
            Map<String, Object> billmain = this.getbillmain(bill);
            if (!StringUtils.isEmpty((Object)billmain.get("taskid"))) {
                String status = StringUtils.isEmpty((Object)billmain.get("billwfstartflag")) ? "N" : billmain.get("billwfstartflag").toString();
                FMybatisTemplate storage = this.getStorageOperations(FMybatisTemplate.class);
                HashSet<String> keys = new HashSet<String>();
                keys.add("billstatus");
                bill.setBillstatus(status);
                super.doUpdate(bill, keys, "billno", new String[0]);
                String sql = "CALL DBUSRPUB.SP_BILLAPPROVE('" + bill.getBillno() + "','system','" + bill.getBillmoduleid() + "')";
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("value", sql);
                storage.getSqlSessionTemplate().insert("mybatis.sql.insert", map);
                bill.setBillstatus(oldstatus);
                super.doUpdate(bill, keys, "billno", new String[0]);
            }
        }
        catch (Exception e) {
            String msg = e.getMessage();
            String[] str = msg.split("java.sql.SQLException:");
            if (str.length > 1) {
                String[] tempstr = str[1].split("\n");
                msg = tempstr[0];
            }
            throw new ServiceException("10000", msg, new Object[0]);
        }
        finally {
            HashSet<String> keys = new HashSet<String>();
            keys.add("billstatus");
            bill.setBillstatus(oldstatus);
            super.doUpdate(bill, keys, "billno", new String[0]);
        }
        throw new ServiceException("0", "", new Object[0]);
    }

    public void prebillapprovalcheck(BillAbstractHeadBean bill) throws Exception {
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void doReturnStatus(BillAbstractHeadBean bill) throws Exception {
        HashSet<String> keys = new HashSet<String>();
        keys.add("billstatus");
        Map<String, Object> billmain = this.getbillmain(bill);
        String status = StringUtils.isEmpty((Object)billmain.get("billwfstartflag")) ? "N" : billmain.get("billwfstartflag").toString();
        bill.setBillstatus(status);
        super.doUpdate(bill, keys, "billno", new String[0]);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Object dobillthirdbpmexec(BillAbstractHeadBean bill, String billstatus, ServiceSession session, String lastflag) throws Exception {
        bill.initUpdateMember(session);
        String name = this.getstatusname(billstatus);
        BillAbstractHeadBean oribill = this.checkBillStatus(bill);
        if (!(oribill.getBillstatus().equalsIgnoreCase("S") || oribill.getBillstatus().equalsIgnoreCase("A") || oribill.getBillstatus().equalsIgnoreCase("R"))) {
            throw new ServiceException("10000", "\u5355\u636e[{0}]\u53ea\u6709\u63d0\u4ea4\u548c\u5ba1\u6279\u4e2d\u72b6\u6001\u65f6\u624d\u80fd\u6267\u884c{1}!", oribill.getBillno(), name);
        }
        if (oribill.getBillstatus().equalsIgnoreCase("R") && !billstatus.equalsIgnoreCase("N")) {
            throw new ServiceException("10000", "\u5355\u636e[{0}]\u5df2\u88ab\u9a73\u56de,\u4e0d\u80fd\u6267\u884c{1}\u64cd\u4f5c!", oribill.getBillno(), name);
        }
        bill.setBillmoduleid(oribill.getBillmoduleid());
        bill.setBillstatus(billstatus);
        bill.setLastmodby(Utils.nvl(session.getUser_code(), oribill.getInputer()));
        bill.setLastmodby_name("[" + Utils.nvl(session.getUser_code(), oribill.getInputer()) + "]" + Utils.nvl(session.getUser_name(), oribill.getInputer_name()));
        HashSet<String> keys = null;
        if (keys == null) {
            keys = new HashSet<String>();
        }
        keys.add("billstatus");
        keys.add("ph_timestamp");
        keys.add("lastmodby");
        keys.add("lastmodby_name");
        super.doUpdate(bill, keys, "billno", new String[0]);
        this.getOperlog().log(bill.getLastmodby(), bill.getLastmodby_name(), name, "", bill);
        if (billstatus.equalsIgnoreCase("A") && lastflag.equalsIgnoreCase("Y")) {
            this.doBillAudit(oribill, session, false);
        }
        return null;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void notification(BillAbstractHeadBean bill, String billstatus) {
        String postid;
        String userid;
        String Notitype;
        String notiinfo;
        String title;
        String billsource = null;
        try {
            billsource = AbstractEntityBean.fetchDeclaredField(bill.getClass(), "billsource").get(bill) == null ? "MSS" : AbstractEntityBean.fetchDeclaredField(bill.getClass(), "billsource").get(bill).toString();
        }
        catch (Exception e) {
            billsource = "MSS";
        }
        if (billstatus.equalsIgnoreCase("A")) {
            title = "\u5355\u636e\u5ba1\u6279\u63d0\u9192";
            notiinfo = "\u5355\u53f7\u3010" + bill.getBillno() + "\u3011\u5df2\u5ba1\u6279\u901a\u8fc7";
            Notitype = "\u5355\u636e\u5ba1\u6279\u63d0\u9192";
            this.mallMessageTemplate.generateEventMessage(bill);
        } else if (billstatus.equalsIgnoreCase("R")) {
            title = "\u5355\u636e\u5ba1\u6279\u63d0\u9192";
            notiinfo = "\u5355\u53f7\u3010" + bill.getBillno() + "\u3011\u5df2\u88ab\u9a73\u56de";
            Notitype = "\u5355\u636e\u5ba1\u6279\u63d0\u9192";
        } else {
            return;
        }
        if (billsource.equalsIgnoreCase("APP")) {
            try {
                userid = AbstractEntityBean.fetchDeclaredField(bill.getClass(), "sbid").get(bill).toString();
            }
            catch (Exception e) {
                userid = bill.getInputer();
            }
            postid = "99999999";
        } else {
            userid = bill.getInputer();
            postid = "0";
        }
        this.insertnotification(postid, userid, bill.getBillmoduleid(), bill.getBillno(), notiinfo, title, Notitype);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void insertnotification(String postid, String userid, String moduleid, String billno, String notiinfo, String title, String Notitype) {
        FMybatisTemplate storage = null;
        try {
            storage = this.getStorageOperations(FMybatisTemplate.class);
            String sql = "CALL DBUSRPUB.INSERT_NOTIFICATION('" + postid + "','" + userid + "','" + moduleid + "','" + billno + "','" + notiinfo + "','" + title + "','" + Notitype + "')";
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("value", sql);
            storage.getSqlSessionTemplate().insert("mybatis.sql.insert", map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public ServiceResponse get(ServiceSession session, JSONObject jsonparam) throws Exception {
        try {
            if (session == null) {
                return ServiceResponse.buildFailure(session, "50001");
            }
            if (StringUtils.isEmpty((Object)jsonparam)) {
                return ServiceResponse.buildFailure(session, "50003");
            }
            String idkey = this.getIdKey();
            String table = this.getBeanTable();
            String masterkey = this.getMasterSlaveKey();
            if (!(jsonparam.containsKey((Object)idkey) && !StringUtils.isEmpty((Object)jsonparam.get((Object)idkey)) || jsonparam.containsKey((Object)masterkey) && !StringUtils.isEmpty((Object)jsonparam.get((Object)masterkey)))) {
                return ServiceResponse.buildFailure(session, "50004", "{0} {1} is empty", table, idkey);
            }
            jsonparam.put("ent_id", (Object)session.getEnt_id());
            Object obj = null;
            obj = StringUtils.isEmpty((Object)jsonparam.get((Object)"fields")) ? (Object)this.doSearchOne(jsonparam, this.getBeanClass()) : this.doSearchOneForMap(jsonparam, this.getBeanClass());
            if (obj == null) {
                return ServiceResponse.buildFailure(session, "10003", "{0} {1} [{2}] does not exist", table, idkey, jsonparam.getLong(idkey));
            }
            obj = this.filter(obj, this.getBeanClass());
            JSONObject respdata = new JSONObject();
            respdata.put(table, obj);
            return ServiceResponse.buildSuccess(respdata);
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return ServiceResponse.buildFailure(session, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs());
        }
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void sendmsg(BillAbstractHeadBean bill) {
        String mktcol = null;
        String mkt = null;
        String sendflag = "N";
        Map<String, Object> billmain = this.getbillmain(bill);
        if (billmain == null) {
            return;
        }
        mktcol = billmain.get("billmktcol") == null ? "" : billmain.get("billmktcol").toString();
        String string = sendflag = billmain.get("billissendmsg") == null ? "N" : billmain.get("billissendmsg").toString();
        if (mktcol != null && !mktcol.isEmpty() && sendflag != null && !sendflag.isEmpty() && sendflag.equals("Y")) {
            try {
                mkt = AbstractEntityBean.fetchDeclaredField(bill.getClass(), mktcol.toLowerCase()).get(bill).toString();
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            if (mkt != null && !mkt.isEmpty()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("muid", mkt);
                map.put("moduleid", bill.getBillmoduleid());
                SqlSessionTemplate db = this.getStorageOperations(FMybatisTemplate.class).getSqlSessionTemplate();
                List list = db.selectList("select_billauditor", map);
                String userid = null;
                String postid = null;
                for (Map auditor : list) {
                    postid = auditor.get("postid").toString();
                    userid = auditor.get("userid").toString();
                    if (!bill.getBillstatus().equalsIgnoreCase("N")) {
                        return;
                    }
                    String title = "\u5355\u636e\u5ba1\u6279\u63d0\u9192";
                    String notiinfo = "\u5355\u53f7\u3010" + bill.getBillno() + "\u3011\u5f85\u5ba1\u6279";
                    String Notitype = "\u5355\u636e\u5ba1\u6279\u63d0\u9192";
                    this.insertnotification(postid, userid, bill.getBillmoduleid(), bill.getBillno(), notiinfo, title, Notitype);
                }
            }
        }
    }

    public ServiceResponse getBillSubmitter(ServiceSession session, JSONObject jsonparam) throws Exception {
        jsonparam.put("billid", (Object)((String)jsonparam.get((Object)"billno")));
        return BpmService.getBpmService().getsubmitter((Map<String, Object>)jsonparam);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse save(ServiceSession session, String param) throws Exception {
        ServiceResponse res = super.save(session, param);
        return res;
    }

    public double DiffDate(String curdate, String comparedate) throws ParseException {
        Date now = this.sdf.parse(curdate);
        Date date = this.sdf.parse(comparedate);
        long l = now.getTime() - date.getTime();
        long day = l / 86400000L;
        long hour = l / 3600000L - day * 24L;
        long min = l / 60000L - day * 24L * 60L - hour * 60L;
        long s = l / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        return s;
    }

    @Override
    public ServiceResponse getslave(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"slave"))) {
            throw new ServiceException("10000", "{0} is null", "slave");
        }
        String slave = jsonparam.getString("slave");
        jsonparam.remove((Object)"slave");
        StringBuffer sbtotal = new StringBuffer();
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"ent_id"))) {
            jsonparam.put("ent_id", (Object)session.getEnt_id());
        }
        Map flds = this.getSlaveFields(this.getBeanClass());
        Class clazz = flds.get(slave);
        List<Map<String, Object>> lst = super.doSearchForMap(jsonparam, clazz, sbtotal);
        JSONObject json = new JSONObject();
        json.put(slave, lst);
        json.put("total_results", (Object)sbtotal.toString());
        return ServiceResponse.buildSuccess(json);
    }

    @Override
    public ServiceResponse sheetAuditLog(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (!StringUtils.isEmpty((Object)jsonparam.get((Object)"billid"))) {
            jsonparam.put("billno", (Object)((String)jsonparam.get((Object)"billid")));
        }
        return BpmService.getBpmService().auditlog((Map<String, Object>)jsonparam);
    }

    @Override
    public ServiceResponse getProcessList(ServiceSession session, JSONObject jsonparam) throws Exception {
        return BpmService.getBpmService().processList((Map<String, Object>)jsonparam);
    }

    @Override
    public ServiceResponse getUserList(ServiceSession session, JSONObject jsonparam) throws Exception {
        return BpmService.getBpmService().getuserlist((Map<String, Object>)jsonparam);
    }

    @Override
    public ServiceResponse getUserGroupList(ServiceSession session, JSONObject jsonparam) throws Exception {
        return BpmService.getBpmService().getgrouplist((Map<String, Object>)jsonparam);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    @CheckRepeatAnnotation(KeyArgIndex=1, KeyName="billno")
    public ServiceResponse billaddtask(ServiceSession session, JSONObject jsonparam) throws Exception {
        return this.billbpmexec(session, jsonparam, "J");
    }

    private Boolean isOracle() throws Exception {
        QueryExtractor.DBTYPE dbtype = this.getStorageOperations(FMybatisTemplate.class).getDBType();
        if (dbtype == QueryExtractor.DBTYPE.ORACLE) {
            return true;
        }
        return false;
    }

    public static interface BillSource {
        public static final String APP = "APP";
        public static final String MSS = "MSS";
    }

    public static interface BillStatus {
        public static final String NEW = "N";
        public static final String GENRATE = "M";
        public static final String EFFECT = "X";
        public static final String AUDIT = "Y";
        public static final String CANCEL = "C";
        public static final String WAIT = "W";
        public static final String EXEC = "T";
        public static final String AUDITING = "A";
        public static final String SUBMIT = "S";
        public static final String REJECT = "R";
        public static final String ERR = "E";
        public static final String PAY = "P";
        public static final String ADDTASK = "J";
    }
}

