/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.component;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.component.BasicComponentService;
import com.efuture.ocp.common.entity.ImpErrMsgBean;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.util.UniqueID;
import com.efuture.omd.storage.FMybatisTemplate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="excelimperrsrv")
public class ExcelImportErrServiceImpl
extends BasicComponentService<ImpErrMsgBean> {
    public String batchInsertImpErr(ServiceSession session, JSONObject jsonparam, List<String> errmsgs) throws Exception {
        String result = "";
        if (errmsgs.size() > 0) {
            ArrayList<ImpErrMsgBean> list = new ArrayList<ImpErrMsgBean>();
            Long seqno = UniqueID.getUniqueID();
            List<Long> ids = UniqueID.getUniqueIDArray(errmsgs.size());
            Date ph_timestamp = new Date();
            for (int i = 0; i < errmsgs.size(); ++i) {
                ImpErrMsgBean temp = new ImpErrMsgBean();
                temp.setPh_key(ids.get(i));
                temp.setEnt_id(session.getEnt_id());
                temp.setOperuser(session.getUser_code());
                temp.setPh_timestamp(ph_timestamp);
                temp.setErrmsg(errmsgs.get(i));
                if (jsonparam.containsKey((Object)"billmoduleid")) {
                    temp.setModuleid(jsonparam.getString("billmoduleid"));
                }
                temp.setSeqno(seqno);
                list.add(temp);
            }
            this.batchInsert(this.getStorageOperations(FMybatisTemplate.class), ImpErrMsgBean.class, list, 1000);
            result = seqno.toString();
        }
        return result;
    }

    public String format(String errmsg, Object ... args) {
        if (args == null || args.length <= 0) {
            return errmsg;
        }
        for (int i = 0; args != null && i < args.length; ++i) {
            if (args[i] instanceof String) continue;
            args[i] = StringUtils.isEmpty((Object)args[i]) ? "" : args[i].toString();
        }
        return MessageFormat.format(errmsg, args);
    }

    @Override
    public ServiceResponse export(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        JSONObject temp = JSONObject.parseObject((String)jsonparam.toJSONString());
        temp.remove((Object)"fields");
        ServiceResponse result = this.search(session, temp);
        JSONObject data = (JSONObject)result.getData();
        data.put("report", (Object)data.getJSONArray(this.getBeanTable()));
        data.remove((Object)this.getBeanTable());
        result.setData(data);
        return result;
    }

    public ServiceResponse deleteMsg(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (!StringUtils.isEmpty((Object)jsonparam) && !StringUtils.isEmpty((Object)jsonparam.get((Object)"seqno"))) {
            FMybatisTemplate storage = this.getStorageOperations(FMybatisTemplate.class);
            Criteria criteria = Criteria.where((String)"seqno").is(jsonparam.get((Object)"seqno"));
            Query query = new Query((CriteriaDefinition)criteria);
            storage.delete(query, "imperrmsg");
        }
        JSONObject json = new JSONObject();
        json.put("flag", (Object)"1");
        return ServiceResponse.buildSuccess(json);
    }
}

