/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.filter;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.OperSearchRuleDecBean;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.filter.ExportMysqlTableAliasVisitor;
import com.efuture.ocp.common.filter.FtSqlSource;
import com.efuture.ocp.common.filter.OperSearchRuleDecServiceImpl;
import com.efuture.ocp.common.rest.ServiceRestReflect;
import com.efuture.ocp.common.user.UserDataRangeSrv;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.log4j.Logger;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class ExecutorMysqlPolicyWrapper
implements Interceptor {
    private static Logger sqlLog = Logger.getLogger((String)"sqlLog");
    private String dbType;

    public Object intercept(Invocation invocation) throws Throwable {
        if (!UserDataRangeSrv.getlocalisrange()) {
            return invocation.proceed();
        }
        String sql = "";
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        try {
            ThreadLocal<ServiceSession> local = ServiceRestReflect.getLocale();
            ServiceSession session = local.get();
            OperSearchRuleDecServiceImpl ser = new OperSearchRuleDecServiceImpl();
            List<OperSearchRuleDecBean> datarange = ser.getOperSearchRuleDec(session.getDataRangeId());
            if (datarange.size() == 0) {
                return invocation.proceed();
            }
            ExportMysqlTableAliasVisitor visitor = new ExportMysqlTableAliasVisitor();
            visitor.set(datarange);
            Object parameter = null;
            if (invocation.getArgs().length > 1) {
                parameter = invocation.getArgs()[1];
            }
            BoundSql boundSql = mappedStatement.getBoundSql(parameter);
            sql = boundSql.getSql();
            List stmtList = SQLUtils.parseStatements((String)sql, (String)this.dbType);
            for (SQLStatement stmt : stmtList) {
                stmt.accept((SQLASTVisitor)visitor);
            }
            String newSql = SQLUtils.toSQLString((List)stmtList, (String)this.dbType);
            visitor.remove();
            FtSqlSource sqlSource = new FtSqlSource(mappedStatement.getConfiguration(), newSql, boundSql);
            MappedStatement newMs = this.copyFromMappedStatement(mappedStatement, sqlSource);
            invocation.getArgs()[0] = newMs;
        }
        catch (Exception e) {
            invocation.getArgs()[0] = mappedStatement;
            JSONObject errorJson = new JSONObject();
            errorJson.put("unresolved sql", (Object)sql);
            sqlLog.error((Object)errorJson.toJSONString());
            e.printStackTrace();
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        this.dbType = properties.getProperty("dbType");
        if (this.dbType == null || this.dbType.equals("")) {
            this.dbType = "mysql";
        }
    }

    private MappedStatement copyFromMappedStatement(MappedStatement ms, SqlSource newSqlSource) {
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), ms.getId(), newSqlSource, ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        builder.keyProperty(ms.getKeyProperties() == null ? null : ms.getKeyProperties()[0]);
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        builder.resultMaps(ms.getResultMaps());
        builder.resultSetType(ms.getResultSetType());
        builder.cache(ms.getCache());
        builder.flushCacheRequired(ms.isFlushCacheRequired());
        builder.useCache(ms.isUseCache());
        return builder.build();
    }
}

