/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.rest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.billservice.FileServiceImpl;
import com.efuture.ocp.common.cache.CacheUtils;
import com.efuture.ocp.common.component.MssFileService;
import com.efuture.ocp.common.entity.AbstractEntityBean;
import com.efuture.ocp.common.entity.FileImportObject;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.rest.ServiceMethodReflect;
import com.efuture.ocp.common.rest.ServiceVersion;
import com.efuture.ocp.common.rest.userinterface.InitSession;
import com.efuture.ocp.common.user.UserDataRangeSrv;
import com.efuture.ocp.common.util.DataUtils;
import com.efuture.ocp.common.util.DateUtils;
import com.efuture.ocp.common.util.EnviromentUtil;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.common.util.UniqueID;
import com.efuture.ocp.common.util.UrlEncoderUtils;
import com.efuture.ocp.common.util.Utils;
import com.efuture.ocp.user.UserTokenInfo;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.representation.Form;
import com.sun.jersey.multipart.FormDataBodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.springframework.util.StringUtils;

@Path(value="/")
public class ServiceRestReflect {
    @Context
    HttpServletRequest request;
    @Context
    HttpServletResponse response;
    private static ServiceMethodReflect rcm = new ServiceMethodReflect();
    private static final ThreadLocal<ServiceSession> locale = new ThreadLocal();

    public static ThreadLocal<ServiceSession> getLocale() {
        if (locale == null || locale.get() == null) {
            locale.set(new ServiceSession());
        }
        return locale;
    }

    public static void pushlocale(ServiceSession session) {
        locale.set(session);
    }

    public static void removeLocale(ServiceSession session) {
        if (session != null && !StringUtils.isEmpty((Object)session.getMethod()) && session.getStarttime() > 0L) {
            ServiceVersion.getInstance().writeElapsed(session.getMethod(), System.currentTimeMillis() - session.getStarttime());
        }
        locale.remove();
    }

    @GET
    @Produces(value={"text/html;charset=UTF-8"})
    @Path(value="/")
    public String test(@QueryParam(value="status") String status) {
        String uri = this.request.getRequestURI();
        if (uri.startsWith("/") || uri.startsWith("\\")) {
            uri = uri.substring(1);
        }
        if (uri.endsWith("/") || uri.endsWith("\\")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        if ("check".equalsIgnoreCase(status)) {
            return uri + " success";
        }
        if ("info".equalsIgnoreCase(status)) {
            JSONObject json = new JSONObject();
            RuntimeMXBean run = ManagementFactory.getRuntimeMXBean();
            json.put("pid", (Object)run.getName().split("@")[0]);
            json.put("server", (Object)run.getName().split("@")[1]);
            json.put("startTime", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(run.getStartTime()));
            return json.toJSONString();
        }
        if ("statis".equalsIgnoreCase(status)) {
            try {
                return ServiceVersion.getInstance().printElapsed();
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
        if ("clear".equalsIgnoreCase(status)) {
            try {
                ServiceVersion.getInstance().cleanElapsed();
                return "ok";
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
        ServiceVersion sv = ServiceVersion.getInstance();
        if ("openlog".equalsIgnoreCase(status)) {
            sv.setLogstatus(true);
        }
        if ("closelog".equalsIgnoreCase(status)) {
            sv.setLogstatus(false);
        }
        String startup = sv.getStartupTime();
        long time = DateUtils.strDateTimeLong(startup);
        long now = System.currentTimeMillis();
        return uri + " version " + sv.getVer() + " (LogStatus: " + (sv.isLogstatus() ? "Y" : "N") + ") started at " + startup + " up " + DateUtils.getDateTimeDuration(now, time) + "\n";
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="/health")
    public String health() {
        return "{\"status\":\"UP\"}";
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="/montior/info")
    public String info() {
        JSONObject json = new JSONObject();
        RuntimeMXBean run = ManagementFactory.getRuntimeMXBean();
        json.put("pid", (Object)run.getName().split("@")[0]);
        json.put("server", (Object)run.getName().split("@")[1]);
        return json.toJSONString();
    }

    @GET
    @Produces(value={"text/html;charset=UTF-8"})
    @Path(value="/env")
    public String env(@QueryParam(value="key") String key, @QueryParam(value="group") String group) {
        if (StringUtils.isEmpty((Object)key) && StringUtils.isEmpty((Object)group)) {
            return "require key";
        }
        if (!StringUtils.isEmpty((Object)group)) {
            if ("*".equals(group)) {
                return EnviromentUtil.getAllPropertys(new String[0]).toJSONString();
            }
            return EnviromentUtil.getAllPropertys(group.split(",")).toJSONString();
        }
        String[] keys = key.split(",");
        JSONObject json = EnviromentUtil.followEnvironment(null, keys);
        if (json != null) {
            return json.toJSONString();
        }
        return "";
    }

    @GET
    @Produces(value={"text/html;charset=UTF-8"})
    @Path(value="/log4j")
    public String log4j(@QueryParam(value="level") String level) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig("");
        if (StringUtils.isEmpty((Object)level)) {
            return "log4j level is [" + loggerConfig.getLevel().name() + "] ,config file is [" + config.getName() + "]";
        }
        loggerConfig.setLevel(Level.getLevel((String)level.toUpperCase()));
        ctx.updateLoggers();
        return "log4j level update to [" + loggerConfig.getLevel().name() + "]";
    }

    private Map<String, String> getParameter() {
        HashMap<String, String> rtn = new HashMap<String, String>();
        Enumeration e = this.request.getParameterNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String[] values = this.request.getParameterValues(key);
            if (values == null || values.length <= 0 || StringUtils.isEmpty((Object)values[0])) continue;
            String value = values[0];
            rtn.put(key, value);
        }
        return rtn;
    }

    private void setSessionbycongou(ServiceSession session, String key, String value) {
        if ("token".equalsIgnoreCase(key)) {
            session.setToken(value);
            UserDataRangeSrv.setlocaltoken(value);
            UserTokenInfo info = UserDataRangeSrv.getlocaluser();
            if (info != null) {
                session.setEnt_id(Long.parseLong(info.getEntid()));
                session.setUser_id(Long.parseLong(info.getUserid()));
                session.setUser_code(info.getUseraccount());
                session.setUser_name(info.getUsername());
                session.setDeptcode(info.getDeptid());
                session.setDeptrealcode(info.getDeptcode());
                session.setRoleid(info.getOrgid());
                session.setRolecode(info.getOrgcode());
                session.setPostid(info.getPostid());
            }
        }
        if ("ent_id".equalsIgnoreCase(key)) {
            session.setEnt_id(Long.parseLong(value));
        }
        if ("user_id".equalsIgnoreCase(key)) {
            session.setUser_id(Long.parseLong(value));
        }
        if ("user_code".equalsIgnoreCase(key)) {
            session.setUser_code(value);
        }
        if ("user_name".equalsIgnoreCase(key)) {
            session.setUser_name(value);
        }
        if ("locale".equalsIgnoreCase(key)) {
            session.setLocale(value);
        }
        if ("debug_status".equalsIgnoreCase(key)) {
            session.setDebug_status(value);
        }
        if ("parentkey".equalsIgnoreCase(key)) {
            session.setParentkey(value);
        }
        if ("rootkey".equalsIgnoreCase(key)) {
            session.setRootkey(value);
        }
        if ("market".equalsIgnoreCase(key)) {
            session.setMarket(value);
        }
        if ("shop_code".equalsIgnoreCase(key) || "shopCode".equalsIgnoreCase(key)) {
            session.setMarket(value);
        }
        if ("slice".equalsIgnoreCase(key)) {
            session.setSlice(value);
        }
    }

    private void setSession(ServiceSession session, String key, String value) {
        if ("ent_id".equalsIgnoreCase(key)) {
            session.setEnt_id(Long.parseLong(value));
        }
        if ("user_id".equalsIgnoreCase(key)) {
            session.setUser_id(Long.parseLong(value));
        }
        if ("user_code".equalsIgnoreCase(key)) {
            session.setUser_code(value);
        }
        if ("user_name".equalsIgnoreCase(key)) {
            session.setUser_name(value);
        }
        if ("locale".equalsIgnoreCase(key)) {
            session.setLocale(value);
        }
        if ("debug_status".equalsIgnoreCase(key)) {
            session.setDebug_status(value);
        }
        if ("token".equalsIgnoreCase(key)) {
            session.setToken(value);
        }
        if ("postid".equalsIgnoreCase(key)) {
            session.setPostid(value);
        }
        if ("parentkey".equalsIgnoreCase(key)) {
            session.setParentkey(value);
        }
        if ("rootkey".equalsIgnoreCase(key)) {
            session.setRootkey(value);
        }
        if ("market".equalsIgnoreCase(key)) {
            session.setMarket(value);
        }
        if ("shop_code".equalsIgnoreCase(key) || "shopCode".equalsIgnoreCase(key)) {
            session.setMarket(value);
        }
        if ("slice".equalsIgnoreCase(key)) {
            session.setSlice(value);
        }
    }

    private String addQueryParamToJsonParam(ServiceSession session, String param, String ... ignores) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] openkey = new String[]{"token", "access_token", "method", "app_key", "timestamp", "format", "ver", "version", "sign_method", "sign", "signature_method", "signature", "postid", "portalkey", "shopCode", "shop_code"};
        String[] ss = null;
        if (session != null) {
            int i;
            StringBuffer sb = new StringBuffer();
            String[] s = AbstractEntityBean.fetchAllDeclaredField(session.getClass(), sb).toString().split(",");
            ss = new String[openkey.length + s.length];
            for (i = 0; i < openkey.length; ++i) {
                ss[i] = openkey[i];
            }
            for (i = 0; i < s.length; ++i) {
                ss[openkey.length + i] = s[i];
            }
        } else {
            ss = openkey;
        }
        Map<String, String> rp = this.getParameter();
        String portalkey = DataUtils.nvl(rp.get("portalkey"), UserDataRangeSrv.getPortalkey());
        boolean iscongouportal = false;
        if (!StringUtils.isEmpty((Object)portalkey) && portalkey.equalsIgnoreCase("congou")) {
            iscongouportal = true;
        }
        for (Map.Entry<String, String> entry : rp.entrySet()) {
            String[] values;
            String key = entry.getKey();
            if (Utils.stringArrayContainsKey(ignores, key, true) || (values = this.request.getParameterValues(key)) == null || values.length <= 0 || StringUtils.isEmpty((Object)values[0])) continue;
            String value = values[0];
            if (ss != null && Utils.stringArrayContainsKey(ss, key, true)) {
                if (iscongouportal) {
                    this.setSessionbycongou(session, key, value);
                    continue;
                }
                this.setSession(session, key, value);
                continue;
            }
            if (value.startsWith("{") && value.endsWith("}") || value.startsWith("[") && value.endsWith("]")) {
                try {
                    map.put(key, JSON.parse((String)value));
                }
                catch (Exception ex) {
                    map.put(key, value);
                }
                continue;
            }
            map.put(key, value);
        }
        if (map != null && map.size() > 0) {
            JSONObject jsonparam = null;
            if (StringUtils.isEmpty((Object)param)) {
                jsonparam = new JSONObject();
            } else {
                try {
                    jsonparam = JSON.parseObject((String)param);
                }
                catch (Exception ex) {
                    return param;
                }
            }
            for (String key : map.keySet()) {
                if (jsonparam.containsKey((Object)key)) continue;
                jsonparam.put(key, map.get(key));
            }
            param = jsonparam.toJSONString();
        }
        if (!StringUtils.isEmpty((Object)session.getToken()) && StringUtils.isEmpty((Object)session.getDataRangeId())) {
            String key = "session:" + session.getToken();
            try {
                JSONObject json = JSONObject.parseObject((String)((String)CacheUtils.getCacheUtils().getCacheData(key)));
                if (!StringUtils.isEmpty((Object)json) && !StringUtils.isEmpty((Object)json.get((Object)"dataRangeId"))) {
                    session.setDataRangeId(json.get((Object)"dataRangeId").toString());
                }
                if (!(StringUtils.isEmpty((Object)session.getUser_id()) || StringUtils.isEmpty((Object)json) || StringUtils.isEmpty((Object)json.get((Object)"user_id")))) {
                    session.setUser_id(Long.parseLong(json.get((Object)"user_id").toString()));
                }
                if (!(StringUtils.isEmpty((Object)session.getStationId()) || StringUtils.isEmpty((Object)json) || StringUtils.isEmpty((Object)json.get((Object)"stationId")))) {
                    session.setStationId(Long.parseLong(json.get((Object)"stationId").toString()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (SpringBeanFactory.containsBean("initSession_" + portalkey)) {
            InitSession init = SpringBeanFactory.getBean("initSession_" + portalkey, InitSession.class);
            init.init(session);
        }
        if (session != null) {
            session.setHttp_uri(this.request.getScheme() + "://" + this.request.getServerName() + ":" + this.request.getServerPort());
        }
        return param;
    }

    private boolean isEffective(String remoteAddr) {
        return null != remoteAddr && !"".equals(remoteAddr.trim()) && !"unknown".equalsIgnoreCase(remoteAddr.trim());
    }

    private String getRemoteAddr() {
        try {
            String remoteAddr = this.request.getHeader("X-Forwarded-For");
            if (this.isEffective(remoteAddr) && remoteAddr.indexOf(",") > -1) {
                String[] array;
                for (String element : array = remoteAddr.split(",")) {
                    if (!this.isEffective(element)) continue;
                    remoteAddr = element;
                    break;
                }
            }
            if (!this.isEffective(remoteAddr)) {
                remoteAddr = this.request.getHeader("X-Real-IP");
            }
            if (!this.isEffective(remoteAddr)) {
                remoteAddr = this.request.getRemoteAddr();
            }
            if (remoteAddr != null && remoteAddr.indexOf(".") > 0) {
                return remoteAddr;
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    @POST
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="/jsonrest")
    public String callRestService_json(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam) {
        return this.callRestService(method, session, param, postparam);
    }

    /*
     * Exception decompiling
     */
    @POST
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/rest")
    public String callRestService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/restomni")
    public String callRestService_omni(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam) {
        String result = null;
        String remoteaddr = "";
        long logkey = 0L;
        String url = "";
        long start_time = System.currentTimeMillis();
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            UserDataRangeSrv.setlocaltoken("");
            if (ServiceVersion.getInstance().isLogstatus()) {
                remoteaddr = this.getRemoteAddr();
                logkey = UniqueID.getUniqueID();
                url = this.request.getQueryString();
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param");
            sessionobj.setEnt_id(0L);
            sessionobj.setToken("");
            UserDataRangeSrv.setlocaltoken("");
            if (ServiceVersion.getInstance().isLogstatus()) {
                StringBuffer sb = new StringBuffer();
                sb.append("[" + remoteaddr + " - " + logkey + "]: ");
                sb.append(method + " , ");
                sb.append("REQUEST  : ");
                sb.append(postparam);
                sb.append(" , url : ");
                sb.append(url);
                ServiceVersion.getInstance().debugLog(sb.toString());
            }
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);
            long end_time = System.currentTimeMillis();
            ServiceResponse response = null;
            if (retdata instanceof ServiceResponse) {
                response = (ServiceResponse)retdata;
                response.addElapsed("\u603b\u8017\u65f6", start_time, end_time);
                if (sessionobj != null && !"Y".equalsIgnoreCase(sessionobj.getDebug_status())) {
                    if (!ServiceVersion.getInstance().isLogstatus()) {
                        response.setElapsed(null);
                    }
                    response.setWarnmsg(null);
                }
            } else {
                if (retdata == null) {
                    retdata = "";
                }
                response = ServiceResponse.buildSuccess(retdata);
            }
            String string = result = JSON.toJSONString((Object)Utils.toNormalJSONObject(response));
            return string;
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String string = result = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String string = result = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return string;
        }
        finally {
            if (ServiceVersion.getInstance().isLogstatus()) {
                StringBuffer sb = new StringBuffer();
                sb.append("[" + remoteaddr + " - " + logkey + "]: ");
                sb.append(method + " , ");
                sb.append("ELAPSED  : " + (System.currentTimeMillis() - start_time) + " ms , ");
                sb.append("RESPONSE : ");
                sb.append(result);
                ServiceVersion.getInstance().debugLog(sb.toString());
            }
            UserDataRangeSrv.setlocaltoken("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/ptrest")
    public String callRestService_pt(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam) {
        String result = null;
        String remoteaddr = "";
        long logkey = 0L;
        String url = "";
        long start_time = System.currentTimeMillis();
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            UserDataRangeSrv.setlocaltoken("");
            if (ServiceVersion.getInstance().isLogstatus()) {
                remoteaddr = this.getRemoteAddr();
                logkey = UniqueID.getUniqueID();
                url = this.request.getQueryString();
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param");
            if (ServiceVersion.getInstance().isLogstatus()) {
                StringBuffer sb = new StringBuffer();
                sb.append("[" + remoteaddr + " - " + logkey + "]: ");
                sb.append(method + " , ");
                sb.append("REQUEST  : ");
                sb.append(postparam);
                sb.append(" , url : ");
                sb.append(url);
                ServiceVersion.getInstance().debugLog(sb.toString());
            }
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);
            long end_time = System.currentTimeMillis();
            ServiceResponse response = null;
            if (retdata instanceof ServiceResponse) {
                response = (ServiceResponse)retdata;
                response.addElapsed("\u603b\u8017\u65f6", start_time, end_time);
                if (sessionobj != null && !"Y".equalsIgnoreCase(sessionobj.getDebug_status())) {
                    if (!ServiceVersion.getInstance().isLogstatus()) {
                        response.setElapsed(null);
                    }
                    response.setWarnmsg(null);
                }
            } else {
                if (retdata == null) {
                    retdata = "";
                }
                response = ServiceResponse.buildSuccess(retdata);
            }
            String string = result = JSON.toJSONString((Object)Utils.toNormalJSONObject(response));
            return string;
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String string = result = JSON.toJSONString((Object)ServiceResponse.buildFailure_ex(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String string = result = JSON.toJSONString((Object)ServiceResponse.buildFailure_ex(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return string;
        }
        finally {
            if (ServiceVersion.getInstance().isLogstatus()) {
                StringBuffer sb = new StringBuffer();
                sb.append("[" + remoteaddr + " - " + logkey + "]: ");
                sb.append(method + " , ");
                sb.append("ELAPSED  : " + (System.currentTimeMillis() - start_time) + " ms , ");
                sb.append("RESPONSE : ");
                sb.append(result);
                ServiceVersion.getInstance().debugLog(sb.toString());
            }
            UserDataRangeSrv.setlocaltoken("");
        }
    }

    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/rest")
    public String callRestServiceByGET(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param) {
        return this.callRestService(method, session, param, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/import")
    @Produces(value={"text/plain;charset=UTF-8"})
    @Consumes(value={"multipart/form-data"})
    public String callImportService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, FormDataMultiPart form) {
        String string;
        ArrayList<FileImportObject> list = new ArrayList<FileImportObject>();
        try {
            Object parts;
            ServiceVersion.getInstance().debugLog("start import.");
            Map mapFormData = form.getFields();
            Set sets = mapFormData.keySet();
            for (String key : sets) {
                parts = (List)mapFormData.get(key);
                for (int i = 0; i < parts.size(); ++i) {
                    FormDataBodyPart part = (FormDataBodyPart)parts.get(i);
                    String filename = part.getContentDisposition().getFileName();
                    System.out.println(key + ":" + filename);
                    if (StringUtils.isEmpty((Object)filename)) continue;
                    FileImportObject fio = new FileImportObject();
                    fio.setFilename(filename);
                    fio.setStream((InputStream)part.getValueAs(InputStream.class));
                    fio.setServletrequest(this.request);
                    list.add(fio);
                }
            }
            param = URLDecoder.decode(param);
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            Object retdata = rcm.executeClassMethodForListParam(method, sessionobj, param = this.addQueryParamToJsonParam(sessionobj, param, "method", "session", "param"), list);
            if (retdata == null) {
                parts = "";
                return parts;
            }
            if (retdata instanceof String) {
                parts = (String)retdata;
                return parts;
            }
            parts = JSON.toJSONString((Object)Utils.toNormalJSONObject(retdata));
            return parts;
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            string = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            string = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return string;
        }
        finally {
            for (FileImportObject fio : list) {
                try {
                    InputStream in = fio.getStream();
                    if (in == null) continue;
                    in.close();
                }
                catch (Exception in) {}
            }
        }
    }

    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/exportbyfile")
    public Response callExportByFileService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @QueryParam(value="filename") String filename, @Context HttpHeaders headers) {
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param", "filename"));
            if (retdata == null) {
                return Response.ok((Object)"", (String)"text/plain;charset=UTF-8").build();
            }
            if (retdata instanceof ServiceResponse) {
                return Response.ok((Object)JSON.toJSONString((Object)retdata), (String)"text/plain;charset=UTF-8").build();
            }
            String headType = "application/octet-stream";
            String s = String.valueOf(retdata).toLowerCase();
            File fp = new File(s);
            filename = fp.getName();
            Response.ResponseBuilder builder = null;
            if (filename.endsWith(".xls") || filename.endsWith(".xlsx") || filename.endsWith(".rar") || filename.endsWith("txt")) {
                builder = Response.ok((Object)fp);
            } else {
                builder = Response.ok((Object)retdata);
                filename = "export.xls";
            }
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, filename));
            if (retdata instanceof String) {
                this.response.setCharacterEncoding("UTF-8");
                this.response.setContentType("text/plain");
                builder.type("application/octet-stream");
            } else {
                builder.type("application/octet-stream");
            }
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    @POST
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/export")
    public Response callExportService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @QueryParam(value="filename") String filename, @Context HttpHeaders headers) {
        try {
            Response.ResponseBuilder builder;
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param", "filename"));
            if (retdata == null) {
                return Response.ok((Object)"", (String)"text/plain;charset=UTF-8").build();
            }
            if (retdata instanceof ServiceResponse) {
                return Response.ok((Object)JSON.toJSONString((Object)retdata), (String)"text/plain;charset=UTF-8").build();
            }
            if (StringUtils.isEmpty((Object)filename)) {
                filename = "export.xls";
            }
            String headType = "application/octet-stream";
            if (retdata instanceof String) {
                String s = String.valueOf(retdata).toLowerCase();
                if (s.endsWith(".xls") || s.endsWith(".xlsx")) {
                    headType = "application/ms-excel";
                }
                builder = Response.ok((Object)retdata);
            } else {
                StringReader stream = new StringReader(retdata.toString());
                builder = Response.ok((Object)stream);
            }
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, filename));
            this.response.setCharacterEncoding("UTF-8");
            builder.type(headType);
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/exportocm")
    public Response callExportServiceOcm(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @QueryParam(value="filename") String filename, @Context HttpHeaders headers) {
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            JSONObject json = JSONObject.parseObject((String)postparam);
            File fp = new File(json.getString("filename"));
            System.out.println(fp.getAbsolutePath());
            InputStreamReader inputReader = null;
            FileInputStream inputStream = new FileInputStream(fp);
            inputReader = new InputStreamReader(inputStream);
            BufferedReader bufferReader = new BufferedReader(inputReader);
            String line = null;
            StringBuffer strBuffer = new StringBuffer();
            while ((line = bufferReader.readLine()) != null) {
                strBuffer.append(line).append("\r\n");
            }
            ((InputStream)inputStream).close();
            String retdata = strBuffer.toString();
            if (StringUtils.isEmpty((Object)filename)) {
                filename = postparam;
            }
            Response.ResponseBuilder builder = Response.ok((Object)retdata);
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, fp.getName()));
            this.response.setCharacterEncoding("UTF-8");
            builder.type("text/plain");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/exportTxt")
    public Response callExportServiceTxt(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @QueryParam(value="filename") String filename, @Context HttpHeaders headers) {
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            JSONObject json = JSONObject.parseObject((String)postparam);
            if (StringUtils.isEmpty((Object)filename)) {
                json.put("filename", (Object)"example");
            } else {
                json.put("filename", (Object)filename);
            }
            FileServiceImpl fileSrv = new FileServiceImpl();
            String fileaname = fileSrv.exportTxt(sessionobj, json);
            File fp = new File(fileaname);
            System.out.println(fp.getAbsolutePath());
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            this.response.reset();
            if (fp.exists() && fp.isFile()) {
                fp.delete();
            }
            Response.ResponseBuilder builder = Response.ok((Object)buffer);
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, fp.getName()));
            this.response.setCharacterEncoding("UTF-8");
            builder.type("application/octet-stream");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/export")
    public Response callExportServiceByGET(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, @QueryParam(value="filename") String filename, @Context HttpHeaders headers) {
        return this.callExportService(method, session, param, null, filename, headers);
    }

    @GET
    @Produces(value={"text/plain;charset=GBK"})
    @Path(value="/exportrar")
    public Response callExportServiceOcmrar(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @QueryParam(value="filename") String filename, @Context HttpHeaders headers) {
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            JSONObject json = JSONObject.parseObject((String)postparam);
            File fp = new File(json.getString("filename"));
            System.out.println(fp.getAbsolutePath());
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            this.response.reset();
            Response.ResponseBuilder builder = Response.ok((Object)buffer);
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, fp.getName()));
            this.response.setCharacterEncoding("GBK");
            builder.type("text/plain");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=GBK").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return Response.ok((Object)error, (String)"text/plain;charset=GBK").build();
        }
    }

    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/getphoto")
    public Response callGetphotoService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, @QueryParam(value="filename") String filename, @Context HttpHeaders headers) {
        try {
            String postparam = null;
            if (StringUtils.isEmpty(postparam)) {
                postparam = param;
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param", "filename"));
            if (retdata == null) {
                return Response.ok((Object)"", (String)"text/plain;charset=UTF-8").build();
            }
            if (retdata instanceof ServiceResponse) {
                return Response.ok((Object)JSON.toJSONString((Object)retdata)).build();
            }
            Response.ResponseBuilder builder = (Response.ResponseBuilder)retdata;
            return builder.build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return Response.ok((Object)Utils.getLastExceptionMessage(ex), (String)"text/plain;charset=UTF-8").build();
        }
    }

    private Map<String, Object> getParameters(Form form) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry entry : form.entrySet()) {
            List value = (List)entry.getValue();
            if (value.isEmpty()) continue;
            if (value.size() == 1) {
                result.put((String)entry.getKey(), value.get(0));
                continue;
            }
            result.put((String)entry.getKey(), value);
        }
        return result;
    }

    private String addParamToJsonParam(ServiceSession session, HttpContext context, String ... ignores) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] openkey = new String[]{"token", "access_token", "method", "app_key", "timestamp", "format", "ver", "version", "sign_method", "sign", "signature_method", "signature", "postid", "portalkey"};
        String[] ss = null;
        if (session != null) {
            int i;
            StringBuffer sb = new StringBuffer();
            String[] s = AbstractEntityBean.fetchAllDeclaredField(session.getClass(), sb).toString().split(",");
            ss = new String[openkey.length + s.length];
            for (i = 0; i < openkey.length; ++i) {
                ss[i] = openkey[i];
            }
            for (i = 0; i < s.length; ++i) {
                ss[openkey.length + i] = s[i];
            }
        } else {
            ss = openkey;
        }
        Map<String, String> rp = this.getParameter();
        String portalkey = DataUtils.nvl(rp.get("portalkey"), UserDataRangeSrv.getPortalkey());
        boolean iscongouportal = false;
        if (!StringUtils.isEmpty((Object)portalkey) && portalkey.equalsIgnoreCase("congou")) {
            iscongouportal = true;
        }
        Form form = context.getRequest().getFormParameters();
        Map<String, Object> rps = this.getParameters(form);
        map.putAll(rps);
        for (Map.Entry<String, String> entry : rp.entrySet()) {
            String[] values;
            String key = entry.getKey();
            if (Utils.stringArrayContainsKey(ignores, key, true) || (values = this.request.getParameterValues(key)) == null || values.length <= 0 || StringUtils.isEmpty((Object)values[0])) continue;
            String value = values[0];
            if (ss != null && Utils.stringArrayContainsKey(ss, key, true)) {
                if (iscongouportal) {
                    this.setSessionbycongou(session, key, value);
                    continue;
                }
                this.setSession(session, key, value);
                continue;
            }
            if (value.startsWith("{") && value.endsWith("}") || value.startsWith("[") && value.endsWith("]")) {
                try {
                    map.put(key, JSON.parse((String)value));
                }
                catch (Exception ex) {
                    map.put(key, value);
                }
                continue;
            }
            map.put(key, value);
        }
        if (SpringBeanFactory.containsBean("initSession_" + portalkey)) {
            InitSession init = SpringBeanFactory.getBean("initSession_" + portalkey, InitSession.class);
            init.init(session);
        }
        return JSONObject.toJSONString(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/restful")
    public String callRestServiceful(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, @Context HttpContext context) {
        String result = null;
        String remoteaddr = "";
        long logkey = 0L;
        String url = "";
        long start_time = System.currentTimeMillis();
        try {
            UserDataRangeSrv.setlocaltoken("");
            if (ServiceVersion.getInstance().isLogstatus()) {
                remoteaddr = this.getRemoteAddr();
                logkey = UniqueID.getUniqueID();
                url = this.request.getQueryString();
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            String postparam = this.addParamToJsonParam(sessionobj, context, "method", "session", "param");
            if (ServiceVersion.getInstance().isLogstatus()) {
                StringBuffer sb = new StringBuffer();
                sb.append("[" + remoteaddr + " - " + logkey + "]: ");
                sb.append(method + " , ");
                sb.append("REQUEST  : ");
                sb.append(postparam);
                sb.append(" , url : ");
                sb.append(url);
                ServiceVersion.getInstance().debugLog(sb.toString());
            }
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);
            long end_time = System.currentTimeMillis();
            if (retdata instanceof ServiceResponse) {
                ServiceResponse response = (ServiceResponse)retdata;
                response.addElapsed("\u603b\u8017\u65f6", start_time, end_time);
                if (sessionobj != null && !"Y".equalsIgnoreCase(sessionobj.getDebug_status())) {
                    if (!ServiceVersion.getInstance().isLogstatus()) {
                        response.setElapsed(null);
                    }
                    response.setWarnmsg(null);
                }
            }
            result = retdata == null ? "" : (retdata instanceof String ? (String)retdata : JSON.toJSONString((Object)Utils.toNormalJSONObject(retdata)));
            String string = result;
            return string;
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String string = result = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String string = result = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return string;
        }
        finally {
            if (ServiceVersion.getInstance().isLogstatus()) {
                StringBuffer sb = new StringBuffer();
                sb.append("[" + remoteaddr + " - " + logkey + "]: ");
                sb.append(method + " , ");
                sb.append("ELAPSED  : " + (System.currentTimeMillis() - start_time) + " ms , ");
                sb.append("RESPONSE : ");
                sb.append(result);
                ServiceVersion.getInstance().debugLog(sb.toString());
            }
            UserDataRangeSrv.setlocaltoken("");
        }
    }

    @GET
    @Produces(value={"application/json", "application/octet-stream"})
    @Path(value="/exportReport")
    public Response callExportReportExcelService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @Context HttpHeaders headers) {
        String remoteaddr = "";
        long logkey = 0L;
        String url = "";
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            UserDataRangeSrv.setlocaltoken("");
            if (ServiceVersion.getInstance().isLogstatus()) {
                remoteaddr = this.getRemoteAddr();
                logkey = UniqueID.getUniqueID();
                url = this.request.getQueryString();
            }
            ServiceSession sessionobj = null;
            if (StringUtils.isEmpty((Object)session)) {
                sessionobj = new ServiceSession();
            } else {
                try {
                    sessionobj = (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
                }
                catch (Exception ex1) {
                    try {
                        session = URLDecoder.decode(session, "UTF-8");
                        sessionobj = (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
                    }
                    catch (Exception ex2) {
                        throw new Exception("Session:" + session + ", Error:" + ex2.getMessage());
                    }
                }
            }
            postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param");
            JSONObject json = JSONObject.parseObject((String)postparam);
            sessionobj.setRemoteaddr(remoteaddr);
            sessionobj.setLogkey(String.valueOf(logkey));
            sessionobj.setMethod(method);
            if (StringUtils.isEmpty((Object)sessionobj.getParentkey())) {
                sessionobj.setParentkey(String.valueOf(logkey));
            }
            if (StringUtils.isEmpty((Object)sessionobj.getRootkey())) {
                sessionobj.setRootkey(String.valueOf(logkey));
            }
            sessionobj.setUrl(url);
            locale.set(sessionobj);
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);
            String fileaname = retdata.toString();
            File fp = new File(fileaname);
            System.out.println(fp.getAbsolutePath());
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            this.response.reset();
            if (fp.exists() && fp.isFile()) {
                fp.delete();
            }
            Response.ResponseBuilder builder = Response.ok((Object)buffer);
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, fp.getName()));
            this.response.setCharacterEncoding("UTF-8");
            builder.type("application/octet-stream");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces(value={"application/json", "application/octet-stream"})
    @Path(value="/exportExcelReport")
    public Response callExportOnlyReportExcelService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @Context HttpHeaders headers) {
        String remoteaddr = "";
        long logkey = 0L;
        String url = "";
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            UserDataRangeSrv.setlocaltoken("");
            if (ServiceVersion.getInstance().isLogstatus()) {
                remoteaddr = this.getRemoteAddr();
                logkey = UniqueID.getUniqueID();
                url = this.request.getQueryString();
            }
            ServiceSession sessionobj = null;
            if (StringUtils.isEmpty((Object)session)) {
                sessionobj = new ServiceSession();
            } else {
                try {
                    sessionobj = (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
                }
                catch (Exception ex1) {
                    try {
                        session = URLDecoder.decode(session, "UTF-8");
                        sessionobj = (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
                    }
                    catch (Exception ex2) {
                        throw new Exception("Session:" + session + ", Error:" + ex2.getMessage());
                    }
                }
            }
            postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param");
            JSONObject json = JSONObject.parseObject((String)postparam);
            sessionobj.setRemoteaddr(remoteaddr);
            sessionobj.setLogkey(String.valueOf(logkey));
            sessionobj.setMethod(method);
            if (StringUtils.isEmpty((Object)sessionobj.getParentkey())) {
                sessionobj.setParentkey(String.valueOf(logkey));
            }
            if (StringUtils.isEmpty((Object)sessionobj.getRootkey())) {
                sessionobj.setRootkey(String.valueOf(logkey));
            }
            sessionobj.setUrl(url);
            locale.set(sessionobj);
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);
            String fileaname = retdata.toString();
            File fp = new File(fileaname);
            System.out.println(fp.getAbsolutePath());
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            this.response.reset();
            if (fp.exists() && fp.isFile()) {
                fp.delete();
            }
            Response.ResponseBuilder builder = Response.ok((Object)buffer);
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, fp.getName()));
            this.response.setCharacterEncoding("UTF-8");
            builder.type("application/octet-stream");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces(value={"application/json", "application/octet-stream"})
    @Path(value="/exportExcel")
    public Response callExportExcelService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @Context HttpHeaders headers) {
        String remoteaddr = "";
        long logkey = 0L;
        String url = "";
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            UserDataRangeSrv.setlocaltoken("");
            if (ServiceVersion.getInstance().isLogstatus()) {
                remoteaddr = this.getRemoteAddr();
                logkey = UniqueID.getUniqueID();
                url = this.request.getQueryString();
            }
            ServiceSession sessionobj = null;
            if (StringUtils.isEmpty((Object)session)) {
                sessionobj = new ServiceSession();
            } else {
                try {
                    sessionobj = (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
                }
                catch (Exception ex1) {
                    try {
                        session = URLDecoder.decode(session, "UTF-8");
                        sessionobj = (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
                    }
                    catch (Exception ex2) {
                        throw new Exception("Session:" + session + ", Error:" + ex2.getMessage());
                    }
                }
            }
            postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param");
            JSONObject json = JSONObject.parseObject((String)postparam);
            sessionobj.setRemoteaddr(remoteaddr);
            sessionobj.setLogkey(String.valueOf(logkey));
            sessionobj.setMethod(method);
            if (StringUtils.isEmpty((Object)sessionobj.getParentkey())) {
                sessionobj.setParentkey(String.valueOf(logkey));
            }
            if (StringUtils.isEmpty((Object)sessionobj.getRootkey())) {
                sessionobj.setRootkey(String.valueOf(logkey));
            }
            sessionobj.setUrl(url);
            locale.set(sessionobj);
            FileServiceImpl temp = new FileServiceImpl();
            String fileaname = temp.export(sessionobj, json);
            File fp = new File(fileaname);
            System.out.println(fp.getAbsolutePath());
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            this.response.reset();
            if (fp.exists() && fp.isFile()) {
                fp.delete();
            }
            Response.ResponseBuilder builder = Response.ok((Object)buffer);
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, fp.getName()));
            this.response.setCharacterEncoding("UTF-8");
            builder.type("application/octet-stream");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces(value={"application/json", "application/octet-stream"})
    @Path(value="/exportTemplate")
    public Response callExportTemplateService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @Context HttpHeaders headers) {
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            JSONObject json = JSONObject.parseObject((String)postparam);
            FileServiceImpl temp = new FileServiceImpl();
            String fileaname = temp.exportTemplate(sessionobj, json);
            File fp = new File(fileaname);
            System.out.println(fp.getAbsolutePath());
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            this.response.reset();
            if (fp.exists() && fp.isFile()) {
                fp.delete();
            }
            Response.ResponseBuilder builder = Response.ok((Object)buffer);
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, fp.getName()));
            this.response.setCharacterEncoding("UTF-8");
            builder.type("application/octet-stream");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces(value={"application/json", "application/octet-stream"})
    @Path(value="/exportLC")
    public Response callExportLCService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @Context HttpHeaders headers) {
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            JSONObject json = JSONObject.parseObject((String)postparam);
            FileServiceImpl temp = new FileServiceImpl();
            String fileaname = temp.exportLC(sessionobj, json);
            File fp = new File(fileaname);
            System.out.println(fp.getAbsolutePath());
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            this.response.reset();
            if (fp.exists() && fp.isFile()) {
                fp.delete();
            }
            Response.ResponseBuilder builder = Response.ok((Object)buffer);
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, fp.getName()));
            this.response.setCharacterEncoding("UTF-8");
            builder.type("application/octet-stream");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces(value={"application/json", "application/octet-stream"})
    @Path(value="/exportNC")
    public Response callExportNCService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @Context HttpHeaders headers) {
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            JSONObject json = JSONObject.parseObject((String)postparam);
            FileServiceImpl temp = new FileServiceImpl();
            String fileaname = temp.exportNC(sessionobj, json);
            File fp = new File(fileaname);
            System.out.println(fp.getAbsolutePath());
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            this.response.reset();
            if (fp.exists() && fp.isFile()) {
                fp.delete();
            }
            Response.ResponseBuilder builder = Response.ok((Object)buffer);
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, fp.getName()));
            this.response.setCharacterEncoding("UTF-8");
            builder.type("application/octet-stream");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces(value={"application/json", "application/octet-stream"})
    @Path(value="/exportPrint")
    public Response callExportPrintService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @Context HttpHeaders headers) {
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            JSONObject json = JSONObject.parseObject((String)postparam);
            String fileaname = json.getString("data");
            File fp = new File(fileaname);
            System.out.println(fp.getAbsolutePath());
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            this.response.reset();
            if (fp.exists() && fp.isFile()) {
                fp.delete();
            }
            Response.ResponseBuilder builder = Response.ok((Object)buffer);
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, fp.getName()));
            this.response.setCharacterEncoding("UTF-8");
            builder.type("application/octet-stream");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/createExcel")
    public String callcreateExcelService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam) {
        String result = null;
        String remoteaddr = "";
        String rtncode = "0";
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            JSONObject json = JSONObject.parseObject((String)postparam);
            FileServiceImpl temp = new FileServiceImpl();
            String retdata = temp.exportExcelPrint(sessionobj, json);
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("data", retdata);
            m.put("returncode", rtncode);
            String string = result = JSON.toJSONString((Object)Utils.toNormalJSONObject(m));
            return string;
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            result = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            rtncode = ex.getErrorCode();
            String string = result;
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            result = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            rtncode = "555";
            String string = result;
            return string;
        }
        finally {
            locale.remove();
        }
    }

    @GET
    @Produces(value={"application/json", "application/octet-stream"})
    @Path(value="/previewPdf")
    public Response callPreviewPdfService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @Context HttpHeaders headers) {
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param", "filename"));
            ServiceResponse resultParam = (ServiceResponse)retdata;
            JSONObject para = (JSONObject)resultParam.getData();
            if (!"1".equals(para.getString("flag"))) {
                return (Response)retdata;
            }
            String filename = para.getString("filename");
            File file = new File(filename);
            System.out.println(file.getAbsolutePath());
            this.response.reset();
            this.response.setDateHeader("Expires", 0L);
            this.response.setCharacterEncoding("UTF-8");
            FileInputStream fileInputStream = new FileInputStream(file);
            this.response.setHeader("Content-Type", "application/pdf");
            String dispositio = Utils.builderContentDispositionFileName(headers, file.getName());
            dispositio = dispositio.replace("attachment", "inline");
            this.response.addHeader("Content-Disposition", dispositio);
            ServletOutputStream outputStream = this.response.getOutputStream();
            IOUtils.write((byte[])IOUtils.toByteArray((InputStream)fileInputStream), (OutputStream)outputStream);
            outputStream.flush();
            outputStream.close();
            fileInputStream.close();
            if (file.exists() && file.isFile()) {
                boolean result = file.delete();
                int tryCount = 0;
                while (!result && tryCount++ < 10) {
                    System.gc();
                    result = file.delete();
                }
            }
            return null;
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces(value={"text/plain;charset=GBK"})
    @Path(value="/exportcustomrar")
    public Response callExportServiceOcmCustomrar(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @Context HttpHeaders headers) {
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param", "filename");
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);
            ServiceResponse resultParam = (ServiceResponse)retdata;
            JSONObject para = (JSONObject)resultParam.getData();
            String filename = para.getString("filename");
            File file = new File(filename);
            System.out.println(file.getAbsolutePath());
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file.getPath()));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            this.response.reset();
            if (file.exists() && file.isFile()) {
                boolean result = file.delete();
                int tryCount = 0;
                while (!result && tryCount++ < 10) {
                    System.gc();
                    result = file.delete();
                }
            }
            Response.ResponseBuilder builder = Response.ok((Object)buffer);
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, file.getName()));
            this.response.setCharacterEncoding("GBK");
            builder.type("text/plain");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=GBK").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return Response.ok((Object)error, (String)"text/plain;charset=GBK").build();
        }
    }

    @GET
    @Produces(value={"application/json", "application/octet-stream"})
    @Path(value="/exportComplexExcel")
    public Response callExportComplexExcelService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @Context HttpHeaders headers) {
        String remoteaddr = "";
        long logkey = 0L;
        String url = "";
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            UserDataRangeSrv.setlocaltoken("");
            if (ServiceVersion.getInstance().isLogstatus()) {
                remoteaddr = this.getRemoteAddr();
                logkey = UniqueID.getUniqueID();
                url = this.request.getQueryString();
            }
            ServiceSession sessionobj = null;
            if (StringUtils.isEmpty((Object)session)) {
                sessionobj = new ServiceSession();
            } else {
                try {
                    sessionobj = (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
                }
                catch (Exception ex1) {
                    try {
                        session = URLDecoder.decode(session, "UTF-8");
                        sessionobj = (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
                    }
                    catch (Exception ex2) {
                        throw new Exception("Session:" + session + ", Error:" + ex2.getMessage());
                    }
                }
            }
            postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param");
            JSONObject json = JSONObject.parseObject((String)postparam);
            sessionobj.setRemoteaddr(remoteaddr);
            sessionobj.setLogkey(String.valueOf(logkey));
            sessionobj.setMethod(method);
            if (StringUtils.isEmpty((Object)sessionobj.getParentkey())) {
                sessionobj.setParentkey(String.valueOf(logkey));
            }
            if (StringUtils.isEmpty((Object)sessionobj.getRootkey())) {
                sessionobj.setRootkey(String.valueOf(logkey));
            }
            sessionobj.setUrl(url);
            locale.set(sessionobj);
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);
            ServiceResponse resultParam = (ServiceResponse)retdata;
            JSONObject para = (JSONObject)resultParam.getData();
            ArrayList<Map<String, Object>> report = (ArrayList<Map<String, Object>>)para.get((Object)"report");
            if (report == null) {
                report = new ArrayList<Map<String, Object>>();
            }
            FileServiceImpl fileSrv = new FileServiceImpl();
            String fileaname = fileSrv.exportComplex(sessionobj, json, report);
            File fp = new File(fileaname);
            System.out.println(fp.getAbsolutePath());
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            this.response.reset();
            if (fp.exists() && fp.isFile()) {
                fp.delete();
            }
            Response.ResponseBuilder builder = Response.ok((Object)buffer);
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, fp.getName()));
            this.response.setCharacterEncoding("UTF-8");
            builder.type("application/octet-stream");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    @POST
    @Path(value="/xload/upload/mongo/bill/{systemid}")
    @Produces(value={"text/plain;charset=UTF-8"})
    @Consumes(value={"multipart/form-data"})
    public Response upLoadFile4bill(FormDataMultiPart form, @PathParam(value="systemid") String systemid, @QueryParam(value="param") String param) throws Exception {
        MssFileService res = (MssFileService)SpringBeanFactory.getBean("fileservice");
        this.setEnt_id();
        return res.upLoadFile4bill(form, systemid, param);
    }

    @GET
    @Path(value="/xload/download/mongo")
    @Produces(value={"application/json", "application/octet-stream"})
    public Response downloadMongo(@QueryParam(value="data") String data, @QueryParam(value="usercode") String usercode, @QueryParam(value="username") String username, @QueryParam(value="name") String name, @Context HttpHeaders headers) throws Exception {
        MssFileService res = (MssFileService)SpringBeanFactory.getBean("fileservice");
        this.setEnt_id();
        return res.downloadMongo(data, usercode, username, name, headers);
    }

    @GET
    @Path(value="/xload/delete/mongo")
    @Produces(value={"application/json", "application/octet-stream"})
    public Response deleteMongoDBFile(@QueryParam(value="token") String token, @QueryParam(value="fileKey") String fileKey, @QueryParam(value="billno") String billno, @QueryParam(value="billmoduleid") String billmoduleid, @QueryParam(value="usercode") String usercode, @QueryParam(value="username") String username, @QueryParam(value="notdelfile") String notdelfile) throws Exception {
        MssFileService res = (MssFileService)SpringBeanFactory.getBean("fileservice");
        this.setEnt_id();
        return res.deleteMongoDBFile(token, fileKey, billno, billmoduleid, usercode, username, notdelfile);
    }

    @GET
    @Path(value="/xload/download/data")
    @Produces(value={"application/json", "application/octet-stream"})
    public Response getData(@QueryParam(value="billno") String billno, @QueryParam(value="billmoduleid") String billmoduleid) throws Exception {
        MssFileService res = (MssFileService)SpringBeanFactory.getBean("fileservice");
        this.setEnt_id();
        return res.getData(billno, billmoduleid);
    }

    @GET
    @Path(value="/xload/download/Pdf")
    @Produces(value={"application/json", "application/octet-stream"})
    public Response downloadPdf(@QueryParam(value="data") String data, @QueryParam(value="name") String name, @Context HttpHeaders headers) throws Exception {
        MssFileService res = (MssFileService)SpringBeanFactory.getBean("fileservice");
        this.setEnt_id();
        return res.downloadPdf(data, name, headers, this.response);
    }

    @GET
    @Path(value="/xload/download/mongo/image/{token}/{fileKey}")
    @Produces(value={"image/gif"})
    public Response downloadMongodbImage(@PathParam(value="token") String token, @PathParam(value="fileKey") String fileKey) throws Exception {
        MssFileService res = (MssFileService)SpringBeanFactory.getBean("fileservice");
        this.setEnt_id();
        return res.downloadMongodbImage(token, fileKey);
    }

    @GET
    @Path(value="/exportFile")
    @Produces(value={"application/json", "application/octet-stream"})
    public Response exportFile(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, @Context HttpHeaders headers) throws Exception {
        Response.ResponseBuilder builder = null;
        JSONObject param2 = JSON.parseObject((String)param);
        param2.put("filepathhead", (Object)this.request.getSession().getServletContext().getRealPath("/"));
        String temp = this.callRestService(method, session, param2.toJSONString(), null);
        if (temp == null || StringUtils.isEmpty((Object)temp)) {
            return Response.ok((Object)"\u4e0b\u8f7d\u5931\u8d25", (String)"text/plain;charset=UTF-8").build();
        }
        JSONObject result = JSON.parseObject((String)temp);
        JSONObject jsonparam = JSON.parseObject((String)param);
        String contentDisposition = "attachment; ";
        if (!result.containsKey((Object)"filename") || StringUtils.isEmpty((Object)result.getString("filename"))) {
            return Response.ok((Object)"\u4e0b\u8f7d\u5931\u8d25", (String)"text/plain;charset=UTF-8").build();
        }
        String filename = result.getString("filename");
        String browser = headers.getRequestHeader("User-Agent").toString();
        byte[] buffer = null;
        contentDisposition = browser != null && browser.toLowerCase().indexOf("firefox") > 0 ? contentDisposition + "filename*=UTF-8''" + filename : contentDisposition + "filename=" + filename;
        if (!(result.containsKey((Object)"filepath") && !StringUtils.isEmpty((Object)result.get((Object)"filepath")) || result.containsKey((Object)"file") && !StringUtils.isEmpty((Object)result.get((Object)"file")))) {
            return Response.ok((Object)"\u4e0b\u8f7d\u5931\u8d25", (String)"text/plain;charset=UTF-8").build();
        }
        if (!StringUtils.isEmpty((Object)result.get((Object)"filepath"))) {
            File fp = new File(result.getString("filepath"));
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
            buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            if (fp.exists() && fp.isFile()) {
                fp.delete();
            }
        } else {
            buffer = result.getBytes("file");
        }
        builder = !StringUtils.isEmpty((Object)jsonparam.get((Object)"encoded")) ? Response.ok((Object)new String(buffer, jsonparam.getString("encoded"))) : (filename.endsWith("txt") || filename.endsWith("TXT") ? Response.ok((Object)new String(buffer, "GBK")) : Response.ok((Object)buffer));
        builder.header("Content-Disposition", (Object)contentDisposition);
        builder.type("application/octet-stream");
        return builder.build();
    }

    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/exportgroup")
    public Response callExportServiceGrpGET(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, @QueryParam(value="filename") String filename, @Context HttpHeaders headers) {
        return this.callExportServiceGrpPost(method, session, param, null, filename, headers);
    }

    @POST
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/exportgroup")
    public Response callExportServiceGrpPost(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @QueryParam(value="filename") String filename, @Context HttpHeaders headers) {
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param", "filename"));
            if (retdata == null) {
                return Response.ok((Object)"", (String)"text/plain;charset=UTF-8").build();
            }
            if (retdata instanceof ServiceResponse) {
                return Response.ok((Object)JSON.toJSONString((Object)retdata), (String)"text/plain;charset=UTF-8").build();
            }
            if (StringUtils.isEmpty((Object)filename)) {
                filename = "custgroup.xls";
            }
            String headType = "application/octet-stream";
            String s = String.valueOf(retdata).toLowerCase();
            if (s.endsWith(".xls") || s.endsWith(".xlsx")) {
                headType = "application/ms-excel";
            }
            File fp = new File(s);
            filename = fp.getName();
            Response.ResponseBuilder builder = Response.ok((Object)fp);
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, filename));
            this.response.setCharacterEncoding("UTF-8");
            builder.type(headType);
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/captcha")
    @Produces(value={"application/octet-stream"})
    public Response previewCaptcha(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, @Context HttpHeaders headers, @Context HttpContext context) throws Exception {
        JSONObject data;
        long start_time = System.currentTimeMillis();
        ServiceSession sessionobj = null;
        sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
        String postparam = this.addParamToJsonParam(sessionobj, context.getRequest().getFormParameters(), "method", "session", "param");
        this.response.setDateHeader("Expires", 0L);
        this.response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        this.response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        this.response.setHeader("Pragma", "no-cache");
        this.response.setContentType("image/jpeg");
        Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);
        if (retdata instanceof ServiceResponse && ((ServiceResponse)retdata).getReturncode().equals("0") && (data = (JSONObject)((ServiceResponse)retdata).getData()).containsKey((Object)"capBuff") && data.get((Object)"capBuff") instanceof BufferedImage) {
            BufferedImage bi = (BufferedImage)data.get((Object)"capBuff");
            ServletOutputStream out = this.response.getOutputStream();
            ImageIO.write((RenderedImage)bi, "jpg", (OutputStream)out);
            try {
                out.flush();
            }
            finally {
                out.close();
            }
        }
        return null;
    }

    private String addParamToJsonParam(ServiceSession session, Form form, String ... ignores) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] openkey = new String[]{"token", "access_token", "method", "app_key", "timestamp", "format", "ver", "version", "sign_method", "sign", "signature_method", "signature", "postid", "portalkey"};
        String[] ss = null;
        if (session != null) {
            int i;
            StringBuffer sb = new StringBuffer();
            String[] s = AbstractEntityBean.fetchAllDeclaredField(session.getClass(), sb).toString().split(",");
            ss = new String[openkey.length + s.length];
            for (i = 0; i < openkey.length; ++i) {
                ss[i] = openkey[i];
            }
            for (i = 0; i < s.length; ++i) {
                ss[openkey.length + i] = s[i];
            }
        } else {
            ss = openkey;
        }
        Map<String, String> rp = this.getParameter();
        String portalkey = UserDataRangeSrv.getPortalkey();
        boolean iscongouportal = false;
        if (!StringUtils.isEmpty((Object)portalkey) && portalkey.equalsIgnoreCase("congou")) {
            iscongouportal = true;
        }
        Map<String, Object> rps = this.getParameters(form);
        map.putAll(rps);
        for (Map.Entry<String, String> entry : rp.entrySet()) {
            String[] values;
            String key = entry.getKey();
            if (Utils.stringArrayContainsKey(ignores, key, true) || (values = this.request.getParameterValues(key)) == null || values.length <= 0 || StringUtils.isEmpty((Object)values[0])) continue;
            String value = values[0];
            if (ss != null && Utils.stringArrayContainsKey(ss, key, true)) {
                if (iscongouportal) {
                    this.setSessionbycongou(session, key, value);
                    continue;
                }
                this.setSession(session, key, value);
                continue;
            }
            if (value.startsWith("{") && value.endsWith("}") || value.startsWith("[") && value.endsWith("]")) {
                try {
                    map.put(key, JSON.parse((String)value));
                }
                catch (Exception ex) {
                    map.put(key, value);
                }
                continue;
            }
            map.put(key, value);
        }
        if (SpringBeanFactory.containsBean("initSession_" + portalkey)) {
            InitSession init = SpringBeanFactory.getBean("initSession_" + portalkey, InitSession.class);
            init.init(session);
        }
        return JSONObject.toJSONString(map);
    }

    @GET
    @Produces(value={"application/json", "application/octet-stream"})
    @Path(value="/exportVoucher")
    public Response callExportVoucherService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @Context HttpHeaders headers) {
        String remoteaddr = "";
        long logkey = 0L;
        String url = "";
        try {
            if (StringUtils.isEmpty((Object)postparam)) {
                postparam = param;
            }
            if (UrlEncoderUtils.hasUrlEncoded(postparam)) {
                postparam = URLDecoder.decode(postparam);
            }
            ServiceSession sessionobj = null;
            sessionobj = StringUtils.isEmpty((Object)session) ? new ServiceSession() : (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
            postparam = this.addQueryParamToJsonParam(sessionobj, postparam, "method", "session", "param");
            JSONObject json = JSONObject.parseObject((String)postparam);
            sessionobj.setRemoteaddr(remoteaddr);
            sessionobj.setLogkey(String.valueOf(logkey));
            sessionobj.setMethod(method);
            if (StringUtils.isEmpty((Object)sessionobj.getParentkey())) {
                sessionobj.setParentkey(String.valueOf(logkey));
            }
            if (StringUtils.isEmpty((Object)sessionobj.getRootkey())) {
                sessionobj.setRootkey(String.valueOf(logkey));
            }
            sessionobj.setUrl(url);
            locale.set(sessionobj);
            Object retdata = rcm.executeClassMethod(method, sessionobj, postparam);
            ServiceResponse resultParam = (ServiceResponse)retdata;
            JSONObject para = (JSONObject)resultParam.getData();
            String fileaname = para.getString("filename");
            File fp = new File(fileaname);
            System.out.println(fp.getAbsolutePath());
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(fp.getPath()));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            this.response.reset();
            if (fp.exists() && fp.isFile()) {
                fp.delete();
            }
            Response.ResponseBuilder builder = Response.ok((Object)buffer);
            builder.header("Pragma", (Object)"No-cache");
            builder.header("Cache-Control", (Object)"No-cache");
            this.response.setDateHeader("Expires", 0L);
            builder.header("Content-Disposition", (Object)Utils.builderContentDispositionFileName(headers, fp.getName()));
            this.response.setCharacterEncoding("UTF-8");
            builder.type("application/octet-stream");
            return builder.build();
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String error = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "50000", Utils.getLastExceptionMessage(ex), new Object[0]));
            return Response.ok((Object)error, (String)"text/plain;charset=UTF-8").build();
        }
    }

    @GET
    @Produces(value={"application/json", "application/octet-stream"})
    @Path(value="/exportFlow")
    public Response callExportFlowService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam, @Context HttpHeaders headers) {
        return this.callExportVoucherService(method, session, param, postparam, headers);
    }

    private void setEnt_id() {
        String ent_id = "";
        if (this.request.getQueryString() != null) {
            String[] params = this.request.getQueryString().split("&");
            JSONObject temp = new JSONObject();
            for (String param : params) {
                String[] keyValue = param.split("=");
                if (!"ent_id".equals(keyValue[0])) continue;
                ent_id = keyValue[1];
                break;
            }
        } else {
            ent_id = "0";
        }
        if (!StringUtils.isEmpty((Object)ent_id)) {
            ServiceRestReflect.getLocale().get().setEnt_id(Long.parseLong(ent_id));
        }
    }

    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/wxLoginCallback")
    public void weCharloginCallback(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param) throws ServletException, IOException {
        JSONObject jsonparam = new JSONObject();
        jsonparam.put("code", (Object)this.request.getParameter("code"));
        jsonparam.put("userType", (Object)this.request.getParameter("userType"));
        jsonparam.put("userCode", (Object)this.request.getParameter("userCode"));
        this.callRestService(method, session, param, null);
        this.response.sendRedirect("/mall-message-ui/pages/message/auth/auth-ok.html");
    }

    /*
     * Exception decompiling
     */
    @POST
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/asyncExport")
    public String callAsyncExportRestService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, String postparam) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

