/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.rest;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.util.DataUtils;
import com.efuture.ocp.common.util.DateUtils;
import com.efuture.ocp.common.util.EnviromentUtil;
import com.efuture.ocp.common.util.NetworkUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class ServiceVersion {
    Logger logger = Logger.getLogger(ServiceVersion.class);
    boolean logstatus;
    String logformat;
    String ver;
    String sinceTime = DateUtils.getNowStr();
    Map<String, JSONObject> elapsed = new TreeMap<String, JSONObject>();
    long[] elapsedStep = new long[]{200L, 300L, 500L, 1000L, 3000L, 5000L};
    String[] elapsedKeys = new String[]{"<=200", "200-300", "300-500", "500-1000", "1000-3000", "3000-5000", ">5000"};

    public String getLogFormat() {
        if (this.logformat == null) {
            return "default";
        }
        return this.logformat;
    }

    public void setLogFormat(String logFormat) {
        this.logformat = logFormat;
    }

    public ServiceVersion(String version, String openlog) {
        this.ver = version;
        this.logstatus = openlog.equalsIgnoreCase("y");
        this.setLogFormat("default");
    }

    public ServiceVersion(String version, String openlog, String logformat) {
        this.ver = version;
        this.logstatus = openlog.equalsIgnoreCase("y");
        this.setLogFormat(logformat);
    }

    public ServiceVersion(String version) {
        this.ver = version;
    }

    public String getVer() {
        return this.ver;
    }

    public boolean isLogstatus() {
        return this.logstatus;
    }

    public void setLogstatus(boolean logstatus) {
        this.logstatus = logstatus;
    }

    public void debugLog(Object message) {
        if (this.logstatus) {
            this.logger.info(message);
        }
    }

    public String getStartupTime() {
        return this.sinceTime;
    }

    public Map<String, JSONObject> getElapsed() {
        return this.elapsed;
    }

    public void setElapsed(Map<String, JSONObject> elapsed) {
        this.elapsed = elapsed;
    }

    public String printElapsed() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<style>");
        sb.append("table{border:1px solid #cad9ea;text-align:center;cellspacing:0px;cellpadding:50px} ");
        sb.append("table th{border:1px solid #cad9ea;text-align:center;cellspacing:0px;cellpadding:50px} ");
        sb.append("table tr td{border:1px solid #cad9ea;text-align:center;cellspacing:0px;cellpadding:50px} ");
        sb.append("</style>");
        String[] active = EnviromentUtil.getEnv().getActiveProfiles();
        if (active != null && active.length > 0) {
            sb.append("Active:&ensp;").append(active[0]).append("<br>");
        }
        sb.append("IPAddr: ").append(NetworkUtils.getLocalIP()).append("<br>");
        sb.append("Port:&ensp;&ensp;&ensp;").append(NetworkUtils.getLocalPort()).append("<br>");
        sb.append("Since:&ensp;&ensp;").append(this.sinceTime).append("<br>");
        sb.append("<TABLE>");
        boolean printHeader = false;
        for (Map.Entry<String, JSONObject> entry : this.elapsed.entrySet()) {
            if (!printHeader) {
                sb.append("<tr style='background-color: #CCE8EB;'>");
                sb.append("<td rowspan=2>\u65b9\u6cd5</td>");
                sb.append("<td rowspan=2>\u8c03\u7528\u6b21\u6570</td>");
                sb.append("<td rowspan=2>\u7d2f\u8ba1\u8017\u65f6</td>");
                sb.append("<td rowspan=2>\u5e73\u5747\u8017\u65f6</td>");
                sb.append("<td colspan=" + String.valueOf(this.elapsedKeys.length) + ">\u5206\u6bb5\u7edf\u8ba1</td>");
                sb.append("</tr><tr style='background-color: #CCE8EB'>");
                for (String s : this.elapsedKeys) {
                    sb.append("<td>");
                    sb.append(s);
                    sb.append("</td>");
                }
                sb.append("</tr><tr>");
                printHeader = true;
            } else {
                sb.append("<tr>");
            }
            sb.append("<td style='text-align:left'>" + entry.getKey() + "</td>");
            sb.append("<td>" + DataUtils.getJsonData(entry.getValue(), "num", false, "0") + "</td>");
            sb.append("<td>" + DataUtils.getJsonData(entry.getValue(), "tot", false, "0") + "</td>");
            sb.append("<td>" + DataUtils.getJsonData(entry.getValue(), "avg", false, "0") + "</td>");
            for (String s : this.elapsedKeys) {
                sb.append("<td>");
                sb.append(DataUtils.getJsonData(entry.getValue(), s, false, "&nbsp;"));
                sb.append("</td>");
            }
            sb.append("</tr>");
        }
        sb.append("<TABLE>");
        return sb.toString();
    }

    public synchronized void writeElapsed(String key, long time) {
        try {
            if (time <= 0L) {
                return;
            }
            JSONObject json = this.elapsed.get(key);
            if (json == null) {
                json = new JSONObject();
                json.put("num", (Object)1);
                json.put("tot", (Object)time);
                json.put("avg", (Object)time);
                this.elapsed.put(key, json);
            } else {
                json.put("num", (Object)(json.getLong("num") + 1L));
                json.put("tot", (Object)(json.getLong("tot") + time));
                json.put("avg", (Object)(json.getLong("tot") / json.getLong("num")));
            }
            boolean exist = false;
            for (int i = 0; i < this.elapsedStep.length; ++i) {
                String str;
                if (time > this.elapsedStep[i]) continue;
                String string = str = i > 0 ? this.elapsedStep[i - 1] + "-" + this.elapsedStep[i] : "<=" + this.elapsedStep[i];
                if (json.containsKey((Object)str)) {
                    json.put(str, (Object)(json.getLong(str) + 1L));
                } else {
                    json.put(str, (Object)1);
                }
                exist = true;
                break;
            }
            if (!exist) {
                String str = ">" + this.elapsedStep[this.elapsedStep.length - 1];
                if (json.containsKey((Object)str)) {
                    json.put(str, (Object)(json.getLong(str) + 1L));
                } else {
                    json.put(str, (Object)1);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void cleanElapsed() throws Exception {
        this.elapsed.clear();
    }

    public static ServiceVersion getInstance() {
        ServiceVersion sv = SpringBeanFactory.getBean("ServiceVersion", ServiceVersion.class);
        return sv;
    }

    public static String getVersion() {
        return ServiceVersion.getInstance().getVer();
    }
}

