/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.slice.filter;

import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlOutputVisitor;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleOutputVisitor;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.filter.FtSqlSource;
import com.efuture.ocp.common.slice.filter.CollectionSliceWrapper;
import com.efuture.ocp.common.slice.filter.ExecutorCallback;
import com.efuture.ocp.common.slice.filter.SliceBase;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Invocation;
import org.slf4j.Logger;

public class CollectionSelectWrapper
extends CollectionSliceWrapper {
    protected void onSelectStatement(Logger logger, String sqlStatement, JSONObject logJson, Invocation invocation, MappedStatement mappedStatement, BoundSql boundSql, SQLStatement stmt, ExecutorCallback callback) throws Throwable {
        SQLSelectStatement selectStmt = (SQLSelectStatement)stmt;
        logJson.put("selectSql", (Object)sqlStatement);
        if (selectStmt.getSelect().getQuery() instanceof SQLUnionQuery) {
            logJson.put("result", (Object)this.getUnionSqlInfo((SQLUnionQuery)selectStmt.getSelect().getQuery(), 1, callback));
        } else {
            logJson.put("result", (Object)this.getSqlInfo((SQLSelectQuery)((SQLSelectQueryBlock)selectStmt.getSelect().getQuery()), callback));
        }
        StringBuffer newSql = new StringBuffer();
        MySqlOutputVisitor visitor = null;
        if (this.getDbType().equals("mysql")) {
            visitor = new MySqlOutputVisitor((Appendable)newSql);
        } else if (this.getDbType().equals("oracle")) {
            visitor = new OracleOutputVisitor((Appendable)newSql);
        } else {
            throw new Exception("\u672a\u8bc6\u522b\u7684dbType");
        }
        visitor.visit(selectStmt);
        visitor.println();
        visitor.endVisit(selectStmt);
        FtSqlSource sqlSource = new FtSqlSource(mappedStatement.getConfiguration(), newSql.toString(), boundSql);
        MappedStatement newMs = this.copyFromMappedStatement(mappedStatement, sqlSource);
        invocation.getArgs()[0] = newMs;
        logJson.put("newSql", (Object)newSql.toString());
        Object parameter = null;
        if (invocation.getArgs().length > 1) {
            parameter = invocation.getArgs()[SliceBase.PARAMETER_INDEX];
        }
        BoundSql newBoundSql = newMs.getBoundSql(parameter);
        if (invocation.getArgs().length == 6) {
            invocation.getArgs()[SliceBase.MAPPED_STATEMENT_INDEX] = newMs;
            invocation.getArgs()[SliceBase.BOUNDSQL_INDEX] = newBoundSql;
        }
        if (sqlStatement.equalsIgnoreCase(parameter.toString())) {
            invocation.getArgs()[SliceBase.PARAMETER_INDEX] = newBoundSql.getSql();
        }
        logJson.put("newSql", (Object)newSql.toString());
        String newStatement = newBoundSql.getSql();
        String message = String.format("newSQL --->%1$s--->Params:%2$s--->Thread:%3$s", newStatement.replaceAll("[\\s]+", " "), parameter == null ? "<none>" : JSON.toJSONString((Object)parameter), "");
        CollectionSelectWrapper.sliceFilterLog(message, new Object[0]);
    }
}

